/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.catalogs;

import it.grid.storm.catalogs.InvalidSurlRequestDataAttributesException;
import it.grid.storm.catalogs.RequestData;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TStatusCode;
import java.util.Map;
import org.slf4j.Logger;

public abstract class SurlRequestData
implements RequestData {
    protected TSURL SURL;
    protected TReturnStatus status;

    public SurlRequestData(TSURL toSURL, TReturnStatus status) throws InvalidSurlRequestDataAttributesException {
        if (toSURL == null || status == null || status.getStatusCode() == null) {
            throw new InvalidSurlRequestDataAttributesException(toSURL, status);
        }
        this.SURL = toSURL;
        this.status = status;
    }

    protected abstract Logger getLog();

    @Override
    public final TSURL getSURL() {
        return this.SURL;
    }

    @Override
    public final TReturnStatus getStatus() {
        return this.status;
    }

    public void setStatus(TReturnStatus newstat) {
        if (newstat != null) {
            this.status = newstat;
        }
    }

    protected void setStatus(TStatusCode statusCode, String explanation) {
        try {
            this.status = explanation == null ? new TReturnStatus(statusCode) : new TReturnStatus(statusCode, explanation);
        }
        catch (InvalidTReturnStatusAttributeException e) {
            this.getLog().warn("UNEXPECTED ERROR! Unable to set SRM request status to SRM_ABORTED! " + e);
        }
    }

    @Override
    public final void changeStatusSRM_REQUEST_QUEUED(String explanation) {
        this.setStatus(TStatusCode.SRM_REQUEST_QUEUED, explanation);
    }

    @Override
    public final void changeStatusSRM_REQUEST_INPROGRESS(String explanation) {
        this.setStatus(TStatusCode.SRM_REQUEST_INPROGRESS, explanation);
    }

    @Override
    public final void changeStatusSRM_SUCCESS(String explanation) {
        this.setStatus(TStatusCode.SRM_SUCCESS, explanation);
    }

    @Override
    public final void changeStatusSRM_INTERNAL_ERROR(String explanation) {
        this.setStatus(TStatusCode.SRM_INTERNAL_ERROR, explanation);
    }

    @Override
    public final void changeStatusSRM_INVALID_REQUEST(String explanation) {
        this.setStatus(TStatusCode.SRM_INVALID_REQUEST, explanation);
    }

    @Override
    public final void changeStatusSRM_AUTHORIZATION_FAILURE(String explanation) {
        this.setStatus(TStatusCode.SRM_AUTHORIZATION_FAILURE, explanation);
    }

    @Override
    public final void changeStatusSRM_ABORTED(String explanation) {
        this.setStatus(TStatusCode.SRM_ABORTED, explanation);
    }

    @Override
    public final void changeStatusSRM_FILE_BUSY(String explanation) {
        this.setStatus(TStatusCode.SRM_FILE_BUSY, explanation);
    }

    @Override
    public final void changeStatusSRM_INVALID_PATH(String explanation) {
        this.setStatus(TStatusCode.SRM_INVALID_PATH, explanation);
    }

    @Override
    public final void changeStatusSRM_NOT_SUPPORTED(String explanation) {
        this.setStatus(TStatusCode.SRM_NOT_SUPPORTED, explanation);
    }

    @Override
    public final void changeStatusSRM_FAILURE(String explanation) {
        this.setStatus(TStatusCode.SRM_FAILURE, explanation);
    }

    @Override
    public final void changeStatusSRM_SPACE_LIFETIME_EXPIRED(String explanation) {
        this.setStatus(TStatusCode.SRM_SPACE_LIFETIME_EXPIRED, explanation);
    }

    @Override
    public String display(Map<?, ?> map) {
        return "";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.SURL == null ? 0 : this.SURL.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SurlRequestData other = (SurlRequestData)obj;
        if (this.SURL == null ? other.SURL != null : !this.SURL.equals(other.SURL)) {
            return false;
        }
        return !(this.status == null ? other.status != null : !this.status.equals(other.status));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SurlRequestData [SURL=");
        builder.append(this.SURL);
        builder.append(", status=");
        builder.append(this.status);
        builder.append("]");
        return builder.toString();
    }
}

