/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.catalogs;

import it.grid.storm.catalogs.InvalidSurlRequestDataAttributesException;
import it.grid.storm.catalogs.PersistentChunkData;
import it.grid.storm.catalogs.SurlRequestData;
import it.grid.storm.catalogs.SynchMultyOperationRequestData;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.synchcall.data.IdentityInputData;
import it.grid.storm.synchcall.surl.ExpiredTokenException;
import it.grid.storm.synchcall.surl.SurlStatusStore;
import it.grid.storm.synchcall.surl.TokenDuplicationException;
import it.grid.storm.synchcall.surl.UnknownSurlException;
import it.grid.storm.synchcall.surl.UnknownTokenException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SurlMultyOperationRequestData
extends SurlRequestData
implements SynchMultyOperationRequestData {
    private static final Logger log = LoggerFactory.getLogger(SurlMultyOperationRequestData.class);
    private TRequestToken generatedRequestToken = TRequestToken.getRandom();
    private boolean stored = false;

    public SurlMultyOperationRequestData(TSURL surl, TReturnStatus status) throws InvalidSurlRequestDataAttributesException {
        super(surl, status);
    }

    @Override
    public synchronized void store() {
        if (!this.stored) {
            try {
                while (!this.stored) {
                    try {
                        if (this instanceof IdentityInputData) {
                            SurlStatusStore.getInstance().store(this.generatedRequestToken, ((IdentityInputData)((Object)this)).getUser(), SurlMultyOperationRequestData.buildSurlStatusMap(this.SURL, this.status.getStatusCode(), this.status.getExplanation()));
                        } else {
                            SurlStatusStore.getInstance().store(this.generatedRequestToken, SurlMultyOperationRequestData.buildSurlStatusMap(this.SURL, this.status.getStatusCode(), this.status.getExplanation()));
                        }
                        this.stored = true;
                    }
                    catch (TokenDuplicationException e) {
                        this.generatedRequestToken = TRequestToken.getRandom();
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Unexpected IllegalArgumentException: " + e.getMessage());
            }
        }
    }

    private static HashMap<TSURL, TReturnStatus> buildSurlStatusMap(TSURL surl, TStatusCode code, String explanation) throws IllegalArgumentException {
        if (surl == null || code == null) {
            throw new IllegalArgumentException("Unable to build the status, null arguments: surl=" + surl + " statusCode=" + (Object)((Object)code));
        }
        HashMap<TSURL, TReturnStatus> surlStatusMap = new HashMap<TSURL, TReturnStatus>(1);
        surlStatusMap.put(surl, SurlMultyOperationRequestData.buildStatus(code, explanation));
        return surlStatusMap;
    }

    private static TReturnStatus buildStatus(TStatusCode statusCode, String explaination) throws IllegalArgumentException, IllegalStateException {
        if (statusCode == null) {
            throw new IllegalArgumentException("Unable to build the status, null arguments: statusCode=" + (Object)((Object)statusCode));
        }
        try {
            return new TReturnStatus(statusCode, explaination);
        }
        catch (InvalidTReturnStatusAttributeException e1) {
            throw new IllegalStateException("Unexpected InvalidTReturnStatusAttributeException in building TReturnStatus: " + e1.getMessage());
        }
    }

    @Override
    public TRequestToken getGeneratedRequestToken() {
        return this.generatedRequestToken;
    }

    @Override
    public TRequestToken getRequestToken() {
        return this.getGeneratedRequestToken();
    }

    @Override
    public final void setStatus(TReturnStatus status) {
        super.setStatus(status);
        if (!(this instanceof PersistentChunkData)) {
            try {
                if (status.getExplanation() == null) {
                    SurlStatusStore.getInstance().update(this.generatedRequestToken, this.SURL, status.getStatusCode());
                } else {
                    SurlStatusStore.getInstance().update(this.generatedRequestToken, this.SURL, status.getStatusCode(), status.getExplanation());
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Unexpected IllegalArgumentException in updating status store: " + e.getMessage());
            }
            catch (UnknownTokenException e) {
                log.warn("Received an UnknownTokenException, probably the token has expired, unable to update its status in the store : " + e.getMessage());
            }
            catch (ExpiredTokenException e) {
                log.warn("Received an ExpiredTokenException. The token is expired, unable to update its status in the store : " + e.getMessage());
            }
            catch (UnknownSurlException e) {
                log.warn("Received an UnknownSurlException, probably the token has expired, unable to update its status in the store : " + e.getMessage());
            }
        }
    }

    @Override
    protected final void setStatus(TStatusCode statusCode, String explanation) {
        super.setStatus(statusCode, explanation);
        if (!(this instanceof PersistentChunkData)) {
            try {
                if (explanation == null) {
                    SurlStatusStore.getInstance().update(this.generatedRequestToken, this.SURL, statusCode);
                } else {
                    SurlStatusStore.getInstance().update(this.generatedRequestToken, this.SURL, statusCode, explanation);
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Unexpected IllegalArgumentException in updating status store: " + e.getMessage());
            }
            catch (UnknownTokenException e) {
                log.warn("Received an UnknownTokenException, probably the token has expired, unable to update its status in the store : " + e.getMessage());
            }
            catch (ExpiredTokenException e) {
                log.warn("Received an ExpiredTokenException. The token is expired, unable to update its status in the store : " + e.getMessage());
            }
            catch (UnknownSurlException e) {
                log.warn("Received an UnknownSurlException, probably the token has expired, unable to update its status in the store : " + e.getMessage());
            }
        }
    }
}

