/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.catalogs;

import it.grid.storm.catalogs.InvalidRetrievedDataException;
import it.grid.storm.catalogs.MultipleDataEntriesException;
import it.grid.storm.catalogs.NoDataFoundException;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.persistence.DAOFactory;
import it.grid.storm.persistence.PersistenceDirector;
import it.grid.storm.persistence.dao.StorageSpaceDAO;
import it.grid.storm.persistence.exceptions.DataAccessException;
import it.grid.storm.persistence.model.StorageSpaceTO;
import it.grid.storm.persistence.model.TransferObjectDecodingException;
import it.grid.storm.space.StorageSpaceData;
import it.grid.storm.srm.types.ArrayOfTSpaceToken;
import it.grid.storm.srm.types.InvalidTSpaceTokenAttributesException;
import it.grid.storm.srm.types.TSpaceToken;
import java.io.File;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReservedSpaceCatalog {
    private static final Logger log = LoggerFactory.getLogger(ReservedSpaceCatalog.class);
    private static HashSet<TSpaceToken> voSA_spaceTokenSet = new HashSet();
    private static HashMap<TSpaceToken, Date> voSA_UpdateTime = new HashMap();
    private static final long NOT_INITIALIZED_SIZE_VALUE = -1L;
    private final DAOFactory daoFactory;
    private StorageSpaceDAO ssDAO;

    public static void addSpaceToken(TSpaceToken token) {
        voSA_spaceTokenSet.add(token);
        voSA_UpdateTime.put(token, null);
    }

    public static HashSet<TSpaceToken> getTokenSet() {
        return voSA_spaceTokenSet;
    }

    public static void clearTokenSet() {
        voSA_spaceTokenSet.clear();
        voSA_UpdateTime.clear();
    }

    public static void setUpdateTime(TSpaceToken token, Date updateTime) {
        if (voSA_UpdateTime.containsKey(token)) {
            voSA_UpdateTime.put(token, updateTime);
        } else {
            log.warn("Failing while Trying to set update time in Catalog cache.");
        }
    }

    public static Date getUpdateTime(TSpaceToken token) {
        Date result = null;
        if (voSA_UpdateTime.containsKey(token)) {
            result = voSA_UpdateTime.get(token);
        } else {
            log.warn("Failing while Trying to set update time in Catalog cache.");
        }
        return result;
    }

    public ReservedSpaceCatalog() {
        log.debug("Building Reserve Space Catalog...");
        this.daoFactory = PersistenceDirector.getDAOFactory();
    }

    public StorageSpaceData getStorageSpace(TSpaceToken spaceToken) throws TransferObjectDecodingException, DataAccessException {
        StorageSpaceData result = null;
        this.ssDAO = this.daoFactory.getStorageSpaceDAO();
        log.debug("Storage Space DAO retrieved.");
        StorageSpaceTO ssTO = this.ssDAO.getStorageSpaceByToken(spaceToken.getValue());
        log.debug("Storage Space retrieved by Token. ");
        if (ssTO != null) {
            try {
                result = new StorageSpaceData(ssTO);
            }
            catch (IllegalArgumentException e) {
                log.error("Error building StorageSpaceData from StorageSpaceTO IllegalArgumentException: " + e.getLocalizedMessage());
                throw new TransferObjectDecodingException("Unable to build StorageSpaceData from StorageSpaceTO");
            }
        } else {
            log.info("Unable to build StorageSpaceData. No StorageSpaceTO built from the DB");
        }
        return result;
    }

    public void addStorageSpace(StorageSpaceData ssd) throws DataAccessException {
        log.debug("ADD StorageSpace Start...");
        StorageSpaceTO ssTO = new StorageSpaceTO(ssd);
        log.debug("Storage Space TO Created");
        ssTO.setUpdateTime(new Date());
        this.ssDAO = this.daoFactory.getStorageSpaceDAO();
        log.debug("Storage Space DAO retrieved.");
        this.ssDAO.addStorageSpace(ssTO);
        log.debug("StorageSpaceTO inserted in Persistence");
    }

    public void updateStorageSpace(StorageSpaceData ssd) {
        this.updateStorageSpace(ssd, null);
    }

    public void updateStorageSpace(StorageSpaceData ssd, Date updateTime) {
        try {
            this.ssDAO = this.daoFactory.getStorageSpaceDAO();
            log.debug("Storage Space DAO retrieved.");
        }
        catch (DataAccessException daEx) {
            log.error("Error while retrieving StorageSpaceDAO.", (Throwable)daEx);
        }
        StorageSpaceTO ssTO = new StorageSpaceTO(ssd);
        log.debug("Storage Space TO Created");
        if (updateTime == null) {
            ssTO.setUpdateTime(new Date());
        } else {
            ssTO.setUpdateTime(updateTime);
        }
        try {
            this.ssDAO.updateStorageSpace(ssTO);
            log.debug("StorageSpaceTO updated in Persistence");
        }
        catch (DataAccessException daEx) {
            log.error("Error while inserting new row in StorageSpace", (Throwable)daEx);
        }
    }

    public void updateStorageSpaceFreeSpace(StorageSpaceData ssd) throws DataAccessException {
        this.ssDAO = this.daoFactory.getStorageSpaceDAO();
        log.debug("Storage Space DAO retrieved.");
        StorageSpaceTO ssTO = new StorageSpaceTO(ssd);
        log.debug("Storage Space TO Created");
        ssTO.setUpdateTime(new Date());
        this.ssDAO.updateStorageSpaceFreeSpace(ssTO);
        log.debug("StorageSpaceTO updated in Persistence");
    }

    public void updateAllStorageSpace(StorageSpaceData ssd) throws NoDataFoundException, InvalidRetrievedDataException, MultipleDataEntriesException {
        this.updateAllStorageSpace(ssd, null);
    }

    public void updateAllStorageSpace(StorageSpaceData ssd, Date updateTime) throws NoDataFoundException, InvalidRetrievedDataException, MultipleDataEntriesException {
        log.debug("UPDATE StorageSpace Start...");
        StorageSpaceTO ssTO = new StorageSpaceTO(ssd);
        log.debug("Storage Space TO Created");
        if (updateTime == null) {
            ssTO.setUpdateTime(new Date());
        } else {
            ssTO.setUpdateTime(updateTime);
        }
        try {
            this.ssDAO = this.daoFactory.getStorageSpaceDAO();
            log.debug("Storage Space DAO retrieved.");
        }
        catch (DataAccessException daEx) {
            log.error("Error while retrieving StorageSpaceDAO.", (Throwable)daEx);
        }
        try {
            this.ssDAO.updateAllStorageSpace(ssTO);
            log.debug("StorageSpaceTO updated in Persistence");
        }
        catch (DataAccessException daEx) {
            log.error("Error while inserting new row in StorageSpace", (Throwable)daEx);
        }
    }

    public StorageSpaceData getStorageSpaceByAlias(String desc) {
        StorageSpaceData result = null;
        log.debug("Retrieve Storage Space start... ");
        try {
            this.ssDAO = this.daoFactory.getStorageSpaceDAO();
            log.debug("Storage Space DAO retrieved.");
        }
        catch (DataAccessException daEx) {
            log.debug("Error while retrieving StorageSpaceDAO.", (Throwable)daEx);
        }
        try {
            Collection<StorageSpaceTO> cl = this.ssDAO.getStorageSpaceByAliasOnly(desc);
            if (cl != null && !cl.isEmpty()) {
                log.debug("Storage Space retrieved by Token. ");
                try {
                    result = new StorageSpaceData(cl.toArray(new StorageSpaceTO[0])[0]);
                }
                catch (IllegalArgumentException e) {
                    log.error("unable to build StorageSpaceData from StorageSpaceTO IllegalArgumentException: " + e.getLocalizedMessage());
                }
            }
        }
        catch (DataAccessException daEx) {
            log.debug("Error while retrieving StorageSpace", (Throwable)daEx);
        }
        return result;
    }

    public List<StorageSpaceData> getStorageSpaceNotInitialized() {
        log.debug("Retrieve Storage Space not initialized start ");
        LinkedList<StorageSpaceData> result = new LinkedList<StorageSpaceData>();
        try {
            this.ssDAO = this.daoFactory.getStorageSpaceDAO();
            log.debug("Storage Space DAO retrieved.");
        }
        catch (DataAccessException daEx) {
            log.debug("Error while retrieving StorageSpaceDAO.", (Throwable)daEx);
        }
        try {
            Collection<StorageSpaceTO> storagesSpaceTOCollection = this.ssDAO.getStorageSpaceByUnavailableUsedSpace(-1L);
            log.debug("Storage Space retrieved by not initialized used space. ");
            for (StorageSpaceTO storagesSpaceTO : storagesSpaceTOCollection) {
                if (storagesSpaceTO != null) {
                    try {
                        result.add(new StorageSpaceData(storagesSpaceTO));
                    }
                    catch (IllegalArgumentException e) {
                        log.error("unable to build StorageSpaceData from StorageSpaceTO IllegalArgumentException: " + e.getLocalizedMessage());
                    }
                    continue;
                }
                log.warn("Received a collection of StorageSpaceTO containing null elements, skipping them");
            }
        }
        catch (DataAccessException daEx) {
            log.debug("Error while retrieving StorageSpace", (Throwable)daEx);
        }
        return result;
    }

    public List<StorageSpaceData> getStorageSpaceByLastUpdate(Date lastUpdateTimestamp) {
        log.debug("Retrieve Storage Space not initialized start ");
        LinkedList<StorageSpaceData> result = new LinkedList<StorageSpaceData>();
        try {
            this.ssDAO = this.daoFactory.getStorageSpaceDAO();
            log.debug("Storage Space DAO retrieved.");
        }
        catch (DataAccessException daEx) {
            log.debug("Error while retrieving StorageSpaceDAO.", (Throwable)daEx);
        }
        try {
            Collection<StorageSpaceTO> storagesSpaceTOCollection = this.ssDAO.getStorageSpaceByPreviousLastUpdate(lastUpdateTimestamp);
            log.debug("Storage Space retrieved by Token previous last update. ");
            for (StorageSpaceTO storagesSpaceTO : storagesSpaceTOCollection) {
                if (storagesSpaceTO != null) {
                    try {
                        result.add(new StorageSpaceData(storagesSpaceTO));
                    }
                    catch (IllegalArgumentException e) {
                        log.error("unable to build StorageSpaceData from StorageSpaceTO IllegalArgumentException: " + e.getLocalizedMessage());
                    }
                    continue;
                }
                log.warn("Received a collection of StorageSpaceTO containing null elements, skipping them");
            }
        }
        catch (DataAccessException daEx) {
            log.debug("Error while retrieving StorageSpace", (Throwable)daEx);
        }
        return result;
    }

    public ArrayOfTSpaceToken getSpaceTokens(GridUserInterface user, String spaceAlias) {
        ArrayOfTSpaceToken result = new ArrayOfTSpaceToken();
        log.debug("Retrieving space tokens...");
        try {
            this.ssDAO = this.daoFactory.getStorageSpaceDAO();
            log.debug("Storage Space DAO retrieved.");
        }
        catch (DataAccessException daEx) {
            log.error("Error while retrieving StorageSpaceDAO.", (Throwable)daEx);
        }
        try {
            Collection<StorageSpaceTO> listOfStorageSpace = this.ssDAO.getStorageSpaceByOwner(user, spaceAlias);
            int nItems = listOfStorageSpace.size();
            log.debug("getSpaceTokens : Number of Storage spaces retrieved with Alias '" + spaceAlias + "': " + nItems);
            for (StorageSpaceTO ssTO : listOfStorageSpace) {
                try {
                    TSpaceToken spaceToken = TSpaceToken.make(ssTO.getSpaceToken());
                    result.addTSpaceToken(spaceToken);
                }
                catch (InvalidTSpaceTokenAttributesException ex2) {
                    log.error("Retrieved invalid Space token from DB");
                }
            }
        }
        catch (DataAccessException daEx) {
            log.error("Error while retrieving StorageSpace", (Throwable)daEx);
        }
        catch (Exception e) {
            log.error("Exception while retrieving Storage Space", (Throwable)e);
        }
        return result;
    }

    public ArrayOfTSpaceToken getSpaceTokensByAlias(String spaceAlias) {
        ArrayOfTSpaceToken result = new ArrayOfTSpaceToken();
        log.debug("Retrieving space tokens...");
        try {
            this.ssDAO = this.daoFactory.getStorageSpaceDAO();
            log.debug("Storage Space DAO retrieved.");
        }
        catch (DataAccessException daEx) {
            log.error("Error while retrieving StorageSpaceDAO.", (Throwable)daEx);
        }
        try {
            Collection<StorageSpaceTO> listOfStorageSpace = this.ssDAO.getStorageSpaceByAliasOnly(spaceAlias);
            int nItems = listOfStorageSpace.size();
            log.debug("Number of Storage spaces retrieved: " + nItems);
            for (StorageSpaceTO ssTO : listOfStorageSpace) {
                try {
                    TSpaceToken spaceToken = TSpaceToken.make(ssTO.getSpaceToken());
                    result.addTSpaceToken(spaceToken);
                }
                catch (InvalidTSpaceTokenAttributesException ex2) {
                    log.error("Retrieved invalid Space token from DB");
                }
            }
        }
        catch (DataAccessException daEx) {
            log.error("Error while retrieving StorageSpace", (Throwable)daEx);
        }
        catch (Exception e) {
            log.error("Error getting data!", (Throwable)e);
        }
        return result;
    }

    public ArrayOfTSpaceToken getSpaceTokensBySpaceType(String stype) {
        ArrayOfTSpaceToken result = new ArrayOfTSpaceToken();
        log.debug("Retrieving space tokens...");
        try {
            this.ssDAO = this.daoFactory.getStorageSpaceDAO();
            log.debug("Storage Space DAO retrieved.");
        }
        catch (DataAccessException daEx) {
            log.error("Error while retrieving StorageSpaceDAO.", (Throwable)daEx);
        }
        try {
            Collection<StorageSpaceTO> listOfStorageSpace = this.ssDAO.getStorageSpaceBySpaceType(stype);
            int nItems = listOfStorageSpace.size();
            log.debug("Number of Storage spaces retrieved: " + nItems);
            for (StorageSpaceTO ssTO : listOfStorageSpace) {
                try {
                    TSpaceToken spaceToken = TSpaceToken.make(ssTO.getSpaceToken());
                    result.addTSpaceToken(spaceToken);
                }
                catch (InvalidTSpaceTokenAttributesException ex2) {
                    log.error("Retrieved invalid Space token from DB");
                }
            }
        }
        catch (DataAccessException daEx) {
            log.error("Error while retrieving StorageSpace", (Throwable)daEx);
        }
        catch (Exception e) {
            log.error("Generic Error while retrieving StorageSpace", (Throwable)e);
        }
        return result;
    }

    public boolean release(GridUserInterface user, TSpaceToken spaceToken) {
        log.debug("Delete storage spaceToken info from persistence: " + spaceToken);
        try {
            this.ssDAO = this.daoFactory.getStorageSpaceDAO();
            log.debug("Storage Space DAO retrieved.");
        }
        catch (DataAccessException daEx) {
            log.error("Error while retrieving StorageSpaceDAO.", (Throwable)daEx);
        }
        boolean rowRemoved = true;
        try {
            this.ssDAO.removeStorageSpace(user, spaceToken.getValue());
            log.debug("spaceToken removed from DB.");
        }
        catch (DataAccessException daEx) {
            log.error("spaceToken not found in the DB: " + spaceToken.getValue());
            rowRemoved = false;
        }
        return rowRemoved;
    }

    public void purge() {
        Collection<StorageSpaceTO> expiredSpaceTO;
        log.debug("Space Garbage Collector start!");
        Calendar rightNow = Calendar.getInstance();
        try {
            this.ssDAO = this.daoFactory.getStorageSpaceDAO();
            log.debug("Storage Space DAO retrieved.");
        }
        catch (DataAccessException daEx) {
            log.error("Error while retrieving StorageSpaceDAO.", (Throwable)daEx);
        }
        try {
            expiredSpaceTO = this.ssDAO.getExpired(rightNow.getTimeInMillis() / 1000L);
        }
        catch (DataAccessException e) {
            log.info("Space Garbage Collector: no space expired found.");
            return;
        }
        StorageSpaceTO spaceTO2 = null;
        log.debug("Space Garbage Collector: Number of SpaceFile to remove " + expiredSpaceTO.size() + ".");
        for (StorageSpaceTO spaceTO2 : expiredSpaceTO) {
            String spaceFileName = spaceTO2.getSpaceFile();
            File sfile = new File(spaceFileName);
            log.debug("Space Garbage Collector: SpaceFile to remove " + spaceFileName + ".");
            if (sfile.delete()) {
                log.debug("Space Garbage Collector: SpaceFile " + spaceFileName + " removed.");
            } else {
                log.warn("Space Garbage Collector: problem removing " + spaceFileName + "!");
            }
            try {
                this.ssDAO.removeStorageSpace(spaceTO2.getSpaceToken());
            }
            catch (DataAccessException e) {
                log.warn("Space Garbage Collector: error removing space entry from catalog.");
            }
        }
    }
}

