/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.catalogs;

import it.grid.storm.catalogs.RequestSummaryDataTO;
import it.grid.storm.catalogs.RequestTypeConverter;
import it.grid.storm.catalogs.StatusCodeConverter;
import it.grid.storm.config.Configuration;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TRequestType;
import it.grid.storm.srm.types.TStatusCode;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestSummaryDAO {
    private static final Logger log = LoggerFactory.getLogger(RequestSummaryDAO.class);
    private final String driver = Configuration.getInstance().getDBDriver();
    private final String url = Configuration.getInstance().getDBURL();
    private final String password = Configuration.getInstance().getDBPassword();
    private final String name = Configuration.getInstance().getDBUserName();
    private int limit;
    private Connection con = null;
    private final long period = Configuration.getInstance().getDBReconnectPeriod() * 1000L;
    private final long delay = Configuration.getInstance().getDBReconnectDelay() * 1000L;
    private Timer clock = null;
    private TimerTask clockTask = null;
    private boolean reconnect = false;
    private static final RequestSummaryDAO dao = new RequestSummaryDAO();

    private RequestSummaryDAO() {
        int aux = Configuration.getInstance().getPickingMaxBatchSize();
        this.limit = aux > 1 ? aux : 1;
        this.setUpConnection();
        this.clock = new Timer();
        this.clockTask = new TimerTask(){

            @Override
            public void run() {
                RequestSummaryDAO.this.reconnect = true;
            }
        };
        this.clock.scheduleAtFixedRate(this.clockTask, this.delay, this.period);
    }

    public static RequestSummaryDAO getInstance() {
        return dao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RequestSummaryDataTO> findNew(int freeSlot) {
        PreparedStatement stmt2 = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<RequestSummaryDataTO> list = new ArrayList<RequestSummaryDataTO>();
        if (!this.checkConnection()) {
            log.error("REQUEST SUMMARY DAO - findNew: unable to get a valid connection!");
            return list;
        }
        try {
            this.con.setAutoCommit(false);
            int howMuch = -1;
            howMuch = freeSlot > this.limit ? this.limit : freeSlot;
            stmt = this.con.createStatement();
            this.logWarnings(this.con.getWarnings());
            String query = "SELECT ID, config_RequestTypeID, r_token, timeStamp, client_dn, proxy FROM request_queue WHERE status=" + StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_REQUEST_QUEUED) + " LIMIT " + howMuch;
            rs = stmt.executeQuery(query);
            this.logWarnings(stmt.getWarnings());
            ArrayList<Long> rowids = new ArrayList<Long>();
            RequestSummaryDataTO aux = null;
            while (rs.next()) {
                long auxid = rs.getLong("ID");
                rowids.add(new Long(auxid));
                aux = new RequestSummaryDataTO();
                aux.setPrimaryKey(auxid);
                aux.setRequestType(rs.getString("config_RequestTypeID"));
                aux.setRequestToken(rs.getString("r_token"));
                aux.setClientDN(rs.getString("client_dn"));
                aux.setTimestamp(rs.getTimestamp("timeStamp"));
                Blob blob = rs.getBlob("proxy");
                if (blob != null) {
                    byte[] bdata = blob.getBytes(1L, (int)blob.length());
                    aux.setVomsAttributes(new String(bdata));
                }
                list.add(aux);
            }
            this.close(rs);
            this.close(stmt);
            if (!list.isEmpty()) {
                this.logWarnings(this.con.getWarnings());
                String where = this.makeWhereString(rowids);
                String update = "UPDATE request_queue SET status=" + StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_REQUEST_INPROGRESS) + ", errstring=?" + " WHERE ID IN " + where;
                stmt2 = this.con.prepareStatement(update);
                this.logWarnings(stmt2.getWarnings());
                stmt2.setString(1, "Request handled!");
                this.logWarnings(stmt2.getWarnings());
                log.trace("REQUEST SUMMARY DAO - findNew: executing " + stmt2);
                stmt2.executeUpdate();
                this.close(stmt2);
            }
            this.con.commit();
            this.logWarnings(this.con.getWarnings());
            this.con.setAutoCommit(true);
            this.logWarnings(this.con.getWarnings());
            this.close(rs);
            this.close(stmt);
            this.close(stmt2);
        }
        catch (SQLException e) {
            try {
                log.error("REQUEST SUMMARY DAO - findNew: Unable to complete picking... rolling back! " + e);
                this.rollback(this.con);
                this.close(rs);
                this.close(stmt);
                this.close(stmt2);
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(stmt);
                this.close(stmt2);
                throw throwable;
            }
        }
        if (!list.isEmpty()) {
            log.debug("REQUEST SUMMARY DAO - findNew: returning " + list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failRequest(long index, String explanation) {
        if (!this.checkConnection()) {
            log.error("REQUEST SUMMARY DAO - failRequest: unable to get a valid connection!");
            return;
        }
        String signalSQL = "UPDATE request_queue r SET r.status=" + StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_FAILURE) + ", r.errstring=? " + "WHERE r.ID=?";
        PreparedStatement signal = null;
        try {
            signal = this.con.prepareStatement(signalSQL);
            this.logWarnings(this.con.getWarnings());
            signal.setString(1, explanation);
            this.logWarnings(signal.getWarnings());
            signal.setLong(2, index);
            this.logWarnings(signal.getWarnings());
            log.trace("REQUEST SUMMARY DAO! failRequest executing: " + signal);
            signal.executeUpdate();
            this.logWarnings(signal.getWarnings());
        }
        catch (SQLException e) {
            log.error("REQUEST SUMMARY DAO! Unable to transit request identified by ID " + index + " to SRM_FAILURE! Exception: " + e.toString());
        }
        finally {
            this.close(signal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failPtGRequest(long index, String explanation) {
        if (!this.checkConnection()) {
            log.error("REQUEST SUMMARY DAO - failPtGRequest: unable to get a valid connection!");
            return;
        }
        String requestSQL = "UPDATE request_queue r SET r.status=?, r.errstring=? WHERE r.ID=?";
        String chunkSQL = "UPDATE status_Get s JOIN (request_queue r, request_Get g) ON s.request_GetID=g.ID AND g.request_queueID=r.ID SET s.statusCode=?, s.explanation=? WHERE r.ID=?";
        PreparedStatement request = null;
        PreparedStatement chunk = null;
        int failCode = StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_FAILURE);
        try {
            this.con.setAutoCommit(false);
            request = this.con.prepareStatement(requestSQL);
            this.logWarnings(this.con.getWarnings());
            request.setInt(1, failCode);
            this.logWarnings(request.getWarnings());
            request.setString(2, explanation);
            this.logWarnings(request.getWarnings());
            request.setLong(3, index);
            this.logWarnings(request.getWarnings());
            log.trace("REQUEST SUMMARY DAO! failPtGRequest executing: " + request);
            request.executeUpdate();
            this.logWarnings(request.getWarnings());
            chunk = this.con.prepareStatement(chunkSQL);
            this.logWarnings(this.con.getWarnings());
            chunk.setInt(1, failCode);
            this.logWarnings(chunk.getWarnings());
            chunk.setString(2, explanation);
            this.logWarnings(chunk.getWarnings());
            chunk.setLong(3, index);
            this.logWarnings(chunk.getWarnings());
            log.trace("REQUEST SUMMARY DAO! failPtGRequest executing: " + chunk);
            chunk.executeUpdate();
            this.logWarnings(chunk.getWarnings());
            this.con.commit();
            this.logWarnings(this.con.getWarnings());
            this.con.setAutoCommit(true);
            this.logWarnings(this.con.getWarnings());
            this.close(request);
            this.close(chunk);
        }
        catch (SQLException e) {
            try {
                log.error("REQUEST SUMMARY DAO! Unable to transit PtG request identified by ID " + index + " to SRM_FAILURE! Exception: " + e.toString() + "\nRolling back...");
                this.rollback(this.con);
                this.close(request);
                this.close(chunk);
            }
            catch (Throwable throwable) {
                this.close(request);
                this.close(chunk);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failPtPRequest(long index, String explanation) {
        if (!this.checkConnection()) {
            log.error("REQUEST SUMMARY DAO - failPtPRequest: unable to get a valid connection!");
            return;
        }
        String requestSQL = "UPDATE request_queue r SET r.status=?, r.errstring=? WHERE r.ID=?";
        String chunkSQL = "UPDATE status_Put s JOIN (request_queue r, request_Put p) ON s.request_PutID=p.ID AND p.request_queueID=r.ID SET s.statusCode=?, s.explanation=? WHERE r.ID=?";
        PreparedStatement request = null;
        PreparedStatement chunk = null;
        int failCode = StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_FAILURE);
        try {
            this.con.setAutoCommit(false);
            request = this.con.prepareStatement(requestSQL);
            this.logWarnings(this.con.getWarnings());
            request.setInt(1, failCode);
            this.logWarnings(request.getWarnings());
            request.setString(2, explanation);
            this.logWarnings(request.getWarnings());
            request.setLong(3, index);
            this.logWarnings(request.getWarnings());
            log.trace("REQUEST SUMMARY DAO! failPtPRequest executing: " + request);
            request.executeUpdate();
            this.logWarnings(request.getWarnings());
            chunk = this.con.prepareStatement(chunkSQL);
            this.logWarnings(this.con.getWarnings());
            chunk.setInt(1, failCode);
            this.logWarnings(chunk.getWarnings());
            chunk.setString(2, explanation);
            this.logWarnings(chunk.getWarnings());
            chunk.setLong(3, index);
            this.logWarnings(chunk.getWarnings());
            log.trace("REQUEST SUMMARY DAO! failPtPRequest executing: " + chunk);
            chunk.executeUpdate();
            this.logWarnings(chunk.getWarnings());
            this.con.commit();
            this.logWarnings(this.con.getWarnings());
            this.con.setAutoCommit(true);
            this.logWarnings(this.con.getWarnings());
            this.close(request);
            this.close(chunk);
        }
        catch (SQLException e) {
            try {
                log.error("REQUEST SUMMARY DAO! Unable to transit PtP request identified by ID " + index + " to SRM_FAILURE! Exception: " + e.toString() + "\nRolling back...");
                this.rollback(this.con);
                this.close(request);
                this.close(chunk);
            }
            catch (Throwable throwable) {
                this.close(request);
                this.close(chunk);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failCopyRequest(long index, String explanation) {
        if (!this.checkConnection()) {
            log.error("REQUEST SUMMARY DAO - failCopyRequest: unable to get a valid connection!");
            return;
        }
        String requestSQL = "UPDATE request_queue r SET r.status=?, r.errstring=? WHERE r.ID=?";
        String chunkSQL = "UPDATE status_Copy s JOIN (request_queue r, request_Copy c) ON s.request_CopyID=c.ID AND c.request_queueID=r.ID SET s.statusCode=?, s.explanation=? WHERE r.ID=?";
        PreparedStatement request = null;
        PreparedStatement chunk = null;
        int failCode = StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_FAILURE);
        try {
            this.con.setAutoCommit(false);
            request = this.con.prepareStatement(requestSQL);
            this.logWarnings(this.con.getWarnings());
            request.setInt(1, failCode);
            this.logWarnings(request.getWarnings());
            request.setString(2, explanation);
            this.logWarnings(request.getWarnings());
            request.setLong(3, index);
            this.logWarnings(request.getWarnings());
            log.trace("REQUEST SUMMARY DAO! failCopyRequest executing: " + request);
            request.executeUpdate();
            this.logWarnings(request.getWarnings());
            chunk = this.con.prepareStatement(chunkSQL);
            this.logWarnings(this.con.getWarnings());
            chunk.setInt(1, failCode);
            this.logWarnings(chunk.getWarnings());
            chunk.setString(2, explanation);
            this.logWarnings(chunk.getWarnings());
            chunk.setLong(3, index);
            this.logWarnings(chunk.getWarnings());
            log.trace("REQUEST SUMMARY DAO! failCopyRequest executing: " + chunk);
            chunk.executeUpdate();
            this.logWarnings(chunk.getWarnings());
            this.con.commit();
            this.logWarnings(this.con.getWarnings());
            this.con.setAutoCommit(true);
            this.logWarnings(this.con.getWarnings());
            this.close(request);
            this.close(chunk);
        }
        catch (SQLException e) {
            try {
                log.error("REQUEST SUMMARY DAO! Unable to transit Copy request identified by ID " + index + " to SRM_FAILURE! Exception: " + e.toString() + "\nRolling back...");
                this.rollback(this.con);
                this.close(request);
                this.close(chunk);
            }
            catch (Throwable throwable) {
                this.close(request);
                this.close(chunk);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGlobalStatus(String rt, int status, String explanation) {
        if (!this.checkConnection()) {
            log.error("REQUEST SUMMARY DAO - updateGlobalStatus: unable to get a valid connection!");
            return;
        }
        PreparedStatement update = null;
        try {
            update = this.con.prepareStatement("UPDATE request_queue SET status=?, errstring=? WHERE r_token=?");
            this.logWarnings(this.con.getWarnings());
            update.setInt(1, status);
            this.logWarnings(update.getWarnings());
            update.setString(2, explanation);
            this.logWarnings(update.getWarnings());
            update.setString(3, rt);
            this.logWarnings(update.getWarnings());
            log.trace("REQUEST SUMMARY DAO - updateGlobalStatus: executing " + update);
            update.executeUpdate();
            this.logWarnings(update.getWarnings());
        }
        catch (SQLException e) {
            log.error("REQUEST SUMMARY DAO: " + e);
        }
        finally {
            this.close(update);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGlobalStatusOnMatchingGlobalStatus(TRequestToken requestToken, TStatusCode expectedStatusCode, TStatusCode newStatusCode, String explanation) {
        if (!this.checkConnection()) {
            log.error("REQUEST SUMMARY DAO - updateGlobalStatusOnMatchingGlobalStatus: unable to get a valid connection!");
            return;
        }
        PreparedStatement update = null;
        try {
            update = this.con.prepareStatement("UPDATE request_queue SET status=?, errstring=? WHERE r_token=? AND status=?");
            this.logWarnings(this.con.getWarnings());
            update.setInt(1, StatusCodeConverter.getInstance().toDB(newStatusCode));
            this.logWarnings(update.getWarnings());
            update.setString(2, explanation);
            this.logWarnings(update.getWarnings());
            update.setString(3, requestToken.toString());
            this.logWarnings(update.getWarnings());
            update.setInt(4, StatusCodeConverter.getInstance().toDB(expectedStatusCode));
            this.logWarnings(update.getWarnings());
            log.trace("REQUEST SUMMARY DAO - updateGlobalStatusOnMatchingGlobalStatus: executing " + update);
            update.executeUpdate();
            this.logWarnings(update.getWarnings());
        }
        catch (SQLException e) {
            log.error("REQUEST SUMMARY DAO: " + e);
        }
        finally {
            this.close(update);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGlobalStatusPinFileLifetime(String rt, int status, String explanation) {
        if (!this.checkConnection()) {
            log.error("REQUEST SUMMARY DAO - updateGlobalStatusPinFileLifetime: unable to get a valid connection!");
            return;
        }
        PreparedStatement update = null;
        String query = "UPDATE request_queue SET status=?, errstring=?, pinLifetime=pinLifetime+(UNIX_TIMESTAMP()-UNIX_TIMESTAMP(timeStamp)) WHERE r_token=?";
        try {
            update = this.con.prepareStatement(query);
            this.logWarnings(this.con.getWarnings());
            update.setInt(1, status);
            this.logWarnings(update.getWarnings());
            update.setString(2, explanation);
            this.logWarnings(update.getWarnings());
            update.setString(3, rt);
            this.logWarnings(update.getWarnings());
            log.trace("REQUEST SUMMARY DAO - updateGlobalStatus: executing " + update);
            update.executeUpdate();
            this.logWarnings(update.getWarnings());
        }
        catch (SQLException e) {
            log.error("REQUEST SUMMARY DAO: " + e);
        }
        finally {
            this.close(update);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortRequest(String rt) {
        if (!this.checkConnection()) {
            log.error("REQUEST SUMMARY DAO - abortRequest: unable to get a valid connection!");
            return;
        }
        PreparedStatement update = null;
        PreparedStatement query = null;
        ResultSet rs = null;
        try {
            query = this.con.prepareStatement("SELECT ID,config_RequestTypeID FROM request_queue WHERE r_token=? AND status=?");
            this.logWarnings(this.con.getWarnings());
            query.setString(1, rt);
            this.logWarnings(query.getWarnings());
            query.setInt(2, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_REQUEST_QUEUED));
            this.logWarnings(query.getWarnings());
            log.trace("REQUEST SUMMARY DAO - abortRequest - " + query);
            rs = query.executeQuery();
            this.logWarnings(query.getWarnings());
            if (rs.next()) {
                long id = rs.getLong("ID");
                String type = rs.getString("config_RequestTypeID");
                update = this.con.prepareStatement("UPDATE request_queue SET status=?, errstring=? WHERE ID=?");
                this.logWarnings(this.con.getWarnings());
                update.setInt(1, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_ABORTED));
                this.logWarnings(update.getWarnings());
                update.setString(2, "User aborted request!");
                this.logWarnings(update.getWarnings());
                update.setLong(3, id);
                this.logWarnings(update.getWarnings());
                log.trace("REQUEST SUMMARY DAO - abortRequest - " + update);
                update.executeUpdate();
                this.logWarnings(update.getWarnings());
                this.close(update);
                TRequestType rtyp = RequestTypeConverter.getInstance().toSTORM(type);
                String status_table = null;
                String request_table = null;
                String join_column = null;
                if (rtyp != TRequestType.EMPTY) {
                    if (rtyp == TRequestType.PREPARE_TO_GET) {
                        status_table = "status_Get";
                        request_table = "request_Get";
                        join_column = "request_GetID";
                    } else if (rtyp == TRequestType.PREPARE_TO_PUT) {
                        request_table = "request_Put";
                        status_table = "status_Put";
                        join_column = "request_PutID";
                    } else if (rtyp == TRequestType.COPY) {
                        request_table = "request_Copy";
                        status_table = "status_Copy";
                        join_column = "request_CopyID";
                    } else {
                        request_table = "request_BoL";
                        status_table = "status_BoL";
                        join_column = "request_BoLID";
                    }
                    String auxstr = "UPDATE " + status_table + " s JOIN (request_queue r, " + request_table + " t) ON (s." + join_column + "=t.ID AND t.request_queueID=r.ID) " + "SET s.statusCode=?, s.explanation=? " + "WHERE r.ID=?";
                    update = this.con.prepareStatement(auxstr);
                    this.logWarnings(this.con.getWarnings());
                    update.setInt(1, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_ABORTED));
                    this.logWarnings(update.getWarnings());
                    update.setString(2, "User aborted request!");
                    this.logWarnings(update.getWarnings());
                    update.setLong(3, id);
                    this.logWarnings(update.getWarnings());
                    log.trace("REQUEST SUMMARY DAO - abortRequest - " + update);
                    update.executeUpdate();
                    this.logWarnings(update.getWarnings());
                } else {
                    log.error("REQUEST SUMMARY DAO - Unable to complete abortRequest: could not update file statuses because the request type could not be translated from the DB!");
                }
            }
            this.close(rs);
            this.close(query);
            this.close(update);
        }
        catch (SQLException e) {
            log.error("REQUEST SUMMARY DAO - abortRequest: " + e);
        }
        finally {
            this.close(rs);
            this.close(query);
            this.close(update);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortInProgressRequest(String rt) {
        if (!this.checkConnection()) {
            log.error("REQUEST SUMMARY DAO - abortInProgressRequest: unable to get a valid connection!");
            return;
        }
        PreparedStatement update = null;
        PreparedStatement query = null;
        ResultSet rs = null;
        try {
            query = this.con.prepareStatement("SELECT ID,config_RequestTypeID FROM request_queue WHERE r_token=? AND status=?");
            this.logWarnings(this.con.getWarnings());
            query.setString(1, rt);
            this.logWarnings(query.getWarnings());
            query.setInt(2, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_REQUEST_INPROGRESS));
            this.logWarnings(query.getWarnings());
            log.trace("REQUEST SUMMARY DAO - abortInProgressRequest - " + query);
            rs = query.executeQuery();
            this.logWarnings(query.getWarnings());
            if (rs.next()) {
                long id = rs.getLong("ID");
                String type = rs.getString("config_RequestTypeID");
                update = this.con.prepareStatement("UPDATE request_queue SET status=?, errstring=? WHERE ID=?");
                this.logWarnings(this.con.getWarnings());
                update.setInt(1, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_ABORTED));
                this.logWarnings(update.getWarnings());
                update.setString(2, "User aborted request!");
                this.logWarnings(update.getWarnings());
                update.setLong(3, id);
                this.logWarnings(update.getWarnings());
                log.trace("REQUEST SUMMARY DAO - abortInProgressRequest - " + update);
                update.executeUpdate();
                this.logWarnings(update.getWarnings());
                this.close(update);
                TRequestType rtyp = RequestTypeConverter.getInstance().toSTORM(type);
                String status_table = null;
                String request_table = null;
                String join_column = null;
                if (rtyp != TRequestType.EMPTY) {
                    if (rtyp == TRequestType.PREPARE_TO_GET) {
                        request_table = "request_Get";
                        status_table = "status_Get";
                        join_column = "request_GetID";
                    } else if (rtyp == TRequestType.PREPARE_TO_PUT) {
                        request_table = "request_Put";
                        status_table = "status_Put";
                        join_column = "request_PutID";
                    } else if (rtyp == TRequestType.COPY) {
                        request_table = "request_Copy";
                        status_table = "status_Copy";
                        join_column = "request_CopyID";
                    } else {
                        request_table = "request_BoL";
                        status_table = "status_BoL";
                        join_column = "request_BoLID";
                    }
                    String auxstr = "UPDATE " + status_table + " s JOIN (request_queue r, " + request_table + " t ON s." + join_column + "=t.ID AND t.request_queueID=r.ID )" + "SET s.statusCode=?, s.explanation=? " + "WHERE r.ID=?";
                    update = this.con.prepareStatement(auxstr);
                    this.logWarnings(this.con.getWarnings());
                    update.setInt(1, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_ABORTED));
                    this.logWarnings(update.getWarnings());
                    update.setString(2, "User aborted request!");
                    this.logWarnings(update.getWarnings());
                    update.setLong(3, id);
                    this.logWarnings(update.getWarnings());
                    log.trace("REQUEST SUMMARY DAO - abortInProgressRequest - " + update);
                    update.executeUpdate();
                    this.logWarnings(update.getWarnings());
                } else {
                    log.error("REQUEST SUMMARY DAO - Unable to complete abortInProgressRequest: could not update file statuses because the request type could not be translated from the DB!");
                }
            }
            this.close(rs);
            this.close(query);
            this.close(update);
        }
        catch (SQLException e) {
            log.error("REQUEST SUMMARY DAO - abortInProgressRequest: " + e);
        }
        finally {
            this.close(rs);
            this.close(query);
            this.close(update);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortChunksOfRequest(String rt, Collection<String> surls) {
        if (!this.checkConnection()) {
            log.error("REQUEST SUMMARY DAO - abortChunksOfRequest: unable to get a valid connection!");
            return;
        }
        PreparedStatement update = null;
        PreparedStatement query = null;
        ResultSet rs = null;
        try {
            query = this.con.prepareStatement("SELECT ID,config_RequestTypeID FROM request_queue WHERE r_token=? AND status=?");
            this.logWarnings(this.con.getWarnings());
            query.setString(1, rt);
            this.logWarnings(query.getWarnings());
            query.setInt(2, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_REQUEST_QUEUED));
            this.logWarnings(query.getWarnings());
            log.trace("REQUEST SUMMARY DAO - abortChunksOfRequest - " + query);
            rs = query.executeQuery();
            this.logWarnings(query.getWarnings());
            if (rs.next()) {
                long id = rs.getLong("ID");
                String type = rs.getString("config_RequestTypeID");
                TRequestType rtyp = RequestTypeConverter.getInstance().toSTORM(type);
                String status_table = null;
                String request_table = null;
                String join_column = null;
                String surl_column = null;
                if (rtyp != TRequestType.EMPTY) {
                    if (rtyp == TRequestType.PREPARE_TO_GET) {
                        request_table = "request_Get";
                        status_table = "status_Get";
                        join_column = "request_GetID";
                        surl_column = "sourceSURL";
                    } else if (rtyp == TRequestType.PREPARE_TO_PUT) {
                        request_table = "request_Put";
                        status_table = "status_Put";
                        join_column = "request_PutID";
                        surl_column = "targetSURL";
                    } else if (rtyp == TRequestType.COPY) {
                        request_table = "request_Copy";
                        status_table = "status_Copy";
                        join_column = "request_CopyID";
                        surl_column = "targetSURL";
                    } else {
                        request_table = "request_BoL";
                        status_table = "status_BoL";
                        join_column = "request_BoLID";
                        surl_column = "sourceSURL";
                    }
                    String auxstr = "UPDATE " + status_table + " s JOIN (request_queue r, " + request_table + " t ON s." + join_column + "=t.ID AND t.request_queueID=r.ID " + "SET s.statusCode=?, s.explanation=? " + "WHERE r.ID=? AND " + surl_column + " IN " + this.makeInString(surls);
                    update = this.con.prepareStatement(auxstr);
                    this.logWarnings(this.con.getWarnings());
                    update.setInt(1, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_ABORTED));
                    this.logWarnings(update.getWarnings());
                    update.setString(2, "User aborted request!");
                    this.logWarnings(update.getWarnings());
                    update.setLong(3, id);
                    this.logWarnings(update.getWarnings());
                    log.trace("REQUEST SUMMARY DAO - abortChunksOfRequest - " + update);
                    update.executeUpdate();
                    this.logWarnings(update.getWarnings());
                } else {
                    log.error("REQUEST SUMMARY DAO - Unable to complete abortChunksOfRequest: could not update file statuses because the request type could not be translated from the DB!");
                }
            }
            this.close(rs);
            this.close(query);
            this.close(update);
        }
        catch (SQLException e) {
            log.error("REQUEST SUMMARY DAO - abortChunksOfRequest: " + e);
        }
        finally {
            this.close(rs);
            this.close(query);
            this.close(update);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortChunksOfInProgressRequest(String rt, Collection<String> surls) {
        if (!this.checkConnection()) {
            log.error("REQUEST SUMMARY DAO - abortChunksOfInProgressRequest: unable to get a valid connection!");
            return;
        }
        PreparedStatement update = null;
        PreparedStatement query = null;
        ResultSet rs = null;
        try {
            query = this.con.prepareStatement("SELECT ID,config_RequestTypeID FROM request_queue WHERE r_token=? AND status=?");
            this.logWarnings(this.con.getWarnings());
            query.setString(1, rt);
            this.logWarnings(query.getWarnings());
            query.setInt(2, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_REQUEST_INPROGRESS));
            this.logWarnings(query.getWarnings());
            log.trace("REQUEST SUMMARY DAO - abortChunksOfInProgressRequest - " + query);
            rs = query.executeQuery();
            this.logWarnings(query.getWarnings());
            if (rs.next()) {
                long id = rs.getLong("ID");
                String type = rs.getString("config_RequestTypeID");
                TRequestType rtyp = RequestTypeConverter.getInstance().toSTORM(type);
                String status_table = null;
                String request_table = null;
                String join_column = null;
                String surl_column = null;
                if (rtyp != TRequestType.EMPTY) {
                    if (rtyp == TRequestType.PREPARE_TO_GET) {
                        request_table = "request_Get";
                        status_table = "status_Get";
                        join_column = "request_GetID";
                        surl_column = "sourceSURL";
                    } else if (rtyp == TRequestType.PREPARE_TO_PUT) {
                        request_table = "request_Put";
                        status_table = "status_Put";
                        join_column = "request_PutID";
                        surl_column = "targetSURL";
                    } else if (rtyp == TRequestType.COPY) {
                        request_table = "request_Copy";
                        status_table = "status_Copy";
                        join_column = "request_CopyID";
                        surl_column = "targetSURL";
                    } else {
                        request_table = "request_BoL";
                        status_table = "status_BoL";
                        join_column = "request_BoLID";
                        surl_column = "sourceSURL";
                    }
                    String auxstr = "UPDATE " + status_table + " s JOIN (request_queue r, " + request_table + " t ON s." + join_column + "=t.ID AND t.request_queueID=r.ID " + "SET s.statusCode=?, s.explanation=? " + "WHERE r.ID=? AND " + surl_column + " IN " + this.makeInString(surls);
                    update = this.con.prepareStatement(auxstr);
                    this.logWarnings(this.con.getWarnings());
                    update.setInt(1, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_ABORTED));
                    this.logWarnings(update.getWarnings());
                    update.setString(2, "User aborted request!");
                    this.logWarnings(update.getWarnings());
                    update.setLong(3, id);
                    this.logWarnings(update.getWarnings());
                    log.trace("REQUEST SUMMARY DAO - abortChunksOfInProgressRequest - " + update);
                    update.executeUpdate();
                    this.logWarnings(update.getWarnings());
                } else {
                    log.error("REQUEST SUMMARY DAO - Unable to complete abortChunksOfInProgressRequest: could not update file statuses because the request type could not be translated from the DB!");
                }
            }
            this.close(rs);
            this.close(query);
            this.close(update);
        }
        catch (SQLException e) {
            log.error("REQUEST SUMMARY DAO - abortChunksOfInProgressRequest: " + e);
        }
        finally {
            this.close(rs);
            this.close(query);
            this.close(update);
        }
    }

    private String makeInString(Collection<String> c) {
        StringBuffer sb = new StringBuffer("(");
        Iterator<String> i = c.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String typeOf(String rt) {
        PreparedStatement query = null;
        ResultSet rs = null;
        String result = "";
        if (!this.checkConnection()) {
            log.error("REQUEST SUMMARY DAO - typeOf: unable to get a valid connection!");
            return result;
        }
        try {
            query = this.con.prepareStatement("SELECT config_RequestTypeID from request_queue WHERE r_token=?");
            this.logWarnings(this.con.getWarnings());
            query.setString(1, rt);
            this.logWarnings(query.getWarnings());
            log.trace("REQUEST SUMMARY DAO - typeOf - " + query);
            rs = query.executeQuery();
            this.logWarnings(query.getWarnings());
            if (rs.next()) {
                result = rs.getString("config_RequestTypeID");
            }
            this.close(rs);
            this.close(query);
        }
        catch (SQLException e) {
            log.error("REQUEST SUMMARY DAO - typeOf - " + e);
        }
        finally {
            this.close(rs);
            this.close(query);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestSummaryDataTO find(String rt) {
        RequestSummaryDataTO to;
        block10: {
            PreparedStatement query = null;
            ResultSet rs = null;
            to = null;
            if (!this.checkConnection()) {
                log.error("REQUEST SUMMARY DAO - find: unable to get a valid connection!");
                return null;
            }
            try {
                query = this.con.prepareStatement("SELECT config_RequestTypeID from request_queue WHERE r_token=?");
                this.logWarnings(this.con.getWarnings());
                query.setString(1, rt);
                this.con.setAutoCommit(false);
                rs = query.executeQuery();
                this.logWarnings(query.getWarnings());
                if (!rs.first()) {
                    log.debug("No requests found with token " + rt);
                    RequestSummaryDataTO requestSummaryDataTO = null;
                    this.close(rs);
                    this.close(query);
                    return requestSummaryDataTO;
                }
                to = new RequestSummaryDataTO();
                to.setPrimaryKey(rs.getLong("ID"));
                to.setRequestType(rs.getString("config_RequestTypeID"));
                to.setClientDN(rs.getString("client_dn"));
                to.setUserToken(rs.getString("u_token"));
                to.setRetrytime(rs.getInt("retrytime"));
                to.setPinLifetime(rs.getInt("pinLifetime"));
                to.setSpaceToken(rs.getString("s_token"));
                to.setStatus(rs.getInt("status"));
                to.setErrstring(rs.getString("errstring"));
                to.setRequestToken(rs.getString("r_token"));
                to.setRemainingTotalTime(rs.getInt("remainingTotalTime"));
                to.setFileLifetime(rs.getInt("fileLifetime"));
                to.setNbreqfiles(rs.getInt("nbreqfiles"));
                to.setNumOfCompleted(rs.getInt("numOfCompleted"));
                to.setNumOfWaiting(rs.getInt("numOfWaiting"));
                to.setNumOfFailed(rs.getInt("numOfFailed"));
                to.setTimestamp(rs.getTimestamp("timeStamp"));
                Blob blob = rs.getBlob("proxy");
                if (blob != null) {
                    byte[] bdata = blob.getBytes(1L, (int)blob.length());
                    to.setVomsAttributes(new String(bdata));
                }
                to.setDeferredStartTime(rs.getInt("deferredStartTime"));
                to.setRemainingDeferredStartTime(rs.getInt("remainingDeferredStartTime"));
                if (rs.next()) {
                    log.warn("More than a row matches token " + rt);
                }
                this.close(rs);
                this.close(query);
                this.close(rs);
            }
            catch (SQLException e) {
                log.error("REQUEST SUMMARY DAO - find - " + e);
                break block10;
            }
            finally {
                this.close(rs);
                this.close(query);
            }
            this.close(query);
        }
        return to;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> purgeExpiredRequests() {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<String> requestTokens = new ArrayList<String>();
        ArrayList<Long> ids = new ArrayList<Long>();
        if (!this.checkConnection()) {
            log.error("REQUEST SUMMARY DAO - purgeExpiredRequests: unable to get a valid connection!");
            return requestTokens;
        }
        try {
            this.con.setAutoCommit(false);
            String stmt = "SELECT ID, r_token FROM request_queue WHERE UNIX_TIMESTAMP(NOW()) - UNIX_TIMESTAMP(timeStamp) > " + Configuration.getInstance().getExpiredRequestTime() + " AND status <> " + StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_REQUEST_QUEUED) + " AND status <> " + StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_REQUEST_INPROGRESS) + " LIMIT " + Configuration.getInstance().getPurgeBatchSize();
            ps = this.con.prepareStatement(stmt);
            this.logWarnings(this.con.getWarnings());
            log.trace("REQUEST SUMMARY DAO - purgeExpiredRequests - " + ps);
            rs = ps.executeQuery();
            this.logWarnings(ps.getWarnings());
            while (rs.next()) {
                requestTokens.add(rs.getString("r_token"));
                ids.add(new Long(rs.getLong("ID")));
            }
            this.close(rs);
            this.close(ps);
            if (!ids.isEmpty()) {
                stmt = "DELETE FROM request_queue WHERE ID in " + this.makeWhereString(ids);
                ps = this.con.prepareStatement(stmt);
                this.logWarnings(this.con.getWarnings());
                log.trace("REQUEST SUMMARY DAO - purgeExpiredRequests - " + stmt);
                int deleted = ps.executeUpdate();
                this.logWarnings(ps.getWarnings());
                if (deleted > 0) {
                    log.info("REQUEST SUMMARY DAO - purgeExpiredRequests - Deleted " + deleted + " expired requests.");
                } else {
                    log.trace("REQUEST SUMMARY DAO - purgeExpiredRequests - No deleted expired requests.");
                }
                this.close(ps);
                stmt = "DELETE request_DirOption FROM request_DirOption  LEFT JOIN request_Get ON request_DirOption.ID = request_Get.request_DirOptionID LEFT JOIN request_BoL ON request_DirOption.ID = request_BoL.request_DirOptionID  LEFT JOIN request_Copy ON request_DirOption.ID = request_Copy.request_DirOptionID WHERE request_Copy.request_DirOptionID IS NULL AND request_Get.request_DirOptionID IS NULL AND request_BoL.request_DirOptionID IS NULL;";
                ps = this.con.prepareStatement(stmt);
                this.logWarnings(this.con.getWarnings());
                log.trace("REQUEST SUMMARY DAO - purgeExpiredRequests - " + stmt);
                deleted = ps.executeUpdate();
                this.logWarnings(ps.getWarnings());
                if (deleted > 0) {
                    log.info("REQUEST SUMMARY DAO - purgeExpiredRequests - Deleted " + deleted + " DirOption related to expired requests.");
                } else {
                    log.trace("REQUEST SUMMARY DAO - purgeExpiredRequests - No Deleted DirOption related to expired requests.");
                }
                this.close(ps);
            }
            this.con.commit();
            this.logWarnings(this.con.getWarnings());
            this.con.setAutoCommit(true);
            this.logWarnings(this.con.getWarnings());
            this.close(rs);
            this.close(ps);
        }
        catch (SQLException e) {
            log.error("REQUEST SUMMARY DAO - purgeExpiredRequests - Rolling back because of error: " + e);
            this.rollback(this.con);
        }
        finally {
            this.close(rs);
            this.close(ps);
        }
        return requestTokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberExpired() {
        int rowCount = 0;
        if (!this.checkConnection()) {
            log.error("REQUEST SUMMARY DAO - getNumberExpired: unable to get a valid connection!");
            return 0;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            this.con.setAutoCommit(false);
            String stmt = "SELECT count(*) FROM request_queue WHERE UNIX_TIMESTAMP(NOW()) - UNIX_TIMESTAMP(timeStamp) > " + Configuration.getInstance().getExpiredRequestTime() + " AND status <> " + StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_REQUEST_QUEUED) + " AND status <> " + StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_REQUEST_INPROGRESS);
            ps = this.con.prepareStatement(stmt);
            this.logWarnings(this.con.getWarnings());
            log.trace("REQUEST SUMMARY DAO - Number of expired requests: " + ps);
            rs = ps.executeQuery();
            this.logWarnings(ps.getWarnings());
            rs.next();
            rowCount = rs.getInt(1);
            log.debug("Nr of expired requests is: " + rowCount);
            this.close(rs);
            this.close(ps);
            this.close(rs);
            this.close(ps);
        }
        catch (SQLException e) {
            log.error("REQUEST SUMMARY DAO - purgeExpiredRequests - Rolling back because of error: " + e);
            this.rollback(this.con);
        }
        finally {
            this.close(rs);
            this.close(ps);
        }
        return rowCount;
    }

    private String makeWhereString(List<Long> rowids) {
        StringBuffer sb = new StringBuffer("(");
        Iterator<Long> i = rowids.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private boolean setUpConnection() {
        boolean response = false;
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url, this.name, this.password);
            if (this.con == null) {
                log.error("REQUEST SUMMARY DAO! DriverManager returned null connection!");
            } else {
                this.logWarnings(this.con.getWarnings());
                response = this.con.isValid(0);
            }
        }
        catch (ClassNotFoundException e) {
            log.error("REQUEST SUMMARY DAO! Exception in setUpConnection! " + e);
        }
        catch (SQLException e) {
            log.error("REQUEST SUMMARY DAO! Exception in setUpConnection! " + e);
        }
        return response;
    }

    private void takeDownConnection() {
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (SQLException e) {
                log.error("REQUEST SUMMARY DAO! Exception in takeDownConnection method: " + e);
            }
        }
    }

    private boolean checkConnection() {
        boolean response = true;
        if (this.reconnect) {
            this.takeDownConnection();
            response = this.setUpConnection();
            if (response) {
                this.reconnect = false;
            }
        }
        return response;
    }

    private void close(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception e) {
                log.error("REQUEST SUMMARY DAO! Unable to close Statement " + stmt.toString() + " - Exception: " + e);
            }
        }
    }

    private void close(ResultSet rset) {
        if (rset != null) {
            try {
                rset.close();
            }
            catch (Exception e) {
                log.error("REQUEST SUMMARY DAO! Unable to close ResultSet! Exception: " + e);
            }
        }
    }

    private void rollback(Connection con) {
        if (con != null) {
            try {
                con.rollback();
                this.logWarnings(con.getWarnings());
                log.error("PICKER2: roll back successful!");
            }
            catch (SQLException e2) {
                log.error("PICKER2: roll back failed! " + e2);
            }
        }
    }

    private void logWarnings(SQLWarning warning) {
        if (warning != null) {
            log.debug("REQUEST SUMMARY DAO: " + warning.toString());
            while ((warning = warning.getNextWarning()) != null) {
                log.debug("REQUEST SUMMARY DAO: " + warning.toString());
            }
        }
    }
}

