/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.catalogs;

import it.grid.storm.catalogs.InvalidReducedPtGChunkDataAttributesException;
import it.grid.storm.catalogs.InvalidSurlRequestDataAttributesException;
import it.grid.storm.catalogs.PinLifetimeConverter;
import it.grid.storm.catalogs.PtGChunkDAO;
import it.grid.storm.catalogs.PtGChunkDataTO;
import it.grid.storm.catalogs.PtGPersistentChunkData;
import it.grid.storm.catalogs.ReducedChunkData;
import it.grid.storm.catalogs.ReducedPtGChunkData;
import it.grid.storm.catalogs.ReducedPtGChunkDataTO;
import it.grid.storm.catalogs.StatusCodeConverter;
import it.grid.storm.catalogs.TURLConverter;
import it.grid.storm.catalogs.TransferProtocolListConverter;
import it.grid.storm.common.types.SizeUnit;
import it.grid.storm.common.types.TURLPrefix;
import it.grid.storm.common.types.TimeUnit;
import it.grid.storm.config.Configuration;
import it.grid.storm.griduser.AbstractGridUser;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.GridUserManager;
import it.grid.storm.srm.types.InvalidTDirOptionAttributesException;
import it.grid.storm.srm.types.InvalidTRequestTokenAttributesException;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.InvalidTSURLAttributesException;
import it.grid.storm.srm.types.InvalidTSizeAttributesException;
import it.grid.storm.srm.types.InvalidTTURLAttributesException;
import it.grid.storm.srm.types.TDirOption;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.srm.types.TTURL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtGChunkCatalog {
    private static final Logger log = LoggerFactory.getLogger(PtGChunkCatalog.class);
    private static final PtGChunkCatalog cat = new PtGChunkCatalog();
    private final PtGChunkDAO dao = PtGChunkDAO.getInstance();
    private final Timer transiter = new Timer();
    private final long delay = Configuration.getInstance().getTransitInitialDelay() * 1000L;
    private final long period = Configuration.getInstance().getTransitTimeInterval() * 1000L;

    private PtGChunkCatalog() {
        TimerTask transitTask = new TimerTask(){

            @Override
            public void run() {
                PtGChunkCatalog.this.transitExpiredSRM_FILE_PINNED();
            }
        };
        this.transiter.scheduleAtFixedRate(transitTask, this.delay, this.period);
    }

    public static PtGChunkCatalog getInstance() {
        return cat;
    }

    public synchronized void update(PtGPersistentChunkData chunkData) {
        PtGChunkDataTO to = new PtGChunkDataTO();
        to.setPrimaryKey(chunkData.getPrimaryKey());
        to.setFileSize(chunkData.getFileSize().value());
        to.setStatus(StatusCodeConverter.getInstance().toDB(chunkData.getStatus().getStatusCode()));
        to.setErrString(chunkData.getStatus().getExplanation());
        to.setTurl(TURLConverter.getInstance().toDB(chunkData.getTransferURL().toString()));
        to.setLifeTime(PinLifetimeConverter.getInstance().toDB(chunkData.getPinLifeTime().value()));
        to.setNormalizedStFN(chunkData.getSURL().normalizedStFN());
        to.setSurlUniqueID(new Integer(chunkData.getSURL().uniqueId()));
        to.setClientDN(chunkData.getUser().getDn());
        if (chunkData.getUser() instanceof AbstractGridUser && ((AbstractGridUser)chunkData.getUser()).hasVoms()) {
            to.setVomsAttributes(((AbstractGridUser)chunkData.getUser()).getFQANsAsString());
        }
        this.dao.update(to);
    }

    public synchronized PtGPersistentChunkData refreshStatus(PtGPersistentChunkData inputChunk) {
        PtGChunkDataTO chunkDataTO = this.dao.refresh(inputChunk.getPrimaryKey());
        log.debug("PtG CHUNK CATALOG: retrieved data " + chunkDataTO);
        if (chunkDataTO == null) {
            log.warn("PtG CHUNK CATALOG! Empty TO found in persistence for specified request: " + inputChunk.getPrimaryKey());
        } else {
            TReturnStatus status = null;
            TStatusCode code = StatusCodeConverter.getInstance().toSTORM(chunkDataTO.status());
            if (code != TStatusCode.EMPTY) {
                try {
                    status = new TReturnStatus(code, chunkDataTO.errString());
                }
                catch (InvalidTReturnStatusAttributeException e) {
                    log.error("PtGChunk : Unable to build the Return Status from the String '" + chunkDataTO.errString() + " and code '" + chunkDataTO.status() + "''." + e);
                }
            }
            inputChunk.setStatus(status);
            TTURL turl = null;
            try {
                turl = TTURL.makeFromString(chunkDataTO.turl());
            }
            catch (InvalidTTURLAttributesException e) {
                log.info("PtGChunkCatalog (FALSE-ERROR-in-abort-refresh-status?): built a TURL with protocol NULL (retrieved from the DB..)");
            }
            inputChunk.setTransferURL(turl);
        }
        return inputChunk;
    }

    public synchronized Collection<PtGPersistentChunkData> lookup(TRequestToken rt) {
        Collection<PtGChunkDataTO> chunkTOs = this.dao.find(rt);
        log.debug("PtG CHUNK CATALOG: retrieved data " + chunkTOs);
        ArrayList<PtGPersistentChunkData> list = new ArrayList<PtGPersistentChunkData>();
        if (chunkTOs.isEmpty()) {
            log.warn("PtG CHUNK CATALOG! No chunks found in persistence for specified request: " + rt);
        } else {
            for (PtGChunkDataTO chunkTO : chunkTOs) {
                PtGPersistentChunkData chunk = this.makeOne(chunkTO, rt);
                if (chunk == null) continue;
                list.add(chunk);
                if (this.isComplete(chunkTO)) continue;
                try {
                    this.dao.updateIncomplete(this.completeTO(chunkTO, chunk));
                }
                catch (InvalidReducedPtGChunkDataAttributesException e) {
                    log.warn("PtG CHUNK CATALOG! unable to add missing informations on DB to the request: " + e);
                }
            }
        }
        log.debug("PtG CHUNK CATALOG: returning " + list);
        return list;
    }

    private PtGPersistentChunkData makeOne(PtGChunkDataTO chunkDataTO, TRequestToken rt) {
        StringBuffer errorSb = new StringBuffer();
        TSURL fromSURL = null;
        try {
            fromSURL = TSURL.makeFromStringValidate(chunkDataTO.fromSURL());
        }
        catch (InvalidTSURLAttributesException e) {
            errorSb.append(e);
        }
        if (chunkDataTO.normalizedStFN() != null) {
            fromSURL.setNormalizedStFN(chunkDataTO.normalizedStFN());
        }
        if (chunkDataTO.surlUniqueID() != null) {
            fromSURL.setUniqueID(chunkDataTO.surlUniqueID());
        }
        TLifeTimeInSeconds lifeTime = null;
        try {
            long pinLifeTime = PinLifetimeConverter.getInstance().toStoRM(chunkDataTO.lifeTime());
            long max = Configuration.getInstance().getPinLifetimeMaximum();
            if (pinLifeTime > max) {
                log.warn("PinLifeTime is greater than the max value allowed. Drop the value to the max = " + max + " seconds");
                pinLifeTime = max;
            }
            lifeTime = TLifeTimeInSeconds.make(pinLifeTime, TimeUnit.SECONDS);
        }
        catch (IllegalArgumentException e) {
            errorSb.append("\n");
            errorSb.append(e);
        }
        TDirOption dirOption = null;
        try {
            dirOption = new TDirOption(chunkDataTO.dirOption(), chunkDataTO.allLevelRecursive(), chunkDataTO.numLevel());
        }
        catch (InvalidTDirOptionAttributesException e) {
            errorSb.append("\n");
            errorSb.append(e);
        }
        TURLPrefix transferProtocols = TransferProtocolListConverter.toSTORM(chunkDataTO.protocolList());
        if (transferProtocols.size() == 0) {
            errorSb.append("\nEmpty list of TransferProtocols or could not translate TransferProtocols!");
            transferProtocols = null;
        }
        TSizeInBytes fileSize = null;
        try {
            fileSize = TSizeInBytes.make(chunkDataTO.fileSize(), SizeUnit.BYTES);
        }
        catch (InvalidTSizeAttributesException e) {
            errorSb.append("\n");
            errorSb.append(e);
        }
        TReturnStatus status = null;
        TStatusCode code = StatusCodeConverter.getInstance().toSTORM(chunkDataTO.status());
        if (code == TStatusCode.EMPTY) {
            errorSb.append("\nRetrieved StatusCode was not recognised: " + chunkDataTO.status());
        } else {
            try {
                status = new TReturnStatus(code, chunkDataTO.errString());
            }
            catch (InvalidTReturnStatusAttributeException e) {
                errorSb.append("\n");
                errorSb.append(e);
            }
        }
        GridUserInterface gridUser = null;
        try {
            gridUser = chunkDataTO.vomsAttributes() != null && !chunkDataTO.vomsAttributes().trim().equals("") ? GridUserManager.makeVOMSGridUser(chunkDataTO.clientDN(), chunkDataTO.vomsAttributesArray()) : GridUserManager.makeGridUser(chunkDataTO.clientDN());
        }
        catch (IllegalArgumentException e) {
            log.error("Unexpected error on voms grid user creation. Contact StoRM Support : IllegalArgumentException " + e.getMessage());
        }
        TTURL transferURL = TTURL.makeEmpty();
        PtGPersistentChunkData aux = null;
        try {
            aux = new PtGPersistentChunkData(gridUser, rt, fromSURL, lifeTime, dirOption, transferProtocols, fileSize, status, transferURL);
            aux.setPrimaryKey(chunkDataTO.primaryKey());
        }
        catch (InvalidSurlRequestDataAttributesException e) {
            this.dao.signalMalformedPtGChunk(chunkDataTO);
            log.warn("PtG CHUNK CATALOG! Retrieved malformed PtG chunk data from persistence. Dropping chunk from request " + rt);
            log.warn(e.getMessage(), (Throwable)e);
            log.warn(errorSb.toString());
        }
        return aux;
    }

    private void completeTO(ReducedPtGChunkDataTO chunkTO, ReducedPtGChunkData chunk) {
        chunkTO.setNormalizedStFN(chunk.fromSURL().normalizedStFN());
        chunkTO.setSurlUniqueID(new Integer(chunk.fromSURL().uniqueId()));
    }

    private ReducedPtGChunkDataTO completeTO(PtGChunkDataTO chunkTO, PtGPersistentChunkData chunk) throws InvalidReducedPtGChunkDataAttributesException {
        ReducedPtGChunkDataTO reducedChunkTO = this.reduce(chunkTO);
        this.completeTO(reducedChunkTO, this.reduce(chunk));
        return reducedChunkTO;
    }

    private ReducedPtGChunkData reduce(PtGPersistentChunkData chunk) throws InvalidReducedPtGChunkDataAttributesException {
        ReducedPtGChunkData reducedChunk = new ReducedPtGChunkData(chunk.getSURL(), chunk.getStatus());
        reducedChunk.setPrimaryKey(chunk.getPrimaryKey());
        return reducedChunk;
    }

    private ReducedPtGChunkDataTO reduce(PtGChunkDataTO chunkTO) {
        ReducedPtGChunkDataTO reducedChunkTO = new ReducedPtGChunkDataTO();
        reducedChunkTO.setPrimaryKey(chunkTO.primaryKey());
        reducedChunkTO.setFromSURL(chunkTO.fromSURL());
        reducedChunkTO.setNormalizedStFN(chunkTO.normalizedStFN());
        reducedChunkTO.setSurlUniqueID(chunkTO.surlUniqueID());
        reducedChunkTO.setStatus(chunkTO.status());
        reducedChunkTO.setErrString(chunkTO.errString());
        return reducedChunkTO;
    }

    private boolean isComplete(PtGChunkDataTO chunkTO) {
        return chunkTO.normalizedStFN() != null && chunkTO.surlUniqueID() != null;
    }

    private boolean isComplete(ReducedPtGChunkDataTO reducedChunkTO) {
        return reducedChunkTO.normalizedStFN() != null && reducedChunkTO.surlUniqueID() != null;
    }

    public synchronized Collection<ReducedChunkData> lookupReducedPtGChunkData(TRequestToken rt) {
        Collection<ReducedPtGChunkDataTO> reducedChunkDataTOs = this.dao.findReduced(rt.getValue());
        log.debug("PtG CHUNK CATALOG: retrieved data " + reducedChunkDataTOs);
        ArrayList<ReducedChunkData> list = new ArrayList<ReducedChunkData>();
        if (reducedChunkDataTOs.isEmpty()) {
            log.debug("PtG CHUNK CATALOG! No chunks found in persistence for " + rt);
        } else {
            ReducedPtGChunkData reducedChunkData = null;
            for (ReducedPtGChunkDataTO reducedChunkDataTO : reducedChunkDataTOs) {
                reducedChunkData = this.makeOneReduced(reducedChunkDataTO);
                if (reducedChunkData == null) continue;
                list.add(reducedChunkData);
                if (this.isComplete(reducedChunkDataTO)) continue;
                this.completeTO(reducedChunkDataTO, reducedChunkData);
                this.dao.updateIncomplete(reducedChunkDataTO);
            }
            log.debug("PtG CHUNK CATALOG: returning " + list);
        }
        return list;
    }

    public Collection<ReducedChunkData> lookupReducedPtGChunkData(TRequestToken requestToken, Collection<TSURL> surls) {
        int[] surlsUniqueIDs = new int[surls.size()];
        String[] surlsArray = new String[surls.size()];
        int index = 0;
        for (TSURL tsurl : surls) {
            surlsUniqueIDs[index] = tsurl.uniqueId();
            surlsArray[index] = tsurl.rawSurl();
            ++index;
        }
        Collection<ReducedPtGChunkDataTO> chunkDataTOCollection = this.dao.findReduced(requestToken, surlsUniqueIDs, surlsArray);
        log.debug("PtG CHUNK CATALOG: retrieved data " + chunkDataTOCollection);
        return this.buildReducedChunkDataList(chunkDataTOCollection);
    }

    public Collection<PtGPersistentChunkData> lookupPtGChunkData(TSURL surl, GridUserInterface user) {
        return this.lookupPtGChunkData(Arrays.asList(surl), user);
    }

    public Collection<PtGPersistentChunkData> lookupPtGChunkData(TSURL surl) {
        return this.lookupPtGChunkData(Arrays.asList(surl));
    }

    private Collection<PtGPersistentChunkData> lookupPtGChunkData(List<TSURL> surls, GridUserInterface user) {
        int[] surlsUniqueIDs = new int[surls.size()];
        String[] surlsArray = new String[surls.size()];
        int index = 0;
        for (TSURL tsurl : surls) {
            surlsUniqueIDs[index] = tsurl.uniqueId();
            surlsArray[index] = tsurl.rawSurl();
            ++index;
        }
        Collection<PtGChunkDataTO> chunkDataTOCollection = this.dao.find(surlsUniqueIDs, surlsArray, user.getDn());
        log.debug("PtG CHUNK CATALOG: retrieved data " + chunkDataTOCollection);
        return this.buildChunkDataList(chunkDataTOCollection);
    }

    public Collection<PtGPersistentChunkData> lookupPtGChunkData(List<TSURL> surls) {
        int[] surlsUniqueIDs = new int[surls.size()];
        String[] surlsArray = new String[surls.size()];
        int index = 0;
        for (TSURL tsurl : surls) {
            surlsUniqueIDs[index] = tsurl.uniqueId();
            surlsArray[index] = tsurl.rawSurl();
            ++index;
        }
        Collection<PtGChunkDataTO> chunkDataTOCollection = this.dao.find(surlsUniqueIDs, surlsArray);
        log.debug("PtG CHUNK CATALOG: retrieved data " + chunkDataTOCollection);
        return this.buildChunkDataList(chunkDataTOCollection);
    }

    private Collection<PtGPersistentChunkData> buildChunkDataList(Collection<PtGChunkDataTO> chunkDataTOCollection) {
        ArrayList<PtGPersistentChunkData> list = new ArrayList<PtGPersistentChunkData>();
        for (PtGChunkDataTO chunkTO : chunkDataTOCollection) {
            PtGPersistentChunkData chunk = this.makeOne(chunkTO);
            if (chunk == null) continue;
            list.add(chunk);
            if (this.isComplete(chunkTO)) continue;
            try {
                this.dao.updateIncomplete(this.completeTO(chunkTO, chunk));
            }
            catch (InvalidReducedPtGChunkDataAttributesException e) {
                log.warn("PtG CHUNK CATALOG! unable to add missing informations on DB to the request: " + e);
            }
        }
        return list;
    }

    private PtGPersistentChunkData makeOne(PtGChunkDataTO chunkTO) {
        try {
            return this.makeOne(chunkTO, new TRequestToken(chunkTO.requestToken(), chunkTO.timeStamp()));
        }
        catch (InvalidTRequestTokenAttributesException e) {
            throw new IllegalStateException("Unexpected InvalidTRequestTokenAttributesException in TRequestToken: " + e);
        }
    }

    public synchronized Collection<ReducedChunkData> lookupReducedPtGChunkData(GridUserInterface gu, Collection<TSURL> tsurlCollection) {
        int[] surlsUniqueIDs = new int[tsurlCollection.size()];
        String[] surls = new String[tsurlCollection.size()];
        int index = 0;
        for (TSURL tsurl : tsurlCollection) {
            surlsUniqueIDs[index] = tsurl.uniqueId();
            surls[index] = tsurl.rawSurl();
            ++index;
        }
        Collection<ReducedPtGChunkDataTO> chunkDataTOCollection = this.dao.findReduced(gu.getDn(), surlsUniqueIDs, surls);
        log.debug("PtG CHUNK CATALOG: retrieved data " + chunkDataTOCollection);
        return this.buildReducedChunkDataList(chunkDataTOCollection);
    }

    private Collection<ReducedChunkData> buildReducedChunkDataList(Collection<ReducedPtGChunkDataTO> chunkDataTOCollection) {
        ArrayList<ReducedChunkData> list = new ArrayList<ReducedChunkData>();
        for (ReducedPtGChunkDataTO reducedChunkDataTO : chunkDataTOCollection) {
            ReducedPtGChunkData reducedChunkData = this.makeOneReduced(reducedChunkDataTO);
            if (reducedChunkData == null) continue;
            list.add(reducedChunkData);
            if (this.isComplete(reducedChunkDataTO)) continue;
            this.completeTO(reducedChunkDataTO, reducedChunkData);
            this.dao.updateIncomplete(reducedChunkDataTO);
        }
        log.debug("PtG CHUNK CATALOG: returning " + list);
        return list;
    }

    private ReducedPtGChunkData makeOneReduced(ReducedPtGChunkDataTO reducedChunkDataTO) {
        StringBuffer errorSb = new StringBuffer();
        TSURL fromSURL = null;
        try {
            fromSURL = TSURL.makeFromStringValidate(reducedChunkDataTO.fromSURL());
        }
        catch (InvalidTSURLAttributesException e) {
            errorSb.append(e);
        }
        if (reducedChunkDataTO.normalizedStFN() != null) {
            fromSURL.setNormalizedStFN(reducedChunkDataTO.normalizedStFN());
        }
        if (reducedChunkDataTO.surlUniqueID() != null) {
            fromSURL.setUniqueID(reducedChunkDataTO.surlUniqueID());
        }
        TReturnStatus status = null;
        TStatusCode code = StatusCodeConverter.getInstance().toSTORM(reducedChunkDataTO.status());
        if (code == TStatusCode.EMPTY) {
            errorSb.append("\nRetrieved StatusCode was not recognised: " + reducedChunkDataTO.status());
        } else {
            try {
                status = new TReturnStatus(code, reducedChunkDataTO.errString());
            }
            catch (InvalidTReturnStatusAttributeException e) {
                errorSb.append("\n");
                errorSb.append(e);
            }
        }
        ReducedPtGChunkData aux = null;
        try {
            aux = new ReducedPtGChunkData(fromSURL, status);
            aux.setPrimaryKey(reducedChunkDataTO.primaryKey());
        }
        catch (InvalidReducedPtGChunkDataAttributesException e) {
            log.warn("PtG CHUNK CATALOG! Retrieved malformed Reduced PtG chunk data from persistence: dropping reduced chunk...");
            log.warn(e.getMessage(), (Throwable)e);
            log.warn(errorSb.toString());
        }
        return aux;
    }

    public synchronized void addChild(PtGPersistentChunkData chunkData) {
        PtGChunkDataTO to = new PtGChunkDataTO();
        to.setRequestToken(chunkData.getRequestToken().toString());
        to.setFromSURL(chunkData.getSURL().toString());
        to.setNormalizedStFN(chunkData.getSURL().normalizedStFN());
        to.setSurlUniqueID(new Integer(chunkData.getSURL().uniqueId()));
        to.setAllLevelRecursive(chunkData.getDirOption().isAllLevelRecursive());
        to.setDirOption(chunkData.getDirOption().isDirectory());
        to.setNumLevel(chunkData.getDirOption().getNumLevel());
        to.setStatus(StatusCodeConverter.getInstance().toDB(chunkData.getStatus().getStatusCode()));
        to.setErrString(chunkData.getStatus().getExplanation());
        to.setClientDN(chunkData.getUser().getDn());
        if (chunkData.getUser() instanceof AbstractGridUser && ((AbstractGridUser)chunkData.getUser()).hasVoms()) {
            to.setVomsAttributes(((AbstractGridUser)chunkData.getUser()).getFQANsAsString());
        }
        this.dao.addChild(to);
        chunkData.setPrimaryKey(to.primaryKey());
    }

    public synchronized void add(PtGPersistentChunkData chunkData, GridUserInterface gu) {
        PtGChunkDataTO to = new PtGChunkDataTO();
        to.setRequestToken(chunkData.getRequestToken().toString());
        to.setFromSURL(chunkData.getSURL().toString());
        to.setNormalizedStFN(chunkData.getSURL().normalizedStFN());
        to.setSurlUniqueID(new Integer(chunkData.getSURL().uniqueId()));
        to.setLifeTime(new Long(chunkData.getPinLifeTime().value()).intValue());
        to.setAllLevelRecursive(chunkData.getDirOption().isAllLevelRecursive());
        to.setDirOption(chunkData.getDirOption().isDirectory());
        to.setNumLevel(chunkData.getDirOption().getNumLevel());
        to.setProtocolList(TransferProtocolListConverter.toDB(chunkData.getTransferProtocols()));
        to.setStatus(StatusCodeConverter.getInstance().toDB(chunkData.getStatus().getStatusCode()));
        to.setErrString(chunkData.getStatus().getExplanation());
        to.setClientDN(chunkData.getUser().getDn());
        if (chunkData.getUser() instanceof AbstractGridUser && ((AbstractGridUser)chunkData.getUser()).hasVoms()) {
            to.setVomsAttributes(((AbstractGridUser)chunkData.getUser()).getFQANsAsString());
        }
        this.dao.addNew(to, gu.getDn());
        chunkData.setPrimaryKey(to.primaryKey());
    }

    public synchronized boolean isSRM_FILE_PINNED(TSURL surl) {
        return this.dao.numberInSRM_FILE_PINNED(surl.uniqueId()) > 0;
    }

    public synchronized void transitSRM_FILE_PINNEDtoSRM_RELEASED(Collection<ReducedPtGChunkData> chunks, TRequestToken token) {
        if (chunks == null || chunks.isEmpty()) {
            return;
        }
        long[] primaryKeys = new long[chunks.size()];
        int index = 0;
        for (ReducedPtGChunkData chunkData : chunks) {
            if (chunkData == null) continue;
            primaryKeys[index] = chunkData.primaryKey();
            ++index;
        }
        this.dao.transitSRM_FILE_PINNEDtoSRM_RELEASED(primaryKeys, token);
        for (ReducedPtGChunkData chunkData : chunks) {
            if (chunkData == null) continue;
            primaryKeys[index] = chunkData.primaryKey();
            ++index;
        }
    }

    public synchronized void transitExpiredSRM_FILE_PINNED() {
        List<TSURL> expiredSurls = this.dao.transitExpiredSRM_FILE_PINNED();
    }

    public void updateStatus(TRequestToken requestToken, TSURL surl, TStatusCode statusCode, String explanation) {
        this.dao.updateStatus(requestToken, new int[]{surl.uniqueId()}, new String[]{surl.rawSurl()}, statusCode, explanation);
    }

    public void updateFromPreviousStatus(TRequestToken requestToken, TStatusCode expectedStatusCode, TStatusCode newStatusCode, String explanation) {
        this.dao.updateStatusOnMatchingStatus(requestToken, expectedStatusCode, newStatusCode, explanation);
    }

    public void updateFromPreviousStatus(TRequestToken requestToken, List<TSURL> surlList, TStatusCode expectedStatusCode, TStatusCode newStatusCode) {
        int[] surlsUniqueIDs = new int[surlList.size()];
        String[] surls = new String[surlList.size()];
        int index = 0;
        for (TSURL tsurl : surlList) {
            surlsUniqueIDs[index] = tsurl.uniqueId();
            surls[index] = tsurl.rawSurl();
            ++index;
        }
        this.dao.updateStatusOnMatchingStatus(requestToken, surlsUniqueIDs, surls, expectedStatusCode, newStatusCode);
    }
}

