/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.catalogs;

import it.grid.storm.catalogs.InvalidCopyDataAttributesException;
import it.grid.storm.catalogs.InvalidSurlRequestDataAttributesException;
import it.grid.storm.catalogs.SurlMultyOperationRequestData;
import it.grid.storm.srm.types.TFileStorageType;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TOverwriteMode;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyData
extends SurlMultyOperationRequestData {
    private static final Logger log = LoggerFactory.getLogger(CopyData.class);
    protected TSURL destinationSURL;
    protected TLifeTimeInSeconds lifetime;
    protected TFileStorageType fileStorageType;
    protected TSpaceToken spaceToken;
    protected TOverwriteMode overwriteOption;

    public CopyData(TSURL fromSURL, TSURL destinationSURL, TLifeTimeInSeconds lifetime, TFileStorageType fileStorageType, TSpaceToken spaceToken, TOverwriteMode overwriteOption, TReturnStatus status) throws InvalidCopyDataAttributesException, InvalidSurlRequestDataAttributesException {
        super(fromSURL, status);
        if (destinationSURL == null || lifetime == null || fileStorageType == null || spaceToken == null || overwriteOption == null) {
            throw new InvalidCopyDataAttributesException(fromSURL, destinationSURL, lifetime, fileStorageType, spaceToken, overwriteOption, status);
        }
        this.destinationSURL = destinationSURL;
        this.lifetime = lifetime;
        this.fileStorageType = fileStorageType;
        this.spaceToken = spaceToken;
        this.overwriteOption = overwriteOption;
    }

    public TSURL getDestinationSURL() {
        return this.destinationSURL;
    }

    public TLifeTimeInSeconds getLifetime() {
        return this.lifetime;
    }

    public TFileStorageType getFileStorageType() {
        return this.fileStorageType;
    }

    public TSpaceToken getSpaceToken() {
        return this.spaceToken;
    }

    public TOverwriteMode getOverwriteOption() {
        return this.overwriteOption;
    }

    public void changeStatusSRM_DUPLICATION_ERROR(String explanation) {
        this.setStatus(TStatusCode.SRM_DUPLICATION_ERROR, explanation);
    }

    public void changeStatusSRM_FATAL_INTERNAL_ERROR(String explanation) {
        this.setStatus(TStatusCode.SRM_FATAL_INTERNAL_ERROR, explanation);
    }

    @Override
    protected Logger getLog() {
        return log;
    }
}

