/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.catalogs;

import it.grid.storm.catalogs.CopyChunkDAO;
import it.grid.storm.catalogs.CopyChunkDataTO;
import it.grid.storm.catalogs.CopyPersistentChunkData;
import it.grid.storm.catalogs.FileLifetimeConverter;
import it.grid.storm.catalogs.FileStorageTypeConverter;
import it.grid.storm.catalogs.InvalidReducedCopyChunkDataAttributesException;
import it.grid.storm.catalogs.InvalidSurlRequestDataAttributesException;
import it.grid.storm.catalogs.OverwriteModeConverter;
import it.grid.storm.catalogs.ReducedCopyChunkData;
import it.grid.storm.catalogs.ReducedCopyChunkDataTO;
import it.grid.storm.catalogs.SpaceTokenStringConverter;
import it.grid.storm.catalogs.StatusCodeConverter;
import it.grid.storm.common.types.TimeUnit;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.srm.types.InvalidTRequestTokenAttributesException;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.InvalidTSURLAttributesException;
import it.grid.storm.srm.types.InvalidTSpaceTokenAttributesException;
import it.grid.storm.srm.types.TFileStorageType;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TOverwriteMode;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TStatusCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyChunkCatalog {
    private static final Logger log = LoggerFactory.getLogger(CopyChunkCatalog.class);
    private static final CopyChunkCatalog cat = new CopyChunkCatalog();
    private CopyChunkDAO dao = CopyChunkDAO.getInstance();

    private CopyChunkCatalog() {
    }

    public static CopyChunkCatalog getInstance() {
        return cat;
    }

    public synchronized void update(CopyPersistentChunkData cd) {
        CopyChunkDataTO to = new CopyChunkDataTO();
        to.setPrimaryKey(cd.getPrimaryKey());
        to.setLifeTime(FileLifetimeConverter.getInstance().toDB(cd.getLifetime().value()));
        to.setStatus(StatusCodeConverter.getInstance().toDB(cd.getStatus().getStatusCode()));
        to.setErrString(cd.getStatus().getExplanation());
        to.setFileStorageType(FileStorageTypeConverter.getInstance().toDB(cd.getFileStorageType()));
        to.setOverwriteOption(OverwriteModeConverter.getInstance().toDB(cd.getOverwriteOption()));
        to.setNormalizedSourceStFN(cd.getSURL().normalizedStFN());
        to.setSourceSurlUniqueID(new Integer(cd.getSURL().uniqueId()));
        to.setNormalizedTargetStFN(cd.getDestinationSURL().normalizedStFN());
        to.setTargetSurlUniqueID(new Integer(cd.getDestinationSURL().uniqueId()));
        this.dao.update(to);
    }

    public synchronized Collection<CopyPersistentChunkData> lookup(TRequestToken rt) {
        Collection<CopyChunkDataTO> chunkDataTOs = this.dao.find(rt);
        log.debug("COPY CHUNK CATALOG: retrieved data " + chunkDataTOs);
        return this.buildChunkDataList(chunkDataTOs, rt);
    }

    private Collection<CopyPersistentChunkData> buildChunkDataList(Collection<CopyChunkDataTO> chunkDataTOs, TRequestToken rt) {
        ArrayList<CopyPersistentChunkData> list = new ArrayList<CopyPersistentChunkData>();
        for (CopyChunkDataTO chunkTO : chunkDataTOs) {
            CopyPersistentChunkData chunk = this.makeOne(chunkTO, rt);
            if (chunk == null) continue;
            list.add(chunk);
            if (this.isComplete(chunkTO)) continue;
            try {
                this.dao.updateIncomplete(this.completeTO(chunkTO, chunk));
            }
            catch (InvalidReducedCopyChunkDataAttributesException e) {
                log.warn("PtG CHUNK CATALOG! unable to add missing informations on DB to the request: " + e);
            }
        }
        log.debug("COPY CHUNK CATALOG: returning " + list + "\n\n");
        return list;
    }

    private Collection<CopyPersistentChunkData> buildChunkDataList(Collection<CopyChunkDataTO> chunkDataTOs) {
        ArrayList<CopyPersistentChunkData> list = new ArrayList<CopyPersistentChunkData>();
        for (CopyChunkDataTO chunkTO : chunkDataTOs) {
            CopyPersistentChunkData chunk = this.makeOne(chunkTO);
            if (chunk == null) continue;
            list.add(chunk);
            if (this.isComplete(chunkTO)) continue;
            try {
                this.dao.updateIncomplete(this.completeTO(chunkTO, chunk));
            }
            catch (InvalidReducedCopyChunkDataAttributesException e) {
                log.warn("PtG CHUNK CATALOG! unable to add missing informations on DB to the request: " + e);
            }
        }
        log.debug("COPY CHUNK CATALOG: returning " + list + "\n\n");
        return list;
    }

    public Collection<CopyPersistentChunkData> lookupCopyChunkData(TRequestToken requestToken, Collection<TSURL> surls) {
        int[] surlsUniqueIDs = new int[surls.size()];
        String[] surlsArray = new String[surls.size()];
        int index = 0;
        for (TSURL tsurl : surls) {
            surlsUniqueIDs[index] = tsurl.uniqueId();
            surlsArray[index] = tsurl.rawSurl();
            ++index;
        }
        Collection<CopyChunkDataTO> chunkDataTOs = this.dao.find(requestToken, surlsUniqueIDs, surlsArray);
        return this.buildChunkDataList(chunkDataTOs, requestToken);
    }

    public Collection<CopyPersistentChunkData> lookupCopyChunkData(TSURL surl, GridUserInterface user) {
        return this.lookupCopyChunkData(Arrays.asList(surl), user);
    }

    public Collection<CopyPersistentChunkData> lookupCopyChunkData(TSURL surl) {
        return this.lookupCopyChunkData(Arrays.asList(surl));
    }

    private Collection<CopyPersistentChunkData> lookupCopyChunkData(List<TSURL> surls, GridUserInterface user) {
        int[] surlsUniqueIDs = new int[surls.size()];
        String[] surlsArray = new String[surls.size()];
        int index = 0;
        for (TSURL tsurl : surls) {
            surlsUniqueIDs[index] = tsurl.uniqueId();
            surlsArray[index] = tsurl.rawSurl();
            ++index;
        }
        Collection<CopyChunkDataTO> chunkDataTOs = this.dao.find(surlsUniqueIDs, surlsArray, user.getDn());
        return this.buildChunkDataList(chunkDataTOs);
    }

    public Collection<CopyPersistentChunkData> lookupCopyChunkData(List<TSURL> surls) {
        int[] surlsUniqueIDs = new int[surls.size()];
        String[] surlsArray = new String[surls.size()];
        int index = 0;
        for (TSURL tsurl : surls) {
            surlsUniqueIDs[index] = tsurl.uniqueId();
            surlsArray[index] = tsurl.rawSurl();
            ++index;
        }
        Collection<CopyChunkDataTO> chunkDataTOs = this.dao.find(surlsUniqueIDs, surlsArray);
        return this.buildChunkDataList(chunkDataTOs);
    }

    private CopyPersistentChunkData makeOne(CopyChunkDataTO chunkTO) {
        try {
            return this.makeOne(chunkTO, new TRequestToken(chunkTO.requestToken(), chunkTO.timeStamp()));
        }
        catch (InvalidTRequestTokenAttributesException e) {
            throw new IllegalStateException("Unexpected InvalidTRequestTokenAttributesException in TRequestToken: " + e);
        }
    }

    private CopyPersistentChunkData makeOne(CopyChunkDataTO chunkDataTO, TRequestToken rt) {
        StringBuffer errorSb = new StringBuffer();
        TSURL fromSURL = null;
        try {
            fromSURL = TSURL.makeFromStringValidate(chunkDataTO.fromSURL());
        }
        catch (InvalidTSURLAttributesException e) {
            errorSb.append(e);
        }
        if (chunkDataTO.normalizedSourceStFN() != null) {
            fromSURL.setNormalizedStFN(chunkDataTO.normalizedSourceStFN());
        }
        if (chunkDataTO.sourceSurlUniqueID() != null) {
            fromSURL.setUniqueID(chunkDataTO.sourceSurlUniqueID());
        }
        TSURL toSURL = null;
        try {
            toSURL = TSURL.makeFromStringValidate(chunkDataTO.toSURL());
        }
        catch (InvalidTSURLAttributesException e) {
            errorSb.append(e);
        }
        if (chunkDataTO.normalizedTargetStFN() != null) {
            toSURL.setNormalizedStFN(chunkDataTO.normalizedTargetStFN());
        }
        if (chunkDataTO.targetSurlUniqueID() != null) {
            toSURL.setUniqueID(chunkDataTO.targetSurlUniqueID());
        }
        TLifeTimeInSeconds lifeTime = null;
        try {
            lifeTime = TLifeTimeInSeconds.make(FileLifetimeConverter.getInstance().toStoRM(chunkDataTO.lifeTime()), TimeUnit.SECONDS);
        }
        catch (IllegalArgumentException e) {
            errorSb.append("\n");
            errorSb.append(e);
        }
        TFileStorageType fileStorageType = FileStorageTypeConverter.getInstance().toSTORM(chunkDataTO.fileStorageType());
        if (fileStorageType == TFileStorageType.EMPTY) {
            log.error("\nTFileStorageType could not be translated from its String representation! String: " + chunkDataTO.fileStorageType());
            fileStorageType = null;
        }
        TSpaceToken spaceToken = null;
        TSpaceToken emptyToken = TSpaceToken.makeEmpty();
        String spaceTokenTranslation = SpaceTokenStringConverter.getInstance().toStoRM(chunkDataTO.spaceToken());
        if (emptyToken.toString().equals(spaceTokenTranslation)) {
            spaceToken = emptyToken;
        } else {
            try {
                spaceToken = TSpaceToken.make(spaceTokenTranslation);
            }
            catch (InvalidTSpaceTokenAttributesException e) {
                errorSb.append("\n");
                errorSb.append(e);
            }
        }
        TOverwriteMode globalOverwriteOption = OverwriteModeConverter.getInstance().toSTORM(chunkDataTO.overwriteOption());
        if (globalOverwriteOption == TOverwriteMode.EMPTY) {
            errorSb.append("\nTOverwriteMode could not be translated from its String representation! String: " + chunkDataTO.overwriteOption());
            globalOverwriteOption = null;
        }
        TReturnStatus status = null;
        TStatusCode code = StatusCodeConverter.getInstance().toSTORM(chunkDataTO.status());
        if (code == TStatusCode.EMPTY) {
            errorSb.append("\nRetrieved StatusCode was not recognised: " + chunkDataTO.status());
        } else {
            try {
                status = new TReturnStatus(code, chunkDataTO.errString());
            }
            catch (InvalidTReturnStatusAttributeException e) {
                errorSb.append("\n");
                errorSb.append(e);
            }
        }
        CopyPersistentChunkData aux = null;
        try {
            aux = new CopyPersistentChunkData(rt, fromSURL, toSURL, lifeTime, fileStorageType, spaceToken, globalOverwriteOption, status);
            aux.setPrimaryKey(chunkDataTO.primaryKey());
        }
        catch (InvalidSurlRequestDataAttributesException e) {
            this.dao.signalMalformedCopyChunk(chunkDataTO);
            log.warn("COPY CHUNK CATALOG! Retrieved malformed Copy chunk data from persistence. Dropping chunk from request: " + rt);
            log.warn(e.getMessage());
            log.warn(errorSb.toString());
        }
        return aux;
    }

    private void completeTO(ReducedCopyChunkDataTO chunkTO, ReducedCopyChunkData chunk) {
        chunkTO.setNormalizedSourceStFN(chunk.fromSURL().normalizedStFN());
        chunkTO.setSourceSurlUniqueID(new Integer(chunk.fromSURL().uniqueId()));
        chunkTO.setNormalizedTargetStFN(chunk.toSURL().normalizedStFN());
        chunkTO.setTargetSurlUniqueID(new Integer(chunk.toSURL().uniqueId()));
    }

    private ReducedCopyChunkDataTO completeTO(CopyChunkDataTO chunkTO, CopyPersistentChunkData chunk) throws InvalidReducedCopyChunkDataAttributesException {
        ReducedCopyChunkDataTO reducedChunkTO = this.reduce(chunkTO);
        this.completeTO(reducedChunkTO, this.reduce(chunk));
        return reducedChunkTO;
    }

    private ReducedCopyChunkData reduce(CopyPersistentChunkData chunk) throws InvalidReducedCopyChunkDataAttributesException {
        ReducedCopyChunkData reducedChunk = new ReducedCopyChunkData(chunk.getSURL(), chunk.getDestinationSURL(), chunk.getStatus());
        reducedChunk.setPrimaryKey(chunk.getPrimaryKey());
        return reducedChunk;
    }

    private ReducedCopyChunkDataTO reduce(CopyChunkDataTO chunkTO) {
        ReducedCopyChunkDataTO reducedChunkTO = new ReducedCopyChunkDataTO();
        reducedChunkTO.setPrimaryKey(chunkTO.primaryKey());
        reducedChunkTO.setFromSURL(chunkTO.fromSURL());
        reducedChunkTO.setNormalizedSourceStFN(chunkTO.normalizedSourceStFN());
        reducedChunkTO.setSourceSurlUniqueID(chunkTO.sourceSurlUniqueID());
        reducedChunkTO.setToSURL(chunkTO.toSURL());
        reducedChunkTO.setNormalizedTargetStFN(chunkTO.normalizedTargetStFN());
        reducedChunkTO.setTargetSurlUniqueID(chunkTO.targetSurlUniqueID());
        reducedChunkTO.setStatus(chunkTO.status());
        reducedChunkTO.setErrString(chunkTO.errString());
        return reducedChunkTO;
    }

    private boolean isComplete(CopyChunkDataTO chunkTO) {
        return chunkTO.normalizedSourceStFN() != null && chunkTO.sourceSurlUniqueID() != null && chunkTO.normalizedTargetStFN() != null && chunkTO.targetSurlUniqueID() != null;
    }

    private boolean isComplete(ReducedCopyChunkDataTO reducedChunkTO) {
        return reducedChunkTO.normalizedSourceStFN() != null && reducedChunkTO.sourceSurlUniqueID() != null && reducedChunkTO.normalizedTargetStFN() != null && reducedChunkTO.targetSurlUniqueID() != null;
    }

    public void updateFromPreviousStatus(TRequestToken requestToken, TStatusCode expectedStatusCode, TStatusCode newStatusCode, String explanation) {
        this.dao.updateStatusOnMatchingStatus(requestToken, expectedStatusCode, newStatusCode, explanation);
    }

    public void updateFromPreviousStatus(TRequestToken requestToken, List<TSURL> surlList, TStatusCode expectedStatusCode, TStatusCode newStatusCode) {
        int[] surlsUniqueIDs = new int[surlList.size()];
        String[] surls = new String[surlList.size()];
        int index = 0;
        for (TSURL tsurl : surlList) {
            surlsUniqueIDs[index] = tsurl.uniqueId();
            surls[index] = tsurl.rawSurl();
            ++index;
        }
        this.dao.updateStatusOnMatchingStatus(requestToken, surlsUniqueIDs, surls, expectedStatusCode, newStatusCode);
    }
}

