/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.catalogs;

import it.grid.storm.catalogs.AnonymousFileTransferData;
import it.grid.storm.catalogs.InvalidBoLDataAttributesException;
import it.grid.storm.catalogs.InvalidFileTransferDataAttributesException;
import it.grid.storm.catalogs.InvalidSurlRequestDataAttributesException;
import it.grid.storm.common.types.TURLPrefix;
import it.grid.storm.common.types.TimeUnit;
import it.grid.storm.srm.types.TDirOption;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.srm.types.TTURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoLData
extends AnonymousFileTransferData {
    private static final Logger log = LoggerFactory.getLogger(BoLData.class);
    private TLifeTimeInSeconds lifeTime;
    private TDirOption dirOption;
    private TSizeInBytes fileSize;
    private int deferredStartTime = 0;

    public BoLData(TSURL fromSURL, TLifeTimeInSeconds lifeTime, TDirOption dirOption, TURLPrefix desiredProtocols, TSizeInBytes fileSize, TReturnStatus status, TTURL transferURL, int deferredStartTime) throws InvalidFileTransferDataAttributesException, InvalidBoLDataAttributesException, InvalidSurlRequestDataAttributesException {
        super(fromSURL, desiredProtocols, status, transferURL);
        if (lifeTime == null || dirOption == null || fileSize == null) {
            throw new InvalidBoLDataAttributesException(fromSURL, lifeTime, dirOption, desiredProtocols, fileSize, status, transferURL);
        }
        this.lifeTime = lifeTime;
        this.dirOption = dirOption;
        this.fileSize = fileSize;
        this.deferredStartTime = deferredStartTime;
    }

    public void changeStatusSRM_FILE_PINNED(String explanation) {
        this.setStatus(TStatusCode.SRM_FILE_PINNED, explanation);
    }

    public int getDeferredStartTime() {
        return this.deferredStartTime;
    }

    public TDirOption getDirOption() {
        return this.dirOption;
    }

    public TSizeInBytes getFileSize() {
        return this.fileSize;
    }

    public TLifeTimeInSeconds getLifeTime() {
        return this.lifeTime;
    }

    public void setDeferredStartTime(int deferredStartTime) {
        this.deferredStartTime = deferredStartTime;
    }

    public void setFileSize(TSizeInBytes size) {
        if (size != null) {
            this.fileSize = size;
        }
    }

    public void setLifeTime(long lifeTimeInSeconds) {
        TLifeTimeInSeconds lifeTime;
        try {
            lifeTime = TLifeTimeInSeconds.make(lifeTimeInSeconds, TimeUnit.SECONDS);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        this.lifeTime = lifeTime;
    }

    @Override
    protected Logger getLog() {
        return log;
    }
}

