/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.catalogs;

import it.grid.storm.catalogs.BoLChunkDAO;
import it.grid.storm.catalogs.BoLChunkDataTO;
import it.grid.storm.catalogs.BoLPersistentChunkData;
import it.grid.storm.catalogs.InvalidReducedBoLChunkDataAttributesException;
import it.grid.storm.catalogs.InvalidSurlRequestDataAttributesException;
import it.grid.storm.catalogs.PinLifetimeConverter;
import it.grid.storm.catalogs.ReducedBoLChunkData;
import it.grid.storm.catalogs.ReducedBoLChunkDataTO;
import it.grid.storm.catalogs.StatusCodeConverter;
import it.grid.storm.catalogs.TransferProtocolListConverter;
import it.grid.storm.common.types.SizeUnit;
import it.grid.storm.common.types.TURLPrefix;
import it.grid.storm.common.types.TimeUnit;
import it.grid.storm.config.Configuration;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.srm.types.InvalidTDirOptionAttributesException;
import it.grid.storm.srm.types.InvalidTRequestTokenAttributesException;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.InvalidTSURLAttributesException;
import it.grid.storm.srm.types.InvalidTSizeAttributesException;
import it.grid.storm.srm.types.TDirOption;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.srm.types.TTURL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoLChunkCatalog {
    private static final Logger log = LoggerFactory.getLogger(BoLChunkCatalog.class);
    private static final BoLChunkCatalog cat = new BoLChunkCatalog();
    private final BoLChunkDAO dao = BoLChunkDAO.getInstance();
    private final Timer transiter = new Timer();
    private final long delay = Configuration.getInstance().getTransitInitialDelay() * 1000L;
    private final long period = Configuration.getInstance().getTransitTimeInterval() * 1000L;

    private BoLChunkCatalog() {
        TimerTask transitTask = new TimerTask(){

            @Override
            public void run() {
                BoLChunkCatalog.this.transitExpiredSRM_SUCCESS();
            }
        };
        this.transiter.scheduleAtFixedRate(transitTask, this.delay, this.period);
    }

    public static BoLChunkCatalog getInstance() {
        return cat;
    }

    public synchronized Collection<BoLPersistentChunkData> lookup(TRequestToken rt) {
        Collection<BoLChunkDataTO> chunkCollection = this.dao.find(rt);
        log.debug("BoL CHUNK CATALOG: retrieved data " + chunkCollection);
        ArrayList<BoLPersistentChunkData> list = new ArrayList<BoLPersistentChunkData>();
        if (chunkCollection.isEmpty()) {
            log.warn("BoL CHUNK CATALOG! No chunks found in persistence for specified request: " + rt);
        } else {
            for (BoLChunkDataTO chunkTO : chunkCollection) {
                BoLPersistentChunkData chunk = this.makeOne(chunkTO, rt);
                if (chunk == null) continue;
                list.add(chunk);
                if (this.isComplete(chunkTO)) continue;
                try {
                    this.dao.updateIncomplete(this.completeTO(chunkTO, chunk));
                }
                catch (InvalidReducedBoLChunkDataAttributesException e) {
                    log.warn("PtG CHUNK CATALOG! unable to add missing informations on DB to the request: " + e);
                }
            }
        }
        log.debug("BoL CHUNK CATALOG: returning " + list);
        return list;
    }

    private BoLPersistentChunkData makeOne(BoLChunkDataTO auxTO, TRequestToken rt) {
        StringBuffer errorSb = new StringBuffer();
        TSURL fromSURL = null;
        try {
            fromSURL = TSURL.makeFromStringValidate(auxTO.getFromSURL());
        }
        catch (InvalidTSURLAttributesException e) {
            errorSb.append(e);
        }
        if (auxTO.normalizedStFN() != null) {
            fromSURL.setNormalizedStFN(auxTO.normalizedStFN());
        }
        if (auxTO.sulrUniqueID() != null) {
            fromSURL.setUniqueID(auxTO.sulrUniqueID());
        }
        TLifeTimeInSeconds lifeTime = null;
        try {
            long pinLifeTime = PinLifetimeConverter.getInstance().toStoRM(auxTO.getLifeTime());
            long max = Configuration.getInstance().getPinLifetimeMaximum();
            if (pinLifeTime > max) {
                log.warn("PinLifeTime is greater than the max value allowed. Drop the value to the max = " + max + " seconds");
                pinLifeTime = max;
            }
            lifeTime = TLifeTimeInSeconds.make(pinLifeTime, TimeUnit.SECONDS);
        }
        catch (IllegalArgumentException e) {
            errorSb.append("\n");
            errorSb.append(e);
        }
        TDirOption dirOption = null;
        try {
            dirOption = new TDirOption(auxTO.getDirOption(), auxTO.getAllLevelRecursive(), auxTO.getNumLevel());
        }
        catch (InvalidTDirOptionAttributesException e) {
            errorSb.append("\n");
            errorSb.append(e);
        }
        TURLPrefix transferProtocols = TransferProtocolListConverter.toSTORM(auxTO.getProtocolList());
        if (transferProtocols.size() == 0) {
            errorSb.append("\nEmpty list of TransferProtocols or could not translate TransferProtocols!");
            transferProtocols = null;
        }
        TSizeInBytes fileSize = null;
        try {
            fileSize = TSizeInBytes.make(auxTO.getFileSize(), SizeUnit.BYTES);
        }
        catch (InvalidTSizeAttributesException e) {
            errorSb.append("\n");
            errorSb.append(e);
        }
        TReturnStatus status = null;
        TStatusCode code = StatusCodeConverter.getInstance().toSTORM(auxTO.getStatus());
        if (code == TStatusCode.EMPTY) {
            errorSb.append("\nRetrieved StatusCode was not recognised: " + auxTO.getStatus());
        } else {
            try {
                status = new TReturnStatus(code, auxTO.getErrString());
            }
            catch (InvalidTReturnStatusAttributeException e) {
                errorSb.append("\n");
                errorSb.append(e);
            }
        }
        TTURL transferURL = TTURL.makeEmpty();
        BoLPersistentChunkData aux = null;
        try {
            aux = new BoLPersistentChunkData(rt, fromSURL, lifeTime, dirOption, transferProtocols, fileSize, status, transferURL, auxTO.getDeferredStartTime());
            aux.setPrimaryKey(auxTO.getPrimaryKey());
        }
        catch (InvalidSurlRequestDataAttributesException e) {
            this.dao.signalMalformedBoLChunk(auxTO);
            log.warn("BoL CHUNK CATALOG! Retrieved malformed BoL chunk data from persistence. Dropping chunk from request " + rt);
            log.warn(e.getMessage(), (Throwable)e);
            log.warn(errorSb.toString());
        }
        return aux;
    }

    private void completeTO(ReducedBoLChunkDataTO chunkTO, ReducedBoLChunkData chunk) {
        chunkTO.setNormalizedStFN(chunk.fromSURL().normalizedStFN());
        chunkTO.setSurlUniqueID(new Integer(chunk.fromSURL().uniqueId()));
    }

    private ReducedBoLChunkDataTO completeTO(BoLChunkDataTO chunkTO, BoLPersistentChunkData chunk) throws InvalidReducedBoLChunkDataAttributesException {
        ReducedBoLChunkDataTO reducedChunkTO = this.reduce(chunkTO);
        this.completeTO(reducedChunkTO, this.reduce(chunk));
        return reducedChunkTO;
    }

    private ReducedBoLChunkData reduce(BoLPersistentChunkData chunk) throws InvalidReducedBoLChunkDataAttributesException {
        ReducedBoLChunkData reducedChunk = new ReducedBoLChunkData(chunk.getSURL(), chunk.getStatus());
        reducedChunk.setPrimaryKey(chunk.getPrimaryKey());
        return reducedChunk;
    }

    private ReducedBoLChunkDataTO reduce(BoLChunkDataTO chunkTO) {
        ReducedBoLChunkDataTO reducedChunkTO = new ReducedBoLChunkDataTO();
        reducedChunkTO.setPrimaryKey(chunkTO.getPrimaryKey());
        reducedChunkTO.setFromSURL(chunkTO.getFromSURL());
        reducedChunkTO.setNormalizedStFN(chunkTO.normalizedStFN());
        reducedChunkTO.setSurlUniqueID(chunkTO.sulrUniqueID());
        reducedChunkTO.setStatus(chunkTO.getStatus());
        reducedChunkTO.setErrString(chunkTO.getErrString());
        return reducedChunkTO;
    }

    private boolean isComplete(BoLChunkDataTO chunkTO) {
        return chunkTO.normalizedStFN() != null && chunkTO.sulrUniqueID() != null;
    }

    private boolean isComplete(ReducedBoLChunkDataTO reducedChunkTO) {
        return reducedChunkTO.normalizedStFN() != null && reducedChunkTO.surlUniqueID() != null;
    }

    public synchronized void update(BoLPersistentChunkData cd) {
        BoLChunkDataTO to = new BoLChunkDataTO();
        to.setPrimaryKey(cd.getPrimaryKey());
        to.setFileSize(cd.getFileSize().value());
        to.setStatus(StatusCodeConverter.getInstance().toDB(cd.getStatus().getStatusCode()));
        to.setErrString(cd.getStatus().getExplanation());
        to.setLifeTime(PinLifetimeConverter.getInstance().toDB(cd.getLifeTime().value()));
        to.setNormalizedStFN(cd.getSURL().normalizedStFN());
        to.setSurlUniqueID(new Integer(cd.getSURL().uniqueId()));
        this.dao.update(to);
    }

    public synchronized BoLPersistentChunkData refreshStatus(BoLPersistentChunkData inputChunk) {
        BoLChunkDataTO auxTO = this.dao.refresh(inputChunk.getPrimaryKey());
        log.debug("BoL CHUNK CATALOG: retrieved data " + auxTO);
        if (auxTO == null) {
            log.warn("BoL CHUNK CATALOG! Empty TO found in persistence for specified request: " + inputChunk.getPrimaryKey());
        } else {
            TReturnStatus status = null;
            TStatusCode code = StatusCodeConverter.getInstance().toSTORM(auxTO.getStatus());
            if (code != TStatusCode.EMPTY) {
                try {
                    status = new TReturnStatus(code, auxTO.getErrString());
                }
                catch (InvalidTReturnStatusAttributeException e) {
                    log.debug("BoL Chunk: Unable to build the Return Status from the String '" + auxTO.getErrString() + " and code '" + auxTO.getStatus() + "''." + e);
                }
            }
            inputChunk.setStatus(status);
        }
        return inputChunk;
    }

    public synchronized Collection<ReducedBoLChunkData> lookupReducedBoLChunkData(TRequestToken rt) {
        Collection<ReducedBoLChunkDataTO> reducedChunkDataTOs = this.dao.findReduced(rt.getValue());
        log.debug("BoL CHUNK CATALOG: retrieved data " + reducedChunkDataTOs);
        ArrayList<ReducedBoLChunkData> list = new ArrayList<ReducedBoLChunkData>();
        if (reducedChunkDataTOs.isEmpty()) {
            log.debug("BoL CHUNK CATALOG! No chunks found in persistence for " + rt);
        } else {
            ReducedBoLChunkData reducedChunkData = null;
            for (ReducedBoLChunkDataTO reducedChunkDataTO : reducedChunkDataTOs) {
                reducedChunkData = this.makeOneReduced(reducedChunkDataTO);
                if (reducedChunkData == null) continue;
                list.add(reducedChunkData);
                if (this.isComplete(reducedChunkDataTO)) continue;
                this.completeTO(reducedChunkDataTO, reducedChunkData);
                this.dao.updateIncomplete(reducedChunkDataTO);
            }
            log.debug("BoL CHUNK CATALOG: returning " + list);
        }
        return list;
    }

    public Collection<ReducedBoLChunkData> lookupReducedBoLChunkData(TRequestToken requestToken, Collection<TSURL> surls) {
        int[] surlsUniqueIDs = new int[surls.size()];
        String[] surlsArray = new String[surls.size()];
        int index = 0;
        for (TSURL tsurl : surls) {
            surlsUniqueIDs[index] = tsurl.uniqueId();
            surlsArray[index] = tsurl.rawSurl();
            ++index;
        }
        Collection<ReducedBoLChunkDataTO> chunkDataTOCollection = this.dao.findReduced(requestToken, surlsUniqueIDs, surlsArray);
        return this.buildReducedChunkDataList(chunkDataTOCollection);
    }

    public Collection<BoLPersistentChunkData> lookupBoLChunkData(TSURL surl, GridUserInterface user) {
        return this.lookupBoLChunkData(Arrays.asList(surl), user);
    }

    public Collection<BoLPersistentChunkData> lookupBoLChunkData(TSURL surl) {
        return this.lookupBoLChunkData(Arrays.asList(surl));
    }

    private Collection<BoLPersistentChunkData> lookupBoLChunkData(List<TSURL> surls, GridUserInterface user) {
        int[] surlsUniqueIDs = new int[surls.size()];
        String[] surlsArray = new String[surls.size()];
        int index = 0;
        for (TSURL tsurl : surls) {
            surlsUniqueIDs[index] = tsurl.uniqueId();
            surlsArray[index] = tsurl.rawSurl();
            ++index;
        }
        Collection<BoLChunkDataTO> chunkDataTOCollection = this.dao.find(surlsUniqueIDs, surlsArray, user.getDn());
        log.debug("PtG CHUNK CATALOG: retrieved data " + chunkDataTOCollection);
        return this.buildChunkDataList(chunkDataTOCollection);
    }

    public Collection<BoLPersistentChunkData> lookupBoLChunkData(List<TSURL> surls) {
        int[] surlsUniqueIDs = new int[surls.size()];
        String[] surlsArray = new String[surls.size()];
        int index = 0;
        for (TSURL tsurl : surls) {
            surlsUniqueIDs[index] = tsurl.uniqueId();
            surlsArray[index] = tsurl.rawSurl();
            ++index;
        }
        Collection<BoLChunkDataTO> chunkDataTOCollection = this.dao.find(surlsUniqueIDs, surlsArray);
        log.debug("PtG CHUNK CATALOG: retrieved data " + chunkDataTOCollection);
        return this.buildChunkDataList(chunkDataTOCollection);
    }

    private Collection<BoLPersistentChunkData> buildChunkDataList(Collection<BoLChunkDataTO> chunkDataTOCollection) {
        ArrayList<BoLPersistentChunkData> list = new ArrayList<BoLPersistentChunkData>();
        for (BoLChunkDataTO chunkTO : chunkDataTOCollection) {
            BoLPersistentChunkData chunk = this.makeOne(chunkTO);
            if (chunk == null) continue;
            list.add(chunk);
            if (this.isComplete(chunkTO)) continue;
            try {
                this.dao.updateIncomplete(this.completeTO(chunkTO, chunk));
            }
            catch (InvalidReducedBoLChunkDataAttributesException e) {
                log.warn("PtG CHUNK CATALOG! unable to add missing informations on DB to the request: " + e);
            }
        }
        log.debug("BoL CHUNK CATALOG: returning " + list);
        return list;
    }

    private BoLPersistentChunkData makeOne(BoLChunkDataTO chunkTO) {
        try {
            return this.makeOne(chunkTO, new TRequestToken(chunkTO.getRequestToken(), chunkTO.getTimeStamp()));
        }
        catch (InvalidTRequestTokenAttributesException e) {
            throw new IllegalStateException("Unexpected InvalidTRequestTokenAttributesException in TRequestToken: " + e);
        }
    }

    public synchronized Collection<ReducedBoLChunkData> lookupReducedBoLChunkData(GridUserInterface gu, Collection<TSURL> tsurlCollection) {
        int[] surlsUniqueIDs = new int[tsurlCollection.size()];
        String[] surls = new String[tsurlCollection.size()];
        int index = 0;
        for (TSURL tsurl : tsurlCollection) {
            surlsUniqueIDs[index] = tsurl.uniqueId();
            surls[index] = tsurl.rawSurl();
            ++index;
        }
        Collection<ReducedBoLChunkDataTO> chunkDataTOCollection = this.dao.findReduced(gu.getDn(), surlsUniqueIDs, surls);
        log.debug("BoL CHUNK CATALOG: retrieved data " + chunkDataTOCollection);
        return this.buildReducedChunkDataList(chunkDataTOCollection);
    }

    private Collection<ReducedBoLChunkData> buildReducedChunkDataList(Collection<ReducedBoLChunkDataTO> chunkDataTOCollection) {
        ArrayList<ReducedBoLChunkData> list = new ArrayList<ReducedBoLChunkData>();
        for (ReducedBoLChunkDataTO reducedChunkDataTO : chunkDataTOCollection) {
            ReducedBoLChunkData reducedChunkData = this.makeOneReduced(reducedChunkDataTO);
            if (reducedChunkData == null) continue;
            list.add(reducedChunkData);
            if (this.isComplete(reducedChunkDataTO)) continue;
            this.completeTO(reducedChunkDataTO, reducedChunkData);
            this.dao.updateIncomplete(reducedChunkDataTO);
        }
        log.debug("BoL CHUNK CATALOG: returning " + list);
        return list;
    }

    private ReducedBoLChunkData makeOneReduced(ReducedBoLChunkDataTO reducedChunkDataTO) {
        StringBuffer errorSb = new StringBuffer();
        TSURL fromSURL = null;
        try {
            fromSURL = TSURL.makeFromStringValidate(reducedChunkDataTO.fromSURL());
        }
        catch (InvalidTSURLAttributesException e) {
            errorSb.append(e);
        }
        if (reducedChunkDataTO.normalizedStFN() != null) {
            fromSURL.setNormalizedStFN(reducedChunkDataTO.normalizedStFN());
        }
        if (reducedChunkDataTO.surlUniqueID() != null) {
            fromSURL.setUniqueID(reducedChunkDataTO.surlUniqueID());
        }
        TReturnStatus status = null;
        TStatusCode code = StatusCodeConverter.getInstance().toSTORM(reducedChunkDataTO.status());
        if (code == TStatusCode.EMPTY) {
            errorSb.append("\nRetrieved StatusCode was not recognised: " + reducedChunkDataTO.status());
        } else {
            try {
                status = new TReturnStatus(code, reducedChunkDataTO.errString());
            }
            catch (InvalidTReturnStatusAttributeException e) {
                errorSb.append("\n");
                errorSb.append(e);
            }
        }
        ReducedBoLChunkData aux = null;
        try {
            aux = new ReducedBoLChunkData(fromSURL, status);
            aux.setPrimaryKey(reducedChunkDataTO.primaryKey());
        }
        catch (InvalidReducedBoLChunkDataAttributesException e) {
            log.warn("BoL CHUNK CATALOG! Retrieved malformed Reduced BoL chunk data from persistence: dropping reduced chunk...");
            log.warn(e.getMessage(), (Throwable)e);
            log.warn(errorSb.toString());
        }
        return aux;
    }

    public synchronized void addChild(BoLPersistentChunkData chunkData) {
        BoLChunkDataTO to = new BoLChunkDataTO();
        to.setRequestToken(chunkData.getRequestToken().toString());
        to.setFromSURL(chunkData.getSURL().toString());
        to.setNormalizedStFN(chunkData.getSURL().normalizedStFN());
        to.setSurlUniqueID(new Integer(chunkData.getSURL().uniqueId()));
        to.setAllLevelRecursive(chunkData.getDirOption().isAllLevelRecursive());
        to.setDirOption(chunkData.getDirOption().isDirectory());
        to.setNumLevel(chunkData.getDirOption().getNumLevel());
        to.setStatus(StatusCodeConverter.getInstance().toDB(chunkData.getStatus().getStatusCode()));
        to.setErrString(chunkData.getStatus().getExplanation());
        to.setDeferredStartTime(chunkData.getDeferredStartTime());
        this.dao.addChild(to);
        chunkData.setPrimaryKey(to.getPrimaryKey());
    }

    public synchronized void add(BoLPersistentChunkData chunkData, GridUserInterface gu) {
        BoLChunkDataTO to = new BoLChunkDataTO();
        to.setRequestToken(chunkData.getRequestToken().toString());
        to.setFromSURL(chunkData.getSURL().toString());
        to.setNormalizedStFN(chunkData.getSURL().normalizedStFN());
        to.setSurlUniqueID(new Integer(chunkData.getSURL().uniqueId()));
        to.setLifeTime(new Long(chunkData.getLifeTime().value()).intValue());
        to.setAllLevelRecursive(chunkData.getDirOption().isAllLevelRecursive());
        to.setDirOption(chunkData.getDirOption().isDirectory());
        to.setNumLevel(chunkData.getDirOption().getNumLevel());
        to.setProtocolList(TransferProtocolListConverter.toDB(chunkData.getTransferProtocols()));
        to.setStatus(StatusCodeConverter.getInstance().toDB(chunkData.getStatus().getStatusCode()));
        to.setErrString(chunkData.getStatus().getExplanation());
        to.setDeferredStartTime(chunkData.getDeferredStartTime());
        this.dao.addNew(to, gu.getDn());
        chunkData.setPrimaryKey(to.getPrimaryKey());
    }

    public synchronized boolean isSRM_FILE_PINNED(TSURL surl) {
        return this.dao.numberInSRM_SUCCESS(surl.uniqueId()) > 0;
    }

    public synchronized void transitSRM_SUCCESStoSRM_RELEASED(Collection<ReducedBoLChunkData> chunks, TRequestToken token) {
        if (chunks == null || chunks.isEmpty()) {
            return;
        }
        long[] primaryKeys = new long[chunks.size()];
        int index = 0;
        for (ReducedBoLChunkData chunkData : chunks) {
            if (chunkData == null) continue;
            primaryKeys[index] = chunkData.primaryKey();
            ++index;
        }
        this.dao.transitSRM_SUCCESStoSRM_RELEASED(primaryKeys, token);
    }

    public synchronized void transitSRM_SUCCESStoSRM_ABORTED(TSURL surl, String explanation) {
        if (explanation == null) {
            explanation = "";
        }
        this.dao.transitSRM_SUCCESStoSRM_ABORTED(surl.uniqueId(), surl.toString(), explanation);
    }

    public synchronized void transitExpiredSRM_SUCCESS() {
        this.dao.transitExpiredSRM_SUCCESS();
    }

    public void updateFromPreviousStatus(TRequestToken requestToken, TStatusCode expectedStatusCode, TStatusCode newStatusCode, String explanation) {
        this.dao.updateStatusOnMatchingStatus(requestToken, expectedStatusCode, newStatusCode, explanation);
    }

    public void updateFromPreviousStatus(TRequestToken requestToken, List<TSURL> surlList, TStatusCode expectedStatusCode, TStatusCode newStatusCode) {
        int[] surlsUniqueIDs = new int[surlList.size()];
        String[] surls = new String[surlList.size()];
        int index = 0;
        for (TSURL tsurl : surlList) {
            surlsUniqueIDs[index] = tsurl.uniqueId();
            surls[index] = tsurl.rawSurl();
            ++index;
        }
        this.dao.updateStatusOnMatchingStatus(requestToken, surlsUniqueIDs, surls, expectedStatusCode, newStatusCode);
    }
}

