/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.balancer.ftp;

import it.grid.storm.balancer.ftp.FtpReplyMessage;
import it.grid.storm.balancer.ftp.GridFtpConnectionStatus;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelnetClientHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger log = LoggerFactory.getLogger(TelnetClientHandler.class);
    private final GridFtpConnectionStatus state = new GridFtpConnectionStatus();

    public GridFtpConnectionStatus getState() {
        return this.state;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        FtpReplyMessage msg = new FtpReplyMessage(e.getMessage().toString());
        this.state.setMessageParsingResponse(msg.isRecognizedAsFTP());
        this.state.messageReceived();
        this.state.updated();
        super.messageReceived(ctx, e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        log.warn("Server unreachable " + e.getCause().getMessage());
        this.state.setError();
        this.state.updated();
    }
}

