/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.balancer.ftp;

import it.grid.storm.balancer.ftp.FtpReplyCode;

public class FtpReplyMessage {
    private String serverMessage;
    private FtpReplyCode replyCode = FtpReplyCode.UNKNOWN_ERROR;
    private boolean recognizedAsFTP = false;

    public FtpReplyMessage(String serverMessage) {
        this.serverMessage = serverMessage;
        this.parse(serverMessage);
    }

    private void parse(String serverMessage) {
        if (serverMessage == null || serverMessage.length() < 3) {
            return;
        }
        String returnCode = serverMessage.substring(0, 3);
        try {
            int retCode = Integer.parseInt(returnCode);
            this.replyCode = FtpReplyCode.find(retCode);
        }
        catch (NumberFormatException nfe) {
            return;
        }
        if (FtpReplyCode.SERVICE_READY.equals((Object)this.replyCode)) {
            this.recognizedAsFTP = true;
        }
    }

    public final String getServerMessage() {
        return this.serverMessage;
    }

    public final FtpReplyCode getReplyCode() {
        return this.replyCode;
    }

    public final boolean isRecognizedAsFTP() {
        return this.recognizedAsFTP;
    }
}

