/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.balancer;

import it.grid.storm.balancer.Node;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponsivenessCache {
    private static final Logger log = LoggerFactory.getLogger(ResponsivenessCache.class);
    private final Map<Node, ResponsivenessCacheEntry> cache = new HashMap<Node, ResponsivenessCacheEntry>();
    private long entryLifetime;

    public ResponsivenessCache(long entryLifetimeMillisec) {
        this.entryLifetime = entryLifetimeMillisec;
    }

    public ResponsivenessCacheEntry addEntry(Node node) {
        log.debug("Adding cache entry for " + node);
        ResponsivenessCacheEntry newEntry = new ResponsivenessCacheEntry(node, Responsiveness.UNKNOWN);
        this.cache.put(node, newEntry);
        return newEntry;
    }

    public Responsiveness getResponsiveness(Node node) throws Exception {
        Responsiveness resp = Responsiveness.UNKNOWN;
        ResponsivenessCacheEntry entry = this.getEntry(node);
        if (entry != null) {
            if (this.isExpired(entry)) {
                log.debug("Cache entry " + entry.toString() + " expired. Refresching");
                resp = entry.refresh();
            } else {
                log.debug("Found valid cache entry for " + entry.toString());
                resp = entry.getStatus();
            }
        } else {
            log.debug("Missing cache entry for " + node + " .Adding and refresching");
            entry = this.addEntry(node);
            resp = entry.refresh();
        }
        return resp;
    }

    public boolean isExpired(ResponsivenessCacheEntry entry) {
        if (entry != null) {
            return entry.isExpired(this.entryLifetime);
        }
        return true;
    }

    public ResponsivenessCacheEntry getEntry(Node node) {
        return this.cache.get(node);
    }

    private class ResponsivenessCacheEntry {
        private final Node cachedNode;
        private long checkTime = -1L;
        private Responsiveness status = Responsiveness.UNKNOWN;

        public ResponsivenessCacheEntry(Node node, Responsiveness status) {
            this.cachedNode = node;
            this.status = status;
        }

        public final Responsiveness getStatus() {
            return this.status;
        }

        private final void setStatus(Responsiveness status) {
            this.status = status;
        }

        public boolean isExpired(long lifetime) {
            return System.currentTimeMillis() - this.checkTime >= lifetime;
        }

        public final Responsiveness refresh() throws Exception {
            Responsiveness respness = Responsiveness.UNKNOWN;
            respness = this.cachedNode.checkServer() ? Responsiveness.RESPONSIVE : Responsiveness.UNRESPONSIVE;
            this.checkTime = new Date().getTime();
            this.setStatus(respness);
            return this.status;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ResponsivenessCacheEntry [cachedNode=");
            builder.append(this.cachedNode);
            builder.append(", checkTime=");
            builder.append(this.checkTime);
            builder.append(", status=");
            builder.append((Object)this.status);
            builder.append("]");
            return builder.toString();
        }
    }

    public static enum Responsiveness {
        RESPONSIVE,
        UNRESPONSIVE,
        UNKNOWN;

    }
}

