/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.balancer;

import java.util.concurrent.atomic.AtomicInteger;

public class CyclicCounter {
    private int maxVal;
    private final AtomicInteger counter = new AtomicInteger(0);

    public CyclicCounter(int maxVal) throws IllegalArgumentException {
        if (maxVal < 0) {
            throw new IllegalArgumentException("Maximum counter value should be >= 0");
        }
        this.maxVal = maxVal;
    }

    public int next() {
        int newVal;
        int curVal;
        while (!this.counter.compareAndSet(curVal = this.counter.get(), newVal = (curVal + 1) % (this.maxVal + 1))) {
        }
        return newVal;
    }
}

