/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.balancer;

import java.util.EnumSet;

public enum BalancingStrategyType {
    RANDOM("random", Weighted.NOWEIGHT),
    ROUNDROBIN("round-robin", Weighted.NOWEIGHT),
    WEIGHT("weight", Weighted.WEIGHTED),
    SMART_RR("smart-rr", Weighted.NOWEIGHT);

    private String name;
    private boolean withWeight;

    private BalancingStrategyType(String name, Weighted w) {
        this.name = name;
        this.withWeight = w == Weighted.WEIGHTED;
    }

    public String toString() {
        return this.name;
    }

    public boolean requireWeight() {
        return this.withWeight;
    }

    public static BalancingStrategyType getByValue(String name) {
        for (BalancingStrategyType element : EnumSet.allOf(BalancingStrategyType.class)) {
            if (!element.toString().equals(name)) continue;
            return element;
        }
        return null;
    }

    private static enum Weighted {
        WEIGHTED,
        NOWEIGHT;

    }
}

