/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.balancer;

import it.grid.storm.balancer.BalancingStrategy;
import it.grid.storm.balancer.BalancingStrategyType;
import it.grid.storm.balancer.Node;
import it.grid.storm.balancer.RandomStrategy;
import it.grid.storm.balancer.RoundRobinStrategy;
import it.grid.storm.balancer.SmartRoundRobinStrategy;
import it.grid.storm.balancer.WeightStrategy;
import java.util.List;

public class BalancingStrategyFactory {
    public static <E extends Node> BalancingStrategy<E> getBalancingStrategy(BalancingStrategyType type, List<E> pool) throws IllegalArgumentException {
        switch (type) {
            case RANDOM: {
                return new RandomStrategy<E>(pool);
            }
            case ROUNDROBIN: {
                return new RoundRobinStrategy<E>(pool);
            }
            case WEIGHT: {
                return new WeightStrategy<E>(pool);
            }
            case SMART_RR: {
                return new SmartRoundRobinStrategy<E>(pool);
            }
        }
        throw new IllegalArgumentException("StrategyFactory: Unknown BalancingStrategyType: " + (Object)((Object)type));
    }
}

