/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.authz.sa.conf;

import it.grid.storm.authz.AuthzDirector;
import it.grid.storm.authz.sa.conf.AuthzDBReaderException;
import it.grid.storm.authz.sa.model.AceType;
import it.grid.storm.authz.sa.model.SpaceACE;
import it.grid.storm.authz.sa.model.SpaceAccessMask;
import it.grid.storm.authz.sa.model.SpaceOperation;
import it.grid.storm.authz.sa.model.SubjectPattern;
import it.grid.storm.authz.sa.model.SubjectType;
import org.slf4j.Logger;

public class SpaceACETextParser {
    private static final Logger LOG = AuthzDirector.getLogger();

    private SpaceACETextParser() {
    }

    public static SpaceACE parse(String aceString) throws AuthzDBReaderException {
        return SpaceACETextParser.parseACE(aceString);
    }

    private static SpaceACE parseACE(String aceString) throws AuthzDBReaderException {
        String patternStr;
        int aceNumber = SpaceACETextParser.parseAceNumber(aceString);
        String[] fields = (aceString = aceString.substring(aceString.indexOf(61))).split(patternStr = ":");
        if (fields.length != 4) {
            throw new AuthzDBReaderException("ACEString :" + aceString + " is not well formed");
        }
        for (int i = 0; i < fields.length; ++i) {
            LOG.debug("Field[" + i + "]='" + fields[i] + "'");
        }
        SubjectType subjectType = SpaceACETextParser.parseSubjectType(fields[0].substring(1));
        SubjectPattern subjectPattern = SpaceACETextParser.parseSubjectPattern(fields[0]);
        SpaceAccessMask spaceAccessMask = SpaceACETextParser.parseSpaceAccessMask(fields[1]);
        AceType aceType = SpaceACETextParser.parseACEType(fields[2]);
        SpaceACE spaceACE = new SpaceACE();
        spaceACE.setAceNumber(aceNumber);
        spaceACE.setSpaceAccessMask(spaceAccessMask);
        spaceACE.setSubjectType(subjectType);
        spaceACE.setSubjectPattern(subjectPattern);
        spaceACE.setAceType(aceType);
        return spaceACE;
    }

    private static int parseAceNumber(String aceString) throws AuthzDBReaderException {
        int aceNumber = -1;
        int index = aceString.indexOf(61);
        String prefix = aceString.substring(0, 4);
        if (!prefix.equals("ace.")) {
            throw new AuthzDBReaderException("Prefix of ACE '" + aceString + "' is not compliant with 'ace.'");
        }
        String numb = aceString.substring(4, index);
        try {
            aceNumber = Integer.parseInt(numb);
        }
        catch (Exception e) {
            throw new AuthzDBReaderException("Number Format error in '" + aceString + "'");
        }
        LOG.debug("number = " + aceNumber);
        return aceNumber;
    }

    private static SubjectType parseSubjectType(String subjectTp) throws AuthzDBReaderException {
        SubjectType st = SubjectType.getSubjectType(subjectTp);
        if (st.equals(SubjectType.UNKNOWN)) {
            throw new AuthzDBReaderException("Unknown Subject Type in '" + subjectTp + "'");
        }
        return st;
    }

    private static SubjectPattern parseSubjectPattern(String subjectPattern) throws AuthzDBReaderException {
        return null;
    }

    private static SpaceAccessMask parseSpaceAccessMask(String accessMaskStr) throws AuthzDBReaderException {
        SpaceAccessMask spAM = new SpaceAccessMask();
        if (accessMaskStr != null) {
            char[] spAMarray;
            for (char element : spAMarray = accessMaskStr.toCharArray()) {
                spAM.addSpaceOperation(SpaceOperation.getSpaceOperation(element));
            }
        }
        return spAM;
    }

    private static AceType parseACEType(String aceTypeStr) throws AuthzDBReaderException {
        return AceType.getAceType(aceTypeStr);
    }
}

