/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.authz.sa.conf;

import it.grid.storm.authz.AuthzDirector;
import java.io.File;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.slf4j.Logger;

public class FileAuthzDBReloadingStrategy
extends FileChangedReloadingStrategy {
    private final Logger log = AuthzDirector.getLogger();
    private long reloadingTime;
    private boolean notifing = false;

    protected void notifingPerformed() {
        this.notifing = false;
    }

    protected boolean notifingRequired() {
        return this.notifing;
    }

    protected void notifyNeeded() {
        this.notifing = true;
    }

    public boolean reloadingRequired() {
        boolean reloading = false;
        long now = System.currentTimeMillis();
        if (now > this.lastChecked + this.refreshDelay) {
            this.lastChecked = now;
            if (this.hasChanged()) {
                reloading = true;
            }
        }
        return reloading;
    }

    public void reloadingPerformed() {
        this.updateLastModified();
        this.reloadingTime = System.currentTimeMillis();
        this.log.debug("REFRESHING the AUTHZDB CACHE!!!");
    }

    protected boolean hasChanged() {
        boolean result;
        File file = this.getConfigurationFile();
        if (file == null || !file.exists()) {
            return false;
        }
        boolean bl = result = file.lastModified() > this.lastModified;
        if (result) {
            this.notifyNeeded();
            this.log.debug(" AuthZ DB " + file.getName() + " is CHANGED ---> Notify needed..");
        }
        return result;
    }

    public long getLastReload() {
        return this.reloadingTime;
    }

    public File getConfigurationFile() {
        return this.configuration.getFile();
    }
}

