/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.authz.sa;

import it.grid.storm.authz.AuthzDirector;
import it.grid.storm.authz.sa.SpaceAuthz;
import it.grid.storm.authz.sa.model.FileAuthzDB;
import it.grid.storm.authz.sa.model.SRMSpaceRequest;
import it.grid.storm.config.Configuration;
import it.grid.storm.griduser.GridUserInterface;
import java.io.File;
import org.slf4j.Logger;

public class SpaceDBAuthz
extends SpaceAuthz {
    private final Logger log = AuthzDirector.getLogger();
    public static final String UNDEF = "undef-SpaceAuthzDB";
    private String spaceAuthzDBID = "not-defined";
    private static String configurationPATH;
    private String dbFileName;
    private FileAuthzDB authzDB;

    public SpaceDBAuthz() {
    }

    public static SpaceDBAuthz makeEmpty() {
        SpaceDBAuthz result = new SpaceDBAuthz();
        result.setSpaceAuthzDBID("default-SpaceAuthzDB");
        return result;
    }

    public SpaceDBAuthz(String dbFileName) {
        Configuration config = Configuration.getInstance();
        configurationPATH = config.namespaceConfigPath();
        if (this.existsAuthzDBFile(dbFileName)) {
            this.dbFileName = dbFileName;
            this.spaceAuthzDBID = dbFileName;
        }
    }

    void setSpaceAuthzDBID(String id) {
        this.spaceAuthzDBID = id;
    }

    @Override
    public boolean authorize(GridUserInterface guser, SRMSpaceRequest srmSpaceOp) {
        return false;
    }

    @Override
    public boolean authorizeAnonymous(SRMSpaceRequest srmSpaceOp) {
        return false;
    }

    private boolean nfs4AuthzAlgorithm(GridUserInterface guser, SRMSpaceRequest srmSpaceOp) {
        return false;
    }

    private boolean isPresent(GridUserInterface guser) {
        return false;
    }

    private void addRequestorToCache(GridUserInterface guser) {
    }

    private void refreshCache() {
    }

    private boolean existsAuthzDBFile(String dbFileName) {
        String fileName = configurationPATH + File.separator + dbFileName;
        boolean exists = new File(fileName).exists();
        if (!exists) {
            this.log.error("The AuthzDB File '" + dbFileName + "' does not exists");
        }
        return exists;
    }

    String getAuthzDBFileName() {
        return this.dbFileName;
    }

    void setAuthzDB(FileAuthzDB authzDB) {
        this.authzDB = authzDB;
    }

    @Override
    public String getSpaceAuthzID() {
        return this.spaceAuthzDBID;
    }

    @Override
    public void refresh() {
    }
}

