/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.authz.remote.resource;

import com.sun.jersey.server.impl.ResponseBuilderImpl;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestParameters {
    private static final Logger log = LoggerFactory.getLogger(RequestParameters.class);
    private final String DNDecoded;
    private final String FQANSDecoded;
    private final String filePathDecoded;
    private final boolean hasVomsExtension;

    RequestParameters(String filePath) throws WebApplicationException {
        log.debug("Building RequestParameters from filePath =" + filePath);
        this.filePathDecoded = RequestParameters.decodeAndCheckFilePath(filePath);
        this.hasVomsExtension = false;
        this.FQANSDecoded = null;
        this.DNDecoded = null;
    }

    RequestParameters(String filePath, String DN) throws WebApplicationException {
        log.debug("Building RequestParameters from filePath =" + filePath + " , DN=" + DN);
        this.filePathDecoded = RequestParameters.decodeAndCheckFilePath(filePath);
        this.DNDecoded = RequestParameters.decodeAndCheckDN(DN);
        this.hasVomsExtension = false;
        this.FQANSDecoded = null;
    }

    RequestParameters(String filePath, String DN, String FQANS) throws WebApplicationException {
        log.debug("Building RequestParameters from filePath =" + filePath + " , DN=" + DN + " , FQANS=" + FQANS);
        this.filePathDecoded = RequestParameters.decodeAndCheckFilePath(filePath);
        this.DNDecoded = RequestParameters.decodeAndCheckDN(DN);
        this.FQANSDecoded = RequestParameters.decodeAndCheckFQANS(FQANS);
        this.hasVomsExtension = true;
    }

    private static String decodeAndCheckFilePath(String filePath) throws WebApplicationException {
        URI filePathURI;
        String filePathDecoded;
        try {
            filePathDecoded = URLDecoder.decode(filePath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Unable to decode filePath parameter. UnsupportedEncodingException : " + e.getMessage());
            ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
            responseBuilder.status(Response.Status.BAD_REQUEST);
            responseBuilder.entity((Object)"Unable to decode filePath paramether, unsupported encoding 'UTF-8'");
            throw new WebApplicationException(responseBuilder.build());
        }
        log.debug("Decoded filePath = " + filePathDecoded);
        if (filePathDecoded == null || filePathDecoded.trim().equals("")) {
            log.error("Unable to evaluate permissions. Some parameters are missing : filePath " + filePathDecoded);
            ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
            responseBuilder.status(Response.Status.BAD_REQUEST);
            responseBuilder.entity((Object)"Unable to evaluate permissions. Some parameters are missing");
            throw new WebApplicationException(responseBuilder.build());
        }
        try {
            filePathURI = new URI(filePathDecoded);
        }
        catch (URISyntaxException e) {
            log.error("Unable to evaluate permissions on path " + filePathDecoded + " .URISyntaxException : " + e.getMessage());
            ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
            responseBuilder.status(Response.Status.BAD_REQUEST);
            responseBuilder.entity((Object)"Unable to evaluate permissions. Invalid file path");
            throw new WebApplicationException(responseBuilder.build());
        }
        return filePathURI.normalize().toString();
    }

    private static String decodeAndCheckDN(String DN) throws WebApplicationException {
        String DNDecoded;
        try {
            DNDecoded = URLDecoder.decode(DN, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Unable to decode DN parameter. UnsupportedEncodingException : " + e.getMessage());
            ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
            responseBuilder.status(Response.Status.BAD_REQUEST);
            responseBuilder.entity((Object)"Unable to decode DN paramether, unsupported encoding 'UTF-8'");
            throw new WebApplicationException(responseBuilder.build());
        }
        log.debug("Decoded DN = " + DNDecoded);
        if (DNDecoded == null || DNDecoded.trim().equals("")) {
            log.error("Unable to evaluate permissions. Some parameters are missing : DN " + DNDecoded);
            ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
            responseBuilder.status(Response.Status.BAD_REQUEST);
            responseBuilder.entity((Object)"Unable to evaluate permissions. Some parameters are missing");
            throw new WebApplicationException(responseBuilder.build());
        }
        return DNDecoded;
    }

    private static String decodeAndCheckFQANS(String FQANS) throws WebApplicationException {
        String FQANSDecoded;
        try {
            FQANSDecoded = URLDecoder.decode(FQANS, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Unable to decode FQANS parameter. UnsupportedEncodingException : " + e.getMessage());
            ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
            responseBuilder.status(Response.Status.BAD_REQUEST);
            responseBuilder.entity((Object)"Unable to decode FQANS paramether, unsupported encoding 'UTF-8'");
            throw new WebApplicationException(responseBuilder.build());
        }
        log.debug("Decoded FQANS = " + FQANSDecoded);
        if (FQANSDecoded == null || FQANSDecoded.trim().equals("")) {
            log.error("Unable to evaluate permissions. Some parameters are missing : FQANS " + FQANS);
            ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
            responseBuilder.status(Response.Status.BAD_REQUEST);
            responseBuilder.entity((Object)"Unable to evaluate permissions. Some parameters are missing");
            throw new WebApplicationException(responseBuilder.build());
        }
        return FQANSDecoded;
    }

    public String getDNDecoded() {
        return this.DNDecoded;
    }

    public String getFQANSDecoded() {
        return this.FQANSDecoded;
    }

    public String getFilePathDecoded() {
        return this.filePathDecoded;
    }

    public boolean hasVomsExtension() {
        return this.hasVomsExtension;
    }
}

