/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.authz.path.model;

import it.grid.storm.authz.path.model.PathAccessMask;
import it.grid.storm.authz.path.model.PathOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public enum SRMFileRequest {
    PTP_Overwrite("srmPrepareToPut-overwrite", "PTP-Over", (List<PathOperation>)new ArrayList<PathOperation>(){
        {
            this.add(PathOperation.WRITE_FILE);
        }
    }),
    PTP("srmPrepareToPut", "PTP", (List<PathOperation>)new ArrayList<PathOperation>(){
        {
            this.add(PathOperation.CREATE_FILE);
            this.add(PathOperation.WRITE_FILE);
        }
    }),
    PTG("srmPrepareToGet", "PTG", (List<PathOperation>)new ArrayList<PathOperation>(){
        {
            this.add(PathOperation.READ_FILE);
        }
    }),
    CPto("srmCopy to", "CPto", (List<PathOperation>)new ArrayList<PathOperation>(){
        {
            this.add(PathOperation.WRITE_FILE);
            this.add(PathOperation.CREATE_FILE);
        }
    }),
    CPto_Overwrite("srmCopy to-overwrite", "CPto_Over", (List<PathOperation>)new ArrayList<PathOperation>(){
        {
            this.add(PathOperation.WRITE_FILE);
        }
    }),
    CPfrom("srmCopy from", "CPfrom", (List<PathOperation>)new ArrayList<PathOperation>(){
        {
            this.add(PathOperation.READ_FILE);
        }
    }),
    RM("srmRemove", "RM", (List<PathOperation>)new ArrayList<PathOperation>(){
        {
            this.add(PathOperation.DELETE);
        }
    }),
    RMD("srmRemoveDir", "RMD", (List<PathOperation>)new ArrayList<PathOperation>(){
        {
            this.add(PathOperation.DELETE);
        }
    }),
    MD("srmMakeDir", "MD", (List<PathOperation>)new ArrayList<PathOperation>(){
        {
            this.add(PathOperation.MAKE_DIRECTORY);
        }
    }),
    LS("srmLS", "LS", (List<PathOperation>)new ArrayList<PathOperation>(){
        {
            this.add(PathOperation.LIST_DIRECTORY);
        }
    }),
    MV_source("srmMove-source", "MV-source", (List<PathOperation>)new ArrayList<PathOperation>(){
        {
            this.add(PathOperation.READ_FILE);
            this.add(PathOperation.DELETE);
        }
    }),
    MV_dest_Overwrite("srmMove-dest-overwrite", "MV-dest-Over", (List<PathOperation>)new ArrayList<PathOperation>(){
        {
            this.add(PathOperation.WRITE_FILE);
        }
    }),
    MV_dest("srmMove-dest-overwrite", "MV-dest", (List<PathOperation>)new ArrayList<PathOperation>(){
        {
            this.add(PathOperation.CREATE_FILE);
            this.add(PathOperation.WRITE_FILE);
        }
    });

    private final String description;
    private final String srmOp;
    private final PathAccessMask requestedPathOps;
    private static HashMap<String, SRMFileRequest> ops;

    public static SRMFileRequest buildFromString(String srmOp) {
        if (ops.containsKey(srmOp)) {
            return ops.get(srmOp);
        }
        return null;
    }

    private SRMFileRequest(String description, String srmOp, List<PathOperation> pathOps) {
        this.description = description;
        this.srmOp = srmOp;
        this.requestedPathOps = new PathAccessMask();
        for (PathOperation pathOp : pathOps) {
            this.requestedPathOps.addPathOperation(pathOp);
        }
    }

    public PathAccessMask getSRMPathAccessMask() {
        return this.requestedPathOps;
    }

    public String toString() {
        String result = this.srmOp + " : " + this.description + " = " + this.requestedPathOps;
        return result;
    }

    public boolean isReadOnly() {
        for (PathOperation operation : this.requestedPathOps.getPathOperations()) {
            if (operation.isReadOnly()) continue;
            return false;
        }
        return true;
    }

    static {
        ops = new HashMap<String, SRMFileRequest>(){
            {
                this.put("PTP-Over", PTP_Overwrite);
                this.put("srmPrepareToPut-overwrite", PTP_Overwrite);
                this.put("PTP", PTP);
                this.put("srmPrepareToPut", PTP);
                this.put("PTG", PTG);
                this.put("srmPrepareToGet", PTG);
                this.put("CPto_Over", CPto_Overwrite);
                this.put("srmCopy to-overwrite", CPto_Overwrite);
                this.put("CPto", CPto);
                this.put("srmCopy to", CPto);
                this.put("CPFrom", CPfrom);
                this.put("srmCopy from", CPfrom);
                this.put("RM", RM);
                this.put("srmRm", RM);
                this.put("RMD", RMD);
                this.put("srmRemoveDir", RM);
                this.put("MD", MD);
                this.put("srmMakeDir", MD);
                this.put("LS", LS);
                this.put("srmLs", LS);
                this.put("MV-source", MV_source);
                this.put("srmMove-source", MV_source);
                this.put("MV-dest-Over", MV_dest_Overwrite);
                this.put("srmMove-dest-overwrite", MV_dest_Overwrite);
                this.put("MV-dest", MV_dest);
                this.put("srmMove-dest", MV_dest);
            }
        };
    }
}

