/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.authz.path.model;

import it.grid.storm.authz.AuthzDecision;
import it.grid.storm.authz.AuthzDirector;
import it.grid.storm.authz.path.model.PathACE;
import it.grid.storm.authz.path.model.PathAccessMask;
import it.grid.storm.authz.path.model.PathAuthzEvaluationAlgorithm;
import it.grid.storm.authz.path.model.PathOperation;
import it.grid.storm.authz.path.model.SRMFileRequest;
import it.grid.storm.common.types.StFN;
import it.grid.storm.namespace.naming.NamespaceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;

public class PathAuthzAlgBestMatch
extends PathAuthzEvaluationAlgorithm {
    protected static final Logger log = AuthzDirector.getLogger();

    public static PathAuthzEvaluationAlgorithm getInstance() {
        if (instance == null) {
            instance = new PathAuthzAlgBestMatch();
        }
        return instance;
    }

    private PathAuthzAlgBestMatch() {
    }

    @Override
    public String getDescription() {
        String description = "< Best Match Path Authorization Algorithm >";
        return description;
    }

    @Override
    public AuthzDecision evaluate(String subject, StFN fileName, SRMFileRequest pathOperation, List<PathACE> acl) {
        AuthzDecision result = AuthzDecision.INDETERMINATE;
        List<PathACE> compACE = this.getCompatibleACE(subject, acl);
        if (compACE == null || compACE.isEmpty()) {
            return AuthzDecision.NOT_APPLICABLE;
        }
        List<OrderedACE> orderedACEs = this.getOrderedACEs(fileName, compACE);
        log.debug("There are '" + orderedACEs.size() + "' ACEs regarding the subject '" + subject + "'");
        PathAccessMask requestedOps = pathOperation.getSRMPathAccessMask();
        ArrayList<PathOperation> ops = new ArrayList<PathOperation>(requestedOps.getPathOperations());
        log.trace("<Best-Match> Operation to authorize: " + ops);
        HashMap<PathOperation, AuthzDecision> decision = new HashMap<PathOperation, AuthzDecision>();
        String explanation = "Operations to authorize to '" + subject + "' are :" + ops + "\n";
        for (PathOperation op : ops) {
            explanation = explanation + " op('" + (Object)((Object)op) + "') is ";
            for (OrderedACE oAce : orderedACEs) {
                if (!oAce.ace.getPathAccessMask().containsPathOperation(op)) continue;
                if (oAce.ace.isPermitAce()) {
                    explanation = explanation + "PERMIT, thanks to ACE: '" + oAce + "'\n";
                    log.trace("Path Operation '" + (Object)((Object)op) + "' is PERMIT");
                    decision.put(op, AuthzDecision.PERMIT);
                    break;
                }
                explanation = explanation + "DENY, thanks to ACE: '" + oAce + "'\n";
                log.trace("Path Operation '" + (Object)((Object)op) + "' is DENY");
                decision.put(op, AuthzDecision.DENY);
                break;
            }
            if (decision.containsKey((Object)op)) continue;
            decision.put(op, AuthzDecision.INDETERMINATE);
        }
        log.debug("Decision explanation : \n --------------" + explanation + "--------------");
        result = decision.containsValue((Object)AuthzDecision.DENY) ? AuthzDecision.DENY : (decision.containsValue((Object)AuthzDecision.INDETERMINATE) ? AuthzDecision.INDETERMINATE : AuthzDecision.PERMIT);
        return result;
    }

    @Override
    public AuthzDecision evaluate(String subject, StFN fileName, PathOperation op, List<PathACE> acl) {
        List<PathACE> compACE = this.getCompatibleACE(subject, acl);
        if (compACE == null || compACE.isEmpty()) {
            return AuthzDecision.NOT_APPLICABLE;
        }
        List<OrderedACE> orderedACEs = this.getOrderedACEs(fileName, compACE);
        log.debug("There are '" + orderedACEs.size() + "' ACEs regarding the subject '" + subject + "'");
        log.trace("<Best-Match> Operation to authorize to '" + subject + "' is : " + (Object)((Object)op));
        for (OrderedACE oAce : orderedACEs) {
            if (!oAce.ace.getPathAccessMask().containsPathOperation(op)) continue;
            if (oAce.ace.isPermitAce()) {
                log.trace("Path Operation '" + (Object)((Object)op) + "' is PERMIT");
                return AuthzDecision.PERMIT;
            }
            log.trace("Path Operation '" + (Object)((Object)op) + "' is DENY");
            return AuthzDecision.DENY;
        }
        return AuthzDecision.INDETERMINATE;
    }

    @Override
    public AuthzDecision evaluateAnonymous(StFN fileName, PathOperation pathOperation, LinkedList<PathACE> authzDB) {
        if (authzDB == null || authzDB.isEmpty()) {
            return AuthzDecision.NOT_APPLICABLE;
        }
        List<OrderedACE> orderedACEs = this.getOrderedACEs(fileName, authzDB);
        log.debug("There are '" + orderedACEs.size() + "' ACEs regarding file '" + fileName + "'");
        log.trace("<Best-Match> Operation that needs anonymous authorization is : " + (Object)((Object)pathOperation));
        for (OrderedACE oAce : orderedACEs) {
            if (!oAce.ace.isAllGroupsACE() || !oAce.ace.getPathAccessMask().containsPathOperation(pathOperation)) continue;
            if (oAce.ace.isPermitAce()) {
                log.trace("Path Operation '" + (Object)((Object)pathOperation) + "' is PERMIT");
                return AuthzDecision.PERMIT;
            }
            log.trace("Path Operation '" + (Object)((Object)pathOperation) + "' is DENY");
            return AuthzDecision.DENY;
        }
        return AuthzDecision.INDETERMINATE;
    }

    @Override
    public AuthzDecision evaluateAnonymous(StFN fileName, SRMFileRequest pathOperation, LinkedList<PathACE> authzDB) {
        if (authzDB == null || authzDB.isEmpty()) {
            return AuthzDecision.NOT_APPLICABLE;
        }
        List<OrderedACE> orderedACEs = this.getOrderedACEs(fileName, authzDB);
        log.debug("There are '" + orderedACEs.size() + "' ACEs regarding file '" + fileName + "'");
        log.trace("<Best-Match> Operation that needs anonymous authorization is : " + (Object)((Object)pathOperation));
        PathAccessMask requestedOps = pathOperation.getSRMPathAccessMask();
        ArrayList<PathOperation> ops = new ArrayList<PathOperation>(requestedOps.getPathOperations());
        HashMap<PathOperation, AuthzDecision> decision = new HashMap<PathOperation, AuthzDecision>();
        for (PathOperation op : ops) {
            for (OrderedACE oAce : orderedACEs) {
                if (!oAce.ace.isAllGroupsACE() || !oAce.ace.getPathAccessMask().containsPathOperation(op)) continue;
                if (oAce.ace.isPermitAce()) {
                    log.trace("Path Operation '" + (Object)((Object)pathOperation) + "' is PERMIT");
                    decision.put(op, AuthzDecision.PERMIT);
                    continue;
                }
                log.trace("Path Operation '" + (Object)((Object)pathOperation) + "' is DENY");
                decision.put(op, AuthzDecision.DENY);
            }
        }
        AuthzDecision result = decision.containsValue((Object)AuthzDecision.DENY) ? AuthzDecision.DENY : (decision.containsValue((Object)AuthzDecision.INDETERMINATE) ? AuthzDecision.INDETERMINATE : AuthzDecision.PERMIT);
        return result;
    }

    private List<PathACE> getCompatibleACE(String subjectGroup, List<PathACE> acl) {
        log.debug("<BestMatch>-compatibleACE: subject='" + subjectGroup + "'");
        ArrayList<PathACE> compatibleACE = new ArrayList<PathACE>();
        if (acl != null && !acl.isEmpty()) {
            for (PathACE pathACE : acl) {
                if (pathACE.subjectMatch(subjectGroup)) {
                    log.trace("<BestMatch>-compatibleACE: ACE:'" + pathACE + "' match with subject='" + subjectGroup + "'");
                    compatibleACE.add(pathACE);
                    continue;
                }
                log.trace("<BestMatch>-compatibleACE: ACE:'" + pathACE + "' DOESN'T match with subject='" + subjectGroup + "'");
            }
        } else {
            log.debug("<BestMatch>-compatibleACE: ACL db is empty");
        }
        return compatibleACE;
    }

    private List<OrderedACE> getOrderedACEs(StFN fileName, List<PathACE> compatibleACE) {
        ArrayList<OrderedACE> bestACEs = new ArrayList<OrderedACE>();
        int distance = 0;
        for (PathACE pathAce : compatibleACE) {
            StFN aceStFN = pathAce.getStorageFileName();
            distance = NamespaceUtil.computeDistanceFromPath(aceStFN.getValue(), fileName.getValue());
            bestACEs.add(new OrderedACE(pathAce, distance));
        }
        Collections.sort(bestACEs);
        return bestACEs;
    }

    private class OrderedACE
    implements Comparable<OrderedACE> {
        private final PathACE ace;
        private final int distance;

        OrderedACE(PathACE ace, int distance) {
            this.ace = ace;
            this.distance = distance;
        }

        @Override
        public int compareTo(OrderedACE other) {
            int result = -1;
            OrderedACE otherACE = other;
            result = this.distance < otherACE.distance ? -1 : (this.distance == otherACE.distance ? 0 : 1);
            return result;
        }

        public boolean equals(Object other) {
            boolean result = false;
            if (other instanceof OrderedACE) {
                OrderedACE otherACE = (OrderedACE)other;
                if (this.distance == otherACE.distance) {
                    result = true;
                }
            }
            return result;
        }

        public String toString() {
            return "[" + this.ace.toString() + "]  distance:" + this.distance;
        }
    }
}

