/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.authz.path.model;

import it.grid.storm.authz.AuthzDirector;
import it.grid.storm.authz.AuthzException;
import it.grid.storm.authz.path.model.PathAccessMask;
import it.grid.storm.authz.path.model.PathOperation;
import it.grid.storm.common.types.InvalidStFNAttributeException;
import it.grid.storm.common.types.StFN;
import it.grid.storm.namespace.util.userinfo.LocalGroups;
import java.net.URI;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class PathACE {
    private static final Logger log = AuthzDirector.getLogger();
    public static final String ALL_GROUPS_PATTERN = "@ALL@?|\\*";
    public static final String ALL_GROUPS = "@ALL@";
    private static final Pattern allGroupsPattern = Pattern.compile("@ALL@?|\\*");
    public static final String FIELD_SEP = "\\s";
    private static final boolean PERMIT_ACE = true;
    public static final String ALGORITHM = "algorithm";
    public static final PathACE PERMIT_ALL = PathACE.buildPermitAllPathACE();
    public static final String COMMENT = "#";
    private final String localGroupName;
    private StFN storageFileName;
    private PathAccessMask pathAccessMask;
    private boolean isPermitACE;

    public static PathACE build(PathACE other) throws AuthzException {
        PathACE result = new PathACE(other.localGroupName, other.getStorageFileName(), other.getPathAccessMask(), other.isPermitAce());
        return result;
    }

    private static PathACE buildPermitAllPathACE() throws IllegalStateException {
        try {
            return new PathACE(ALL_GROUPS, StFN.makeEmpty(), PathAccessMask.DEFAULT, true);
        }
        catch (AuthzException e) {
            throw new IllegalStateException("Unexpected AuthzException: " + e);
        }
    }

    public PathACE(String localGroup, StFN stfn, PathAccessMask accessMask, boolean permitACE) throws AuthzException {
        this.storageFileName = stfn;
        this.pathAccessMask = accessMask;
        this.isPermitACE = permitACE;
        if (allGroupsPattern.matcher(localGroup).matches()) {
            this.localGroupName = ALL_GROUPS;
        } else if (LocalGroups.getInstance().isGroupDefined(localGroup)) {
            this.localGroupName = localGroup;
        } else {
            throw new AuthzException("The local group :'" + localGroup + "' is not defined");
        }
    }

    public boolean isAllGroupsACE() {
        return this.localGroupName.equals(ALL_GROUPS);
    }

    public static PathACE buildFromString(String pathACEString) throws AuthzException {
        StFN stfn;
        PathAccessMask pAccessMask = new PathAccessMask();
        String[] fields = pathACEString.split(FIELD_SEP, -1);
        LinkedList<String> notemptyFields = new LinkedList<String>();
        for (String field : fields) {
            if (field.trim().isEmpty()) continue;
            notemptyFields.add(field);
        }
        if (notemptyFields.size() < 4) {
            throw new AuthzException("Error while parsing the Path ACE '" + pathACEString + "'");
        }
        String localGroupName = (String)notemptyFields.get(0);
        try {
            URI.create((String)notemptyFields.get(1));
        }
        catch (IllegalArgumentException uriEx) {
            throw new AuthzException("Error (IllegalArgumentException )while parsing the StFN '" + (String)notemptyFields.get(1) + "' in Path ACE. Is not a valid URI");
        }
        catch (NullPointerException npe) {
            throw new AuthzException("Error (NullPointerException )while parsing the StFN '" + (String)notemptyFields.get(1) + "' in Path ACE.");
        }
        try {
            stfn = StFN.make((String)notemptyFields.get(1));
        }
        catch (InvalidStFNAttributeException e) {
            throw new AuthzException("Error while parsing the StFN '" + (String)notemptyFields.get(1) + "' in Path ACE ");
        }
        for (int i = 0; i < ((String)notemptyFields.get(2)).length(); ++i) {
            PathOperation pathOper = PathOperation.getSpaceOperation(((String)notemptyFields.get(2)).charAt(i));
            pAccessMask.addPathOperation(pathOper);
        }
        boolean permit = !((String)notemptyFields.get(3)).toLowerCase().equals("deny");
        return new PathACE(localGroupName, stfn, pAccessMask, permit);
    }

    public void setStorageFileName(StFN stfn) {
        this.storageFileName = stfn;
    }

    public void setPathAccessMask(PathAccessMask accessMask) {
        this.pathAccessMask = accessMask;
    }

    public void setIsPermitType(boolean value) {
        this.isPermitACE = value;
    }

    public String getLocalGroupName() {
        return this.localGroupName;
    }

    public StFN getStorageFileName() {
        return this.storageFileName;
    }

    public PathAccessMask getPathAccessMask() {
        return this.pathAccessMask;
    }

    public boolean isPermitAce() {
        return this.isPermitACE;
    }

    public boolean subjectMatch(String subjectGroup) {
        Matcher allGroupsMatcher = allGroupsPattern.matcher(this.localGroupName);
        if (allGroupsMatcher.matches() || this.localGroupName.equals(subjectGroup)) {
            log.debug("ACE (" + this.toString() + ") matches with the requestor '" + subjectGroup + "'");
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        PathACE pathOther;
        boolean result = false;
        if (other instanceof PathACE && (pathOther = (PathACE)other).getLocalGroupName() == this.localGroupName && pathOther.getStorageFileName().equals(this.storageFileName) && pathOther.getPathAccessMask().equals(this.pathAccessMask)) {
            result = true;
        }
        return result;
    }

    public int hashCode() {
        int result = 17;
        result += 31 * result + (this.localGroupName == null ? 0 : this.localGroupName.hashCode());
        result += 31 * result + (this.storageFileName == null ? 0 : this.storageFileName.hashCode());
        result += 31 * result + (this.pathAccessMask == null ? 0 : this.pathAccessMask.hashCode());
        result += 31 * result + (this.isPermitACE ? 0 : 1);
        return result;
    }

    public String toString() {
        String result = "";
        result = this.localGroupName == null ? result + "NULL" : result + this.localGroupName;
        result = result + " ";
        result = result + this.storageFileName;
        result = result + " ";
        result = result + this.pathAccessMask;
        result = result + " ";
        result = result + (this.isPermitACE ? "PERMIT" : "DENY");
        return result;
    }
}

