/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.authz.path.conf;

import it.grid.storm.authz.AuthzDirector;
import it.grid.storm.authz.AuthzException;
import it.grid.storm.authz.path.conf.PathAuthzDB;
import it.grid.storm.authz.path.model.PathACE;
import it.grid.storm.authz.path.model.PathAuthzEvaluationAlgorithm;
import it.grid.storm.config.Configuration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.slf4j.Logger;

public class PathAuthzDBReader {
    private final Logger log = AuthzDirector.getLogger();
    private final String authzDBFilename;
    private PathAuthzDB pathAuthzDB;

    public PathAuthzDBReader(String filename) throws Exception {
        this.log.info("Path Authorization : Inizializating ...");
        if (!this.existsAuthzDBFile(filename)) {
            String configurationPATH = Configuration.getInstance().namespaceConfigPath();
            if (configurationPATH.length() == 0) {
                String userDir = System.getProperty("user.dir");
                this.log.debug("Unable to found the configuration path. Assume: '" + userDir + "'");
                configurationPATH = userDir + File.separator + "etc";
            }
            this.authzDBFilename = configurationPATH + File.separator + filename;
        } else {
            this.authzDBFilename = filename;
        }
        this.log.debug("Loading Path Authz DB : '" + this.authzDBFilename + "'.");
        this.pathAuthzDB = this.loadPathAuthzDB(this.authzDBFilename);
        this.log.info("Path Authz DB ('" + this.pathAuthzDB.getPathAuthzDBID() + "') loaded.");
        this.log.info(this.pathAuthzDB.toString());
    }

    public void refreshPathAuthzDB() throws Exception {
        this.log.debug("<PathAuthzDBReader> Start refreshing.");
        this.pathAuthzDB = this.loadPathAuthzDB(this.authzDBFilename);
        this.log.debug("<PathAuthzDBReader> End refreshing.");
        this.log.info("Path Authz DB ('" + this.pathAuthzDB.getPathAuthzDBID() + "') RE-loaded.");
        this.log.info(this.pathAuthzDB.toString());
    }

    public PathAuthzDB getPathAuthzDB() {
        return this.pathAuthzDB;
    }

    private PathAuthzDB loadPathAuthzDB(String authzDBFilename) throws Exception {
        if (this.existsAuthzDBFile(authzDBFilename)) {
            this.log.debug("Parsing the Path Authz DB ...");
            PathAuthzDB result = this.parsePathAuthzDB(authzDBFilename);
            this.log.info("Loaded a Path Authz DB containing '" + result.getACL().size() + "' path ACE.");
            return result;
        }
        this.log.warn("Unable to get a valid Path Authz DB. Loaded the default one! ");
        return new PathAuthzDB();
    }

    private PathAuthzDB parsePathAuthzDB(String authzDBFilename) throws Exception {
        BufferedReader reader;
        PathAuthzEvaluationAlgorithm algorithm = null;
        LinkedList<PathACE> aces = new LinkedList<PathACE>();
        try {
            reader = new BufferedReader(new FileReader(authzDBFilename));
        }
        catch (FileNotFoundException e) {
            this.log.error("Unable to get a FIleReader on '" + authzDBFilename + "' . FileNotFoundException: " + e);
            throw new Exception("No file available at path '" + authzDBFilename + "' . FileNotFoundException: " + e.getMessage());
        }
        try {
            String str;
            while ((str = reader.readLine()) != null) {
                ParseLineResults parsedLine = this.parseLine(str);
                switch (parsedLine.type) {
                    case COMMENT: {
                        this.log.debug("comment line  : " + parsedLine.getComment());
                        break;
                    }
                    case ALGORITHM_NAME: {
                        if (algorithm != null) {
                            this.log.error("Attention! More than one Algorithm specified in configuration file: '" + parsedLine.getAlgorithmName() + "' , " + algorithm.getClass());
                            throw new Exception("More than one Algorithm specified in configuration file");
                        }
                        try {
                            algorithm = this.buildAlgorithmInstance(parsedLine.getAlgorithmName());
                            this.log.debug("algorithm name: " + parsedLine.getAlgorithmName());
                            break;
                        }
                        catch (Exception e) {
                            this.log.error("Unable to get Algorithm: '" + parsedLine.getAlgorithmName() + "'");
                            throw new Exception("Unable to build a valid Algorithm");
                        }
                    }
                    case PATH_ACE: {
                        aces.add(parsedLine.getPathAce());
                        this.log.debug("path ace      : " + parsedLine.getPathAce());
                        break;
                    }
                    case OTHER: {
                        this.log.debug("something was wrong in '" + str + "'");
                    }
                }
            }
        }
        catch (IOException e) {
            this.log.error("Error while reading Path Authz DB '" + authzDBFilename + "'");
            throw new Exception("Error while reading Path Authz DB. IOException: " + e);
        }
        finally {
            reader.close();
        }
        return new PathAuthzDB(authzDBFilename, algorithm, aces);
    }

    private PathAuthzEvaluationAlgorithm buildAlgorithmInstance(String algorithmName) throws Exception {
        Object authzAlgInstance;
        Method instanceMethod;
        Class<PathAuthzEvaluationAlgorithm> authzAlgClass;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(algorithmName);
        }
        catch (ClassNotFoundException e) {
            this.log.error("Unable to load the Path Authz Algorithm Class '" + algorithmName + "' . ClassNotFoundException: " + e);
            throw new Exception("Unable to load a class with name '" + algorithmName + "'");
        }
        try {
            authzAlgClass = clazz.asSubclass(PathAuthzEvaluationAlgorithm.class);
        }
        catch (ClassCastException e) {
            this.log.error("The loaded class Class '" + algorithmName + "' is not a PathAuthzEvaluationAlgorithm. ClassCastException: " + e);
            throw new Exception("Class '" + algorithmName + "' is not a PathAuthzEvaluationAlgorithm");
        }
        try {
            instanceMethod = authzAlgClass.getMethod("getInstance", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            this.log.error("The loaded class Class '" + algorithmName + "' has not a getInstance method. NoSuchMethodException: " + e);
            throw new Exception("Class '" + algorithmName + "' has not a getInstance method");
        }
        catch (SecurityException e) {
            this.log.error("Unable to get getInstance method. SecurityException: " + e);
            throw new Exception("Unable to get getInstance method");
        }
        if (instanceMethod == null) {
            this.log.error("The retrieved getInstance methos is null");
            throw new Exception("The retrieved getInstance methos is null");
        }
        try {
            authzAlgInstance = instanceMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            this.log.error("Unable to call getInstance method. IllegalAccessException: " + e);
            throw new Exception("Unable to call getInstance method");
        }
        catch (IllegalArgumentException e) {
            this.log.error("Unable to call getInstance method. IllegalArgumentException: " + e);
            throw new Exception("Unable to call getInstance method");
        }
        catch (InvocationTargetException e) {
            this.log.error("Unable to call getInstance method. InvocationTargetException: " + e);
            throw new Exception("Unable to call getInstance method");
        }
        if (authzAlgInstance instanceof PathAuthzEvaluationAlgorithm) {
            this.log.debug("Found a valid Path Authz Evaluation Algorithm. It implements the algorithm : " + ((PathAuthzEvaluationAlgorithm)authzAlgInstance).getDescription());
            return (PathAuthzEvaluationAlgorithm)authzAlgInstance;
        }
        this.log.error("The method  getInstance of class '" + algorithmName + "' does not return a valid Path Authz Evaluation Algorithm object but a '" + authzAlgInstance.getClass() + "'");
        throw new Exception("Unable to get a valid instance of PathAuthzEvaluationAlgorithm");
    }

    private ParseLineResults parseLine(String pathACEString) {
        ParseLineResults result = null;
        if (pathACEString.startsWith("#")) {
            result = new ParseLineResults(LineType.COMMENT);
            result.setComment(pathACEString);
        } else if (pathACEString.startsWith("algorithm")) {
            if (pathACEString.contains("=")) {
                String algName = pathACEString.substring(pathACEString.indexOf("=") + 1);
                result = new ParseLineResults(LineType.ALGORITHM_NAME);
                result.setAlgorithmName(algName.trim());
            }
        } else if (pathACEString.trim().length() == 0) {
            result = new ParseLineResults(LineType.COMMENT);
            result.setComment("");
        } else {
            try {
                PathACE ace = PathACE.buildFromString(pathACEString);
                result = new ParseLineResults(LineType.PATH_ACE);
                result.setPathAce(ace);
            }
            catch (AuthzException e) {
                this.log.error("Something of inexiplicable in the line " + pathACEString);
                this.log.error(" - explanation: " + e.getMessage());
                result = new ParseLineResults(LineType.OTHER);
            }
        }
        return result;
    }

    private boolean existsAuthzDBFile(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            this.log.warn("The AuthzDB File '" + fileName + "' does not exists");
            return false;
        }
        if (!file.isFile()) {
            this.log.warn("The AuthzDB File '" + fileName + "' is a directory");
            return false;
        }
        if (!file.canRead()) {
            this.log.warn("The AuthzDB File '" + fileName + "' cannot be read");
            return false;
        }
        return true;
    }

    private class ParseLineResults {
        private final LineType type;
        private String comment = null;
        private String algorithmName = null;
        private PathACE pathAce = null;

        public ParseLineResults(LineType type) {
            this.type = type;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public void setAlgorithmName(String algName) {
            this.algorithmName = algName;
        }

        public void setPathAce(PathACE ace) {
            this.pathAce = ace;
        }

        public String getComment() {
            return this.comment;
        }

        public String getAlgorithmName() {
            return this.algorithmName;
        }

        public PathACE getPathAce() {
            return this.pathAce;
        }
    }

    private static enum LineType {
        COMMENT,
        ALGORITHM_NAME,
        PATH_ACE,
        OTHER;

    }
}

