/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.authz.path.conf;

import it.grid.storm.authz.AuthzDecision;
import it.grid.storm.authz.path.model.PathACE;
import it.grid.storm.authz.path.model.PathAuthzAlgBestMatch;
import it.grid.storm.authz.path.model.PathAuthzEvaluationAlgorithm;
import it.grid.storm.authz.path.model.PathOperation;
import it.grid.storm.authz.path.model.SRMFileRequest;
import it.grid.storm.common.types.StFN;
import java.util.LinkedList;
import java.util.List;

public class PathAuthzDB {
    public static final String MOCK_ID = "mock-PathAuthzDB";
    private final PathAuthzEvaluationAlgorithm DEFAULT_ALGORITHM = PathAuthzAlgBestMatch.getInstance();
    private final String pathAuthzDBID;
    private final PathAuthzEvaluationAlgorithm evaluationAlg;
    private final LinkedList<PathACE> authzDB = new LinkedList();

    public PathAuthzDB(String pathAuthzDBID, PathAuthzEvaluationAlgorithm algorithm, List<PathACE> aces) {
        this.pathAuthzDBID = pathAuthzDBID;
        this.evaluationAlg = algorithm;
        this.authzDB.addAll(aces);
    }

    public PathAuthzDB(String pathAuthzDBID, List<PathACE> aces) {
        this.pathAuthzDBID = pathAuthzDBID;
        this.evaluationAlg = this.DEFAULT_ALGORITHM;
        this.authzDB.addAll(aces);
    }

    public PathAuthzDB() {
        this.pathAuthzDBID = MOCK_ID;
        this.evaluationAlg = this.DEFAULT_ALGORITHM;
        this.authzDB.add(PathACE.PERMIT_ALL);
    }

    public void addPathACE(PathACE pathAce) {
        this.authzDB.add(pathAce);
    }

    public List<PathACE> getACL() {
        return this.authzDB;
    }

    public String getPathAuthzDBID() {
        return this.pathAuthzDBID;
    }

    public String toString() {
        String result = "=== Path Authorizaton DataBase === \n";
        result = result + "path-authz.db Name: '" + this.pathAuthzDBID + "'\n";
        result = result + "algorithm=" + this.evaluationAlg.getClass() + "\n \n";
        int count = 0;
        for (PathACE ace : this.authzDB) {
            result = result + "ace[" + count + "]: " + ace.toString() + "\n";
            ++count;
        }
        return result;
    }

    public AuthzDecision evaluate(String groupName, StFN fileStFN, SRMFileRequest pathOperation) {
        return this.evaluationAlg.evaluate(groupName, fileStFN, pathOperation, this.authzDB);
    }

    public AuthzDecision evaluate(String groupName, StFN fileStFN, PathOperation pathOperation) {
        return this.evaluationAlg.evaluate(groupName, fileStFN, pathOperation, this.authzDB);
    }

    public AuthzDecision evaluateAnonymous(StFN fileStFN, PathOperation pathOperation) {
        return this.evaluationAlg.evaluateAnonymous(fileStFN, pathOperation, this.authzDB);
    }

    public AuthzDecision evaluateAnonymous(StFN fileStFN, SRMFileRequest pathOperation) {
        return this.evaluationAlg.evaluateAnonymous(fileStFN, pathOperation, this.authzDB);
    }
}

