/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.authz;

import it.grid.storm.authz.DirectorException;
import it.grid.storm.authz.PathAuthzInterface;
import it.grid.storm.authz.SpaceAuthzInterface;
import it.grid.storm.authz.path.PathAuthz;
import it.grid.storm.authz.path.conf.PathAuthzDBReader;
import it.grid.storm.authz.sa.SpaceDBAuthz;
import it.grid.storm.authz.sa.test.MockSpaceAuthz;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceException;
import it.grid.storm.namespace.NamespaceInterface;
import it.grid.storm.namespace.VirtualFSInterface;
import it.grid.storm.namespace.model.SAAuthzType;
import it.grid.storm.srm.types.TSpaceToken;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthzDirector {
    private static final Logger log = LoggerFactory.getLogger(AuthzDirector.class);
    private static int refreshInSeconds = 5;
    private static String configurationPATH;
    private static String stormPropertiesFileName;
    private static Map<TSpaceToken, SpaceAuthzInterface> spaceAuthzs;
    private static PathAuthzInterface pathAuthz;

    private static Map<TSpaceToken, SpaceAuthzInterface> buildSpaceAuthzsMAP() {
        HashMap<TSpaceToken, SpaceAuthzInterface> spaceAuthzMap = new HashMap<TSpaceToken, SpaceAuthzInterface>();
        NamespaceInterface ns = NamespaceDirector.getNamespace();
        try {
            ArrayList<VirtualFSInterface> vfss = new ArrayList<VirtualFSInterface>(ns.getAllDefinedVFS());
            for (VirtualFSInterface vfs : vfss) {
                String vfsName = vfs.getAliasName();
                SAAuthzType authzTp = vfs.getStorageAreaAuthzType();
                String authzName = "";
                if (authzTp.equals(SAAuthzType.AUTHZDB)) {
                    authzName = vfs.getStorageAreaAuthzDB();
                    log.debug("Loading AuthzDB '" + authzName + "'");
                    if (AuthzDirector.existsAuthzDBFile(authzName)) {
                        TSpaceToken spaceToken = vfs.getSpaceToken();
                        SpaceDBAuthz spaceAuthz = new SpaceDBAuthz(authzName);
                        spaceAuthzMap.put(spaceToken, spaceAuthz);
                    } else {
                        log.error("File AuthzDB '" + authzName + "' related to '" + vfsName + "' does not exists.");
                    }
                } else {
                    authzName = vfs.getStorageAreaAuthzFixed();
                }
                log.debug("VFS ['" + vfsName + "'] = " + authzTp + " : " + authzName);
            }
        }
        catch (NamespaceException e) {
            log.warn("Unable to initialize AUTHZ DB!" + e.getMessage());
            log.warn(".. (Workaround): AuthzDirector INITIALIZATED evenly..");
        }
        return spaceAuthzMap;
    }

    private static boolean existsAuthzDBFile(String dbFileName) {
        String fileName = configurationPATH + File.separator + dbFileName;
        boolean exists = new File(fileName).exists();
        if (!exists) {
            log.warn("The AuthzDB File '" + dbFileName + "' does not exists");
        }
        return exists;
    }

    public static Logger getLogger() {
        return log;
    }

    public static void initializeSpaceAuthz() {
        spaceAuthzs = AuthzDirector.buildSpaceAuthzsMAP();
    }

    public static SpaceAuthzInterface getSpaceAuthz(TSpaceToken token) {
        SpaceAuthzInterface spaceAuthz = new MockSpaceAuthz();
        if (spaceAuthzs != null && spaceAuthzs.containsKey(token)) {
            spaceAuthz = spaceAuthzs.get(token);
            log.debug("Space Authz related to S.Token ='" + token + "' is '" + spaceAuthz.getSpaceAuthzID() + "'");
        } else {
            log.debug("Space Authz related to S.Token ='" + token + "' does not exists. Use the MOCK one.");
        }
        return spaceAuthz;
    }

    public static void initializePathAuthz(String pathAuthzDBFileName) throws DirectorException {
        PathAuthzDBReader authzDBReader;
        try {
            authzDBReader = new PathAuthzDBReader(pathAuthzDBFileName);
        }
        catch (Exception e) {
            log.error("Unable to build a PathAuthzDBReader : " + e);
            throw new DirectorException("Unable to build a PathAuthzDBReader");
        }
        pathAuthz = new PathAuthz(authzDBReader.getPathAuthzDB());
    }

    public static PathAuthzInterface getPathAuthz() {
        return pathAuthz;
    }

    static {
        spaceAuthzs = null;
        pathAuthz = null;
    }
}

