/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.asynch;

import it.grid.storm.asynch.WSConversionException;
import it.grid.storm.srm.types.InvalidTTURLAttributesException;
import it.grid.storm.srm.types.TTURL;
import org.apache.axis.types.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSTurlConverter {
    private static Logger log = LoggerFactory.getLogger(WSTurlConverter.class);

    public TTURL fromWS(URI auxURI) throws WSConversionException {
        try {
            if (auxURI == null) {
                return TTURL.makeEmpty();
            }
            String auxString = auxURI.toString();
            if (auxString == null || auxString.equals("")) {
                return TTURL.makeEmpty();
            }
            return TTURL.makeFromString(auxString);
        }
        catch (InvalidTTURLAttributesException e) {
            log.debug("Unexpected error in WSTurlConverter! This is a programming bug! Could not translate TTURL from WS! " + e);
            throw new WSConversionException(e.toString());
        }
    }
}

