/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.asynch;

import it.grid.storm.asynch.InvalidPutDoneReplyAttributeException;
import it.grid.storm.asynch.InvalidPutReplyAttributeException;
import it.grid.storm.asynch.InvalidPutStatusAttributesException;
import it.grid.storm.asynch.SRMClient;
import it.grid.storm.asynch.SRMClientException;
import it.grid.storm.asynch.SRMPrepareToPutReply;
import it.grid.storm.asynch.SRMPutDoneReply;
import it.grid.storm.asynch.SRMStatusOfPutRequestReply;
import it.grid.storm.asynch.WSConversionException;
import it.grid.storm.asynch.WSFileStorageTypeConverter;
import it.grid.storm.asynch.WSOverwriteModeConverter;
import it.grid.storm.asynch.WSRequestTokenConverter;
import it.grid.storm.asynch.WSReturnStatusConverter;
import it.grid.storm.asynch.WSTurlConverter;
import it.grid.storm.common.types.EndPoint;
import it.grid.storm.common.types.Port;
import it.grid.storm.common.types.TransferProtocol;
import it.grid.storm.config.Configuration;
import it.grid.storm.griduser.AbstractGridUser;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.srm.types.InvalidTUserIDAttributeException;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TOverwriteMode;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.srm.types.TTURL;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.Stub;
import javax.xml.rpc.soap.SOAPFaultException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.transport.http.HTTPSender;
import org.apache.axis.types.URI;
import org.apache.axis.types.UnsignedLong;
import org.globus.axis.transport.GSIHTTPSender;
import org.globus.axis.util.Util;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.auth.HostAuthorization;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import srmClientStubs.ArrayOfAnyURI;
import srmClientStubs.ArrayOfString;
import srmClientStubs.ArrayOfTPutFileRequest;
import srmClientStubs.ArrayOfTPutRequestFileStatus;
import srmClientStubs.ArrayOfTSURLReturnStatus;
import srmClientStubs.ISRM;
import srmClientStubs.SRMServiceLocator;
import srmClientStubs.SrmPrepareToPutRequest;
import srmClientStubs.SrmPrepareToPutResponse;
import srmClientStubs.SrmPutDoneRequest;
import srmClientStubs.SrmPutDoneResponse;
import srmClientStubs.SrmStatusOfPutRequestRequest;
import srmClientStubs.SrmStatusOfPutRequestResponse;
import srmClientStubs.TFileStorageType;
import srmClientStubs.TPutFileRequest;
import srmClientStubs.TPutRequestFileStatus;
import srmClientStubs.TReturnStatus;
import srmClientStubs.TSURLReturnStatus;
import srmClientStubs.TTransferParameters;

public class SRM22Client
implements SRMClient {
    private static Logger log = LoggerFactory.getLogger(SRM22Client.class);

    @Override
    public SRMPrepareToPutReply prepareToPut(GridUserInterface gu, TSURL toSURL, TLifeTimeInSeconds lifetime, it.grid.storm.srm.types.TFileStorageType fileStorageType, TSpaceToken spaceToken, TSizeInBytes filesize, TransferProtocol protocol, String description, TOverwriteMode overwriteOption, TLifeTimeInSeconds retryTime) throws SRMClientException {
        try {
            ISRM _srm = this.setUpGSI(gu, toSURL);
            SrmPrepareToPutRequest req = new SrmPrepareToPutRequest();
            log.debug("NAIVE SRM CLIENT; setting description to: " + description);
            req.setUserRequestDescription(description);
            String[] protocolArray = new String[]{protocol.toString()};
            log.debug("NAIVE SRM CLIENT; setting protocol array to: " + protocolArray);
            ArrayOfString protocolArrayString = new ArrayOfString();
            protocolArrayString.setStringArray(protocolArray);
            TTransferParameters stubtp = new TTransferParameters();
            stubtp.setArrayOfTransferProtocols(protocolArrayString);
            req.setTransferParameters(stubtp);
            log.debug("NAIVE SRM CLIENT; setting overwrite option to: " + overwriteOption);
            req.setOverwriteOption(new WSOverwriteModeConverter().fromStoRM(overwriteOption));
            Integer dtrt = new Integer(new Long(retryTime.value()).intValue());
            log.debug("NAIVE SRM CLIENT; setting desired total request time: " + dtrt);
            req.setDesiredTotalRequestTime(dtrt);
            TFileStorageType stubfst = new WSFileStorageTypeConverter().fromStoRM(fileStorageType);
            log.debug("NAIVE SRM CLIENT; setting file storage type to: " + fileStorageType);
            req.setDesiredFileStorageType(stubfst);
            if (!spaceToken.isEmpty()) {
                String st = spaceToken.toString();
                log.debug("NAIVE SRM CLIENT; setting space token to: " + st);
                req.setTargetSpaceToken(st);
            } else {
                log.debug("NAIVE SRM CLIENT; setting space token to null. ");
            }
            Integer dflt = new Integer(new Long(lifetime.value()).intValue());
            log.debug("NAIVE SRM CLIENT; setting desired file life time to: " + dflt);
            req.setDesiredFileLifeTime(dflt);
            Integer dplt = new Integer(Configuration.getInstance().getSRM22ClientPinLifeTime());
            log.debug("NAIVE SRM CLIENT; setting desired pin life time to: " + dplt);
            req.setDesiredPinLifeTime(dplt);
            TPutFileRequest stubpfr = new TPutFileRequest();
            long efs = filesize.value();
            log.debug("NAIVE SRM CLIENT; setting expected file size to: " + efs);
            UnsignedLong ulFileSize = new UnsignedLong(efs);
            stubpfr.setExpectedFileSize(ulFileSize);
            String ts = toSURL.toString();
            log.debug("NAIVE SRM CLIENT; setting target SURL to: " + ts);
            stubpfr.setTargetSURL(new URI(ts));
            TPutFileRequest[] stubpfrArray = new TPutFileRequest[]{stubpfr};
            ArrayOfTPutFileRequest arrayOfPut = new ArrayOfTPutFileRequest(stubpfrArray);
            req.setArrayOfFileRequests(arrayOfPut);
            log.debug("NAIVE SRM CLIENT: sending request " + arrayOfPut);
            SrmPrepareToPutResponse response = _srm.srmPrepareToPut(req);
            log.debug("NAIVE SRM CLIENT: received reply " + response);
            if (response == null) {
                throw new SRMClientException("Unexpected reply from WebService: got a null response!");
            }
            TReturnStatus overallRetStat = response.getReturnStatus();
            if (overallRetStat == null) {
                throw new SRMClientException("Unexpected reply from WebService: null request level TReturnStatus!");
            }
            TStatusCode overallStat = WSReturnStatusConverter.getInstance().fromWS(overallRetStat).getStatusCode();
            if (overallStat != TStatusCode.SRM_REQUEST_QUEUED && overallStat != TStatusCode.SRM_REQUEST_INPROGRESS && overallStat != TStatusCode.SRM_SUCCESS && overallStat != TStatusCode.SRM_PARTIAL_SUCCESS) {
                throw new SRMClientException("srmPrepareToPut on remote machine failed! Request level return status: " + (Object)((Object)overallStat) + ", explanation: " + overallRetStat.getExplanation());
            }
            String reqTokenString = response.getRequestToken();
            if (reqTokenString == null) {
                throw new SRMClientException("Unexpected reply from WebService: null TReqeustToken!");
            }
            TRequestToken requestToken = new WSRequestTokenConverter().fromWS(reqTokenString);
            return new SRMPrepareToPutReply(requestToken);
        }
        catch (SRMClientException e) {
            throw e;
        }
        catch (InvalidTUserIDAttributeException e) {
            throw new SRMClientException("Unexpected error in NaiveSRMClient! Cannot get gredentials from GridUser! " + e);
        }
        catch (GlobusCredentialException e) {
            throw new SRMClientException("Unexpected error in NaiveSRMClient! Cannot create GlobusCredentials from GridUser! " + (Object)((Object)e));
        }
        catch (GSSException e) {
            throw new SRMClientException("Unexpected error in NaiveSRMClient! Cannot create GSSCredentials from GlobusCredential! " + e);
        }
        catch (URI.MalformedURIException ex) {
            throw new SRMClientException("Unexpected error in NaiveSRMClient! Cannot create URI! " + (Object)((Object)ex));
        }
        catch (ServiceException ex) {
            throw new SRMClientException("Web Service problem! " + (Object)((Object)ex));
        }
        catch (RemoteException ex) {
            throw new SRMClientException("Web Service Communication problem! " + ex);
        }
        catch (SOAPFaultException e) {
            throw new SRMClientException("The remote web service launched an exception! " + (Object)((Object)e));
        }
        catch (WSConversionException e) {
            throw new SRMClientException("There were problems translating between WebService and StoRM object model! " + e);
        }
        catch (InvalidPutReplyAttributeException e) {
            throw new SRMClientException("Unexpected error in NaiveSRMClient! Cannot create a reply to return! " + e);
        }
        catch (Exception e) {
            throw new SRMClientException("Unexpected runtime error in NaiveSRMClient! " + e);
        }
    }

    @Override
    public SRMStatusOfPutRequestReply statusOfPutRequest(TRequestToken rt, GridUserInterface gu, TSURL toSURL) throws SRMClientException {
        try {
            ISRM _srm = this.setUpGSI(gu, toSURL);
            SrmStatusOfPutRequestRequest req = new SrmStatusOfPutRequestRequest();
            req.setRequestToken(rt.toString());
            URI stubSurl = new URI(toSURL.toString());
            URI[] stubSurlArray = new URI[]{stubSurl};
            ArrayOfAnyURI arrayOfTSURL = new ArrayOfAnyURI(stubSurlArray);
            req.setArrayOfTargetSURLs(arrayOfTSURL);
            log.debug("NAIVE SRM CLIENT: invoking status of put with " + req);
            SrmStatusOfPutRequestResponse response = _srm.srmStatusOfPutRequest(req);
            log.debug("NAIVE SRM CLIENT: received response " + response);
            if (response == null) {
                throw new SRMClientException("Unexpected reply from WebService: got a null response!");
            }
            TReturnStatus overallRetStat = response.getReturnStatus();
            if (overallRetStat == null) {
                throw new SRMClientException("Unexpected reply from WebService: null request level TReturnStatus!");
            }
            TStatusCode overallStat = WSReturnStatusConverter.getInstance().fromWS(overallRetStat).getStatusCode();
            if (overallStat != TStatusCode.SRM_REQUEST_QUEUED && overallStat != TStatusCode.SRM_REQUEST_INPROGRESS && overallStat != TStatusCode.SRM_SUCCESS && overallStat != TStatusCode.SRM_PARTIAL_SUCCESS) {
                return new SRMStatusOfPutRequestReply(TTURL.makeEmpty(), WSReturnStatusConverter.getInstance().fromWS(overallRetStat));
            }
            ArrayOfTPutRequestFileStatus arrayOfPutStatuses = response.getArrayOfFileStatuses();
            if (arrayOfPutStatuses == null) {
                throw new SRMClientException("Unexpected reply from WebService: null ArrayOfTPutRequestFileStatus!");
            }
            TPutRequestFileStatus[] stubFileStatusArray = arrayOfPutStatuses.getStatusArray();
            if (stubFileStatusArray == null || stubFileStatusArray.length == 0) {
                throw new SRMClientException("Unexpected reply from WebService: null or empty StatusArray! ");
            }
            TPutRequestFileStatus stubFileStatus = stubFileStatusArray[0];
            if (stubFileStatus == null) {
                throw new SRMClientException("Unexpected reply from WebService: null first entry of StatusArray! ");
            }
            URI stubTurl = stubFileStatus.getTransferURL();
            TReturnStatus stubStatus = stubFileStatus.getStatus();
            TTURL turl = new WSTurlConverter().fromWS(stubTurl);
            it.grid.storm.srm.types.TReturnStatus retStat = WSReturnStatusConverter.getInstance().fromWS(stubStatus);
            return new SRMStatusOfPutRequestReply(turl, retStat);
        }
        catch (SRMClientException e) {
            throw e;
        }
        catch (InvalidTUserIDAttributeException e) {
            throw new SRMClientException("Unexpected error in NaiveSRMClient! Cannot get gredentials from GridUser! " + e);
        }
        catch (GlobusCredentialException e) {
            throw new SRMClientException("Unexpected error in NaiveSRMClient! Cannot create GlobusCredentials from GridUser! " + (Object)((Object)e));
        }
        catch (GSSException e) {
            throw new SRMClientException("Unexpected error in NaiveSRMClient! Cannot create GSSCredentials from GlobusCredential! " + e);
        }
        catch (URI.MalformedURIException ex) {
            throw new SRMClientException("Unexpected error in NaiveSRMClient! Cannot create URI! " + (Object)((Object)ex));
        }
        catch (ServiceException ex) {
            throw new SRMClientException("Web Service problem! " + (Object)((Object)ex));
        }
        catch (RemoteException ex) {
            throw new SRMClientException("Communication problem! " + ex);
        }
        catch (SOAPFaultException e) {
            throw new SRMClientException("The remote web service launched an exception! " + (Object)((Object)e));
        }
        catch (WSConversionException e) {
            throw new SRMClientException("The answer received from the WebService cannot be converted to StoRM object model! " + e);
        }
        catch (InvalidPutStatusAttributesException e) {
            throw new SRMClientException("Unexpected error in NaiveSRMClient! Cannot create a reply to return! " + e);
        }
        catch (Exception e) {
            throw new SRMClientException("Unexpected runtime error in NaiveSRMClient! " + e);
        }
    }

    @Override
    public SRMPutDoneReply srmPutDone(TRequestToken rt, GridUserInterface gu, TSURL toSURL) throws SRMClientException {
        try {
            ISRM _srm = this.setUpGSI(gu, toSURL);
            SrmPutDoneRequest req = new SrmPutDoneRequest();
            req.setRequestToken(rt.toString());
            URI stubSurl = new URI(toSURL.toString());
            URI[] stubSurlArray = new URI[]{stubSurl};
            ArrayOfAnyURI arrayOfTSURL = new ArrayOfAnyURI(stubSurlArray);
            req.setArrayOfSURLs(arrayOfTSURL);
            log.debug("NAIVE SRM CLIENT: invoking srmPutDone with " + req);
            SrmPutDoneResponse response = _srm.srmPutDone(req);
            log.debug("NAIVE SRM CLIENT: received response " + response);
            if (response == null) {
                throw new SRMClientException("Unexpected reply from WebService: got a null response!");
            }
            TReturnStatus overallRetStat = response.getReturnStatus();
            if (overallRetStat == null) {
                throw new SRMClientException("Unexpected reply from WebService: null request level TReturnStatus!");
            }
            TStatusCode overallStat = WSReturnStatusConverter.getInstance().fromWS(overallRetStat).getStatusCode();
            if (overallStat != TStatusCode.SRM_SUCCESS && overallStat != TStatusCode.SRM_PARTIAL_SUCCESS) {
                return new SRMPutDoneReply(WSReturnStatusConverter.getInstance().fromWS(overallRetStat));
            }
            ArrayOfTSURLReturnStatus arrayOfFileStatuses = response.getArrayOfFileStatuses();
            if (arrayOfFileStatuses == null) {
                return new SRMPutDoneReply(WSReturnStatusConverter.getInstance().fromWS(overallRetStat));
            }
            TSURLReturnStatus[] stubFileStatusArray = arrayOfFileStatuses.getStatusArray();
            if (stubFileStatusArray == null || stubFileStatusArray.length == 0) {
                return new SRMPutDoneReply(WSReturnStatusConverter.getInstance().fromWS(overallRetStat));
            }
            TSURLReturnStatus stubFileStatus = stubFileStatusArray[0];
            if (stubFileStatus == null) {
                throw new SRMClientException("Unexpected reply from WebService: null first entry of StatusArray! ");
            }
            TReturnStatus stubStatus = stubFileStatus.getStatus();
            it.grid.storm.srm.types.TReturnStatus retStat = WSReturnStatusConverter.getInstance().fromWS(stubStatus);
            return new SRMPutDoneReply(retStat);
        }
        catch (SRMClientException e) {
            throw e;
        }
        catch (InvalidTUserIDAttributeException e) {
            throw new SRMClientException("Unexpected error in NaiveSRMClient! Cannot get gredentials from GridUser! " + e);
        }
        catch (GlobusCredentialException e) {
            throw new SRMClientException("Unexpected error in NaiveSRMClient! Cannot create GlobusCredentials from GridUser! " + (Object)((Object)e));
        }
        catch (GSSException e) {
            throw new SRMClientException("Unexpected error in NaiveSRMClient! Cannot create GSSCredentials from GlobusCredential! " + e);
        }
        catch (URI.MalformedURIException ex) {
            throw new SRMClientException("Unexpected error in NaiveSRMClient! Cannot create URI! " + (Object)((Object)ex));
        }
        catch (ServiceException ex) {
            throw new SRMClientException("Web Service problem! " + (Object)((Object)ex));
        }
        catch (RemoteException ex) {
            throw new SRMClientException("Communication problem! " + ex);
        }
        catch (SOAPFaultException e) {
            throw new SRMClientException("The remote web service launched an exception! " + (Object)((Object)e));
        }
        catch (WSConversionException e) {
            throw new SRMClientException("The answer received from the WebService cannot be converted to StoRM object model! " + e);
        }
        catch (InvalidPutDoneReplyAttributeException e) {
            throw new SRMClientException("Unexpected error in NaiveSRMClient! Cannot create a reply to return! " + e);
        }
        catch (Exception e) {
            throw new SRMClientException("Unexpected runtime error in NaiveSRMClient! " + e);
        }
    }

    private ISRM setUpGSI(GridUserInterface gu, TSURL toSURL) throws ServiceException, GlobusCredentialException, GSSException, InvalidTUserIDAttributeException {
        Util.registerTransport();
        SimpleProvider provider = new SimpleProvider();
        SimpleTargetedChain c = null;
        c = new SimpleTargetedChain((Handler)new GSIHTTPSender());
        provider.deployTransport("httpg", (Handler)c);
        c = new SimpleTargetedChain((Handler)new HTTPSender());
        provider.deployTransport("http", (Handler)c);
        SRMServiceLocator sRMService = new SRMServiceLocator((EngineConfiguration)provider);
        ISRM _srm = sRMService.getsrm();
        if (((AbstractGridUser)gu).getUserCredentials() == null) {
            log.error("ERROR in NaiveSRMClient! No proxy present for " + gu.getDn());
        }
        ByteArrayInputStream proxy = new ByteArrayInputStream(((AbstractGridUser)gu).getUserCredentials().getBytes());
        GlobusGSSCredentialImpl globusProxy = new GlobusGSSCredentialImpl(new GlobusCredential((InputStream)proxy), 0);
        ((Stub)_srm)._setProperty("org.globus.gsi.credentials", (Object)globusProxy);
        ((Stub)_srm)._setProperty("org.globus.gsi.authorization", (Object)HostAuthorization.getInstance());
        ((Stub)_srm)._setProperty("org.globus.gsi.mode", (Object)"gsifull");
        EndPoint ep = toSURL.sfn().endPoint();
        String epString = "";
        epString = ep.isEmpty() ? "/" : ep.toString();
        Port port = toSURL.sfn().port();
        String portString = "";
        if (!port.isEmpty()) {
            portString = ":" + port.toString();
        }
        String sea = "httpg://" + toSURL.sfn().machine() + portString + epString;
        ((Stub)_srm)._setProperty("javax.xml.rpc.service.endpoint.address", (Object)sea);
        return _srm;
    }
}

