/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.asynch;

import it.grid.storm.asynch.Copy;
import it.grid.storm.asynch.CopyVisitor;
import it.grid.storm.asynch.GridFTPTransferClient;
import it.grid.storm.asynch.GridFTPTransferClientException;
import it.grid.storm.asynch.GridFTPTransferClientFactory;
import it.grid.storm.asynch.NoGridFTPTransferClientFoundException;
import it.grid.storm.asynch.NoSRMClientFoundException;
import it.grid.storm.asynch.SRMClient;
import it.grid.storm.asynch.SRMClientException;
import it.grid.storm.asynch.SRMClientFactory;
import it.grid.storm.asynch.SRMPutDoneReply;
import it.grid.storm.asynch.VisitableCopy;
import it.grid.storm.config.Configuration;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.srm.types.TTURL;
import java.util.ArrayList;
import java.util.Date;

public class PushCopyTransferVisitor
implements CopyVisitor {
    private final Copy.GetOperationResult get;
    private final Copy.PutOperationResult put;

    private PushCopyTransferVisitor() {
        this.get = null;
        this.put = null;
    }

    public PushCopyTransferVisitor(Copy.GetOperationResult get, Copy.PutOperationResult put) {
        this.get = get;
        this.put = put;
    }

    @Override
    public Copy.Result visit(VisitableCopy copy) {
        try {
            TTURL getTURL = this.get.getTURL();
            TTURL putTURL = this.put.putTURL();
            GridFTPTransferClient gridFTPTransferClient = GridFTPTransferClientFactory.getInstance().client();
            gridFTPTransferClient.putFile(copy.getGu(), getTURL, putTURL);
            copy.getLog().debug("PUSH COPY CHUNK - executeTransfer: getting SRM client...");
            SRMClient srmClient = SRMClientFactory.getInstance().client();
            copy.getLog().debug("... got it!");
            long timeOut = new Date().getTime() + Configuration.getInstance().getSRMClientPutDoneTimeOut() * 1000L;
            long sleepTime = Configuration.getInstance().getSRMClientPutDoneSleepTime() * 1000L;
            boolean timedOut = false;
            SRMPutDoneReply reply = null;
            TStatusCode replyCode = null;
            try {
                do {
                    copy.getLog().debug("PUSH COPY CHUNK - executeTransfer: Going to sleep...");
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    copy.getLog().debug("PUSH COPY CHUNK - executeTransfer: Waking up and invoking srmPutDone...");
                    reply = srmClient.srmPutDone(this.put.requestToken(), copy.getGu(), copy.getRequestData().getDestinationSURL());
                    replyCode = reply.overallRetStat().getStatusCode();
                    timedOut = new Date().getTime() > timeOut;
                    copy.getLog().debug("PUSH COPY CHUNK: reply was " + reply + "; the reply code was: " + (Object)((Object)replyCode) + "; timedOut is:" + timedOut);
                } while (replyCode == TStatusCode.SRM_INTERNAL_ERROR && !timedOut);
            }
            catch (SRMClientException e2) {
                copy.getLog().error("File transfer completed successfully, but problems were encountered performing final srmPutDone! " + e2);
                StringBuffer sb = new StringBuffer();
                sb.append("Parameters passed to client: ");
                sb.append(", ");
                sb.append("GridUser: ");
                sb.append(copy.getGu().toString());
                sb.append(", ");
                sb.append("toSURL: ");
                sb.append(copy.getRequestData().getDestinationSURL().toString());
                sb.append(".");
                copy.getLog().debug(sb.toString());
                return copy.buildOperationResult("File transfer completed successfully, but problems were encountered performing final srmPutDone! " + e2, Copy.ResultType.TRANSFER);
            }
            if (timedOut) {
                copy.getLog().warn("File transfer completed successfully, but there was a timeout waiting for srmPutDone to return a status different from SRM_INTERNAL_ERROR!");
                return copy.buildOperationResult("File transfer completed successfully, but there was a timeout waiting for srmPutDone to return a status different from SRM_INTERNAL_ERROR!", Copy.ResultType.TRANSFER);
            }
            return copy.buildOperationResult(new ArrayList<Object>(0), Copy.ResultType.TRANSFER);
        }
        catch (NoSRMClientFoundException e) {
            copy.getLog().error("ERROR IN PushCopyChunk! TransferOperation could not invoke srmPutDone on remote SRM server because no SRM client could be loaded! " + e);
            return copy.buildOperationResult("TransferOperation could not invoke srmPutDone on remote SRM server because no SRM client could be loaded!", Copy.ResultType.TRANSFER);
        }
        catch (GridFTPTransferClientException e) {
            copy.getLog().error("ERROR IN PushCopyChunk! File transfer failed! " + e);
            return copy.buildOperationResult(e.toString(), Copy.ResultType.TRANSFER);
        }
        catch (NoGridFTPTransferClientFoundException e) {
            copy.getLog().error("ERROR IN PushCopyChunk! Cannot transfer file because no transfer client could be loaded! " + e);
            return copy.buildOperationResult("Cannot transfer file because no transfer client could be loaded!", Copy.ResultType.TRANSFER);
        }
    }
}

