/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.asynch;

import it.grid.storm.asynch.GlobalStatusManager;
import it.grid.storm.asynch.InvalidOverallRequestAttributeException;
import it.grid.storm.asynch.InvalidPtPFeederAttributesException;
import it.grid.storm.asynch.InvalidRequestAttributesException;
import it.grid.storm.asynch.PtPPersistentChunk;
import it.grid.storm.asynch.SchedulerFacade;
import it.grid.storm.catalogs.PtPChunkCatalog;
import it.grid.storm.catalogs.PtPPersistentChunkData;
import it.grid.storm.catalogs.RequestSummaryCatalog;
import it.grid.storm.catalogs.RequestSummaryData;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.scheduler.Delegable;
import it.grid.storm.scheduler.SchedulerException;
import it.grid.storm.srm.types.TSURL;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PtPFeeder
implements Delegable {
    private static Logger log = LoggerFactory.getLogger(PtPFeeder.class);
    private RequestSummaryData rsd = null;
    private GridUserInterface gu = null;
    private GlobalStatusManager gsm = null;

    public PtPFeeder(RequestSummaryData rsd) throws InvalidPtPFeederAttributesException {
        if (rsd == null) {
            throw new InvalidPtPFeederAttributesException(null, null, null);
        }
        if (rsd.gridUser() == null) {
            throw new InvalidPtPFeederAttributesException(rsd, null, null);
        }
        try {
            this.gu = rsd.gridUser();
            this.rsd = rsd;
            this.gsm = new GlobalStatusManager(rsd.requestToken());
        }
        catch (InvalidOverallRequestAttributeException e) {
            log.error("ATTENTION in PtPFeeder! Programming bug when creating GlobalStatusManager! " + e);
            throw new InvalidPtPFeederAttributesException(rsd, this.gu, null);
        }
    }

    @Override
    public void doIt() {
        log.debug("PtPFeeder: pre-processing " + this.rsd.requestToken());
        Collection<PtPPersistentChunkData> chunks = PtPChunkCatalog.getInstance().lookup(this.rsd.requestToken());
        if (chunks.isEmpty()) {
            log.warn("ATTENTION in PtPFeeder! This SRM put request contained nothing to process! " + this.rsd.requestToken());
            RequestSummaryCatalog.getInstance().failRequest(this.rsd, "This SRM put request contained nothing to process!");
        } else {
            this.manageChunks(chunks);
            log.debug("PtPFeeder: finished pre-processing " + this.rsd.requestToken());
        }
    }

    private void manageChunks(Collection<PtPPersistentChunkData> chunksData) {
        log.debug("PtPFeeder: number of chunks in request " + chunksData.size());
        for (PtPPersistentChunkData chunkData : chunksData) {
            this.gsm.addChunk(chunkData);
            if (TSURL.isValid(chunkData.getSURL())) {
                this.manage(chunkData);
                continue;
            }
            log.warn("PtPFeeder: srmPtP contract violation! toSURL does not refer to this machine!");
            log.warn("Request: " + this.rsd.requestToken());
            log.warn("Chunk: " + chunkData);
            chunkData.changeStatusSRM_FAILURE("SRM protocol violation! Cannot do an srmPtP of a SURL that is not local!");
            PtPChunkCatalog.getInstance().update(chunkData);
            this.gsm.failedChunk(chunkData);
        }
        this.gsm.finishedAdding();
    }

    private void manage(PtPPersistentChunkData auxChunkData) {
        log.debug("PtPFeeder - scheduling... ");
        try {
            auxChunkData.changeStatusSRM_REQUEST_INPROGRESS("srmPrepareToPut chunk is being processed!");
            PtPChunkCatalog.getInstance().update(auxChunkData);
            SchedulerFacade.getInstance().chunkScheduler().schedule(new PtPPersistentChunk(this.rsd, auxChunkData, this.gsm));
            log.debug("PtPFeeder - chunk scheduled.");
        }
        catch (IllegalArgumentException e) {
            log.error("Unable to schedule the chunk. IllegalArgumentException: " + e);
            auxChunkData.changeStatusSRM_FAILURE("StoRM internal error does not allow this chunk to be processed!");
            PtPChunkCatalog.getInstance().update(auxChunkData);
            this.gsm.failedChunk(auxChunkData);
        }
        catch (InvalidRequestAttributesException e) {
            log.error("UNEXPECTED ERROR in PtPFeeder! Chunk could not be created!\n" + e);
            auxChunkData.changeStatusSRM_FAILURE("StoRM internal error does not allow this chunk to be processed!");
            PtPChunkCatalog.getInstance().update(auxChunkData);
            this.gsm.failedChunk(auxChunkData);
        }
        catch (SchedulerException e) {
            log.error("UNEXPECTED ERROR in ChunkScheduler! Chunk could not be scheduled!\n" + e);
            auxChunkData.changeStatusSRM_FAILURE("StoRM internal scheduler error prevented this chunk from being processed!");
            PtPChunkCatalog.getInstance().update(auxChunkData);
            this.gsm.failedChunk(auxChunkData);
        }
    }

    @Override
    public String getName() {
        return "PtPFeeder of request: " + this.rsd.requestToken();
    }
}

