/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.asynch;

import it.grid.storm.asynch.BuilderException;
import it.grid.storm.asynch.InvalidRequestAttributesException;
import it.grid.storm.asynch.PtP;
import it.grid.storm.catalogs.AnonymousPtPData;
import it.grid.storm.catalogs.IdentityPtPData;
import it.grid.storm.catalogs.InvalidFileTransferDataAttributesException;
import it.grid.storm.catalogs.InvalidPtPDataAttributesException;
import it.grid.storm.catalogs.InvalidSurlRequestDataAttributesException;
import it.grid.storm.common.types.TURLPrefix;
import it.grid.storm.config.Configuration;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.TFileStorageType;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TOverwriteMode;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.srm.types.TTURL;
import it.grid.storm.synchcall.data.IdentityInputData;
import it.grid.storm.synchcall.data.datatransfer.PrepareToPutInputData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtPBuilder {
    private static Logger log = LoggerFactory.getLogger(PtPBuilder.class);

    public static PtP build(PrepareToPutInputData inputData) throws BuilderException {
        AnonymousPtPData data;
        TReturnStatus status;
        TSURL toSURL = inputData.getSurl();
        TLifeTimeInSeconds pinLifetime = inputData.getDesiredPinLifetime();
        TLifeTimeInSeconds fileLifetime = inputData.getDesiredFileLifetime();
        TFileStorageType fileStorageType = TFileStorageType.getTFileStorageType(Configuration.getInstance().getDefaultFileStorageType());
        TSpaceToken spaceToken = inputData.getTargetSpaceToken();
        TSizeInBytes expectedFileSize = inputData.getFileSize();
        TURLPrefix transferProtocols = inputData.getTransferProtocols();
        TOverwriteMode overwriteOption = TOverwriteMode.ALWAYS;
        try {
            status = new TReturnStatus(TStatusCode.SRM_REQUEST_QUEUED, "Synchronous request created");
        }
        catch (InvalidTReturnStatusAttributeException e) {
            log.error("Unable to build TReturnStatus. InvalidTReturnStatusAttributeException: " + e.getMessage());
            throw new BuilderException("Error building PtP TReturnStatus. Building failed");
        }
        TTURL transferURL = TTURL.makeEmpty();
        try {
            data = inputData instanceof IdentityInputData ? new IdentityPtPData(((IdentityInputData)((Object)inputData)).getUser(), toSURL, pinLifetime, fileLifetime, fileStorageType, spaceToken, expectedFileSize, transferProtocols, overwriteOption, status, transferURL) : new AnonymousPtPData(toSURL, pinLifetime, fileLifetime, fileStorageType, spaceToken, expectedFileSize, transferProtocols, overwriteOption, status, transferURL);
            data.store();
        }
        catch (InvalidPtPDataAttributesException e) {
            log.error("Unable to build PtPChunkData. InvalidPtPChunkDataAttributesException: " + e.getMessage());
            throw new BuilderException("Error building PtP PtPChunkData. Building failed");
        }
        catch (InvalidFileTransferDataAttributesException e) {
            log.error("Unable to build PtPChunkData. InvalidFileTransferChunkDataAttributesException: " + e.getMessage());
            throw new BuilderException("Error building PtP PtPChunkData. Building failed");
        }
        catch (InvalidSurlRequestDataAttributesException e) {
            log.error("Unable to build PtPChunkData. InvalidSurlRequestDataAttributesException: " + e.getMessage());
            throw new BuilderException("Error building PtP PtPChunkData. Building failed");
        }
        try {
            return new PtP(data);
        }
        catch (InvalidRequestAttributesException e) {
            log.error("Unable to build PtP. InvalidRequestAttributesException: " + e.getMessage());
            throw new BuilderException("Error building PtP. Building failed");
        }
    }
}

