/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.asynch;

import it.grid.storm.asynch.GlobalStatusManager;
import it.grid.storm.asynch.InvalidOverallRequestAttributeException;
import it.grid.storm.asynch.InvalidPersistentRequestAttributesException;
import it.grid.storm.asynch.InvalidPtGFeederAttributesException;
import it.grid.storm.asynch.InvalidRequestAttributesException;
import it.grid.storm.asynch.PtGPersistentChunk;
import it.grid.storm.asynch.SchedulerFacade;
import it.grid.storm.catalogs.InvalidSurlRequestDataAttributesException;
import it.grid.storm.catalogs.PtGChunkCatalog;
import it.grid.storm.catalogs.PtGPersistentChunkData;
import it.grid.storm.catalogs.RequestSummaryCatalog;
import it.grid.storm.catalogs.RequestSummaryData;
import it.grid.storm.namespace.InvalidDescendantsAuthRequestException;
import it.grid.storm.namespace.InvalidDescendantsEmptyRequestException;
import it.grid.storm.namespace.InvalidDescendantsFileRequestException;
import it.grid.storm.namespace.InvalidDescendantsPathRequestException;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.StoRI;
import it.grid.storm.namespace.UnapprochableSurlException;
import it.grid.storm.scheduler.Delegable;
import it.grid.storm.scheduler.SchedulerException;
import it.grid.storm.srm.types.InvalidTDirOptionAttributesException;
import it.grid.storm.srm.types.TDirOption;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.synchcall.data.DataHelper;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PtGFeeder
implements Delegable {
    private static Logger log = LoggerFactory.getLogger(PtGFeeder.class);
    private RequestSummaryData rsd = null;
    private GlobalStatusManager gsm = null;

    public PtGFeeder(RequestSummaryData rsd) throws InvalidPtGFeederAttributesException {
        if (rsd == null) {
            throw new InvalidPtGFeederAttributesException(null, null, null);
        }
        if (rsd.gridUser() == null) {
            throw new InvalidPtGFeederAttributesException(rsd, null, null);
        }
        try {
            this.rsd = rsd;
            this.gsm = new GlobalStatusManager(rsd.requestToken());
        }
        catch (InvalidOverallRequestAttributeException e) {
            log.error("ATTENTION in PtGFeeder! Programming bug when creating GlobalStatusManager! " + e);
            throw new InvalidPtGFeederAttributesException(rsd, null, null);
        }
    }

    @Override
    public void doIt() {
        log.debug("PtGFeeder: pre-processing " + this.rsd.requestToken());
        Collection<PtGPersistentChunkData> chunks = PtGChunkCatalog.getInstance().lookup(this.rsd.requestToken());
        if (chunks.isEmpty()) {
            log.warn("ATTENTION in PtGFeeder! This SRM PtG request contained nothing to process! " + this.rsd.requestToken());
            RequestSummaryCatalog.getInstance().failRequest(this.rsd, "This SRM Get request contained nothing to process!");
        } else {
            this.manageChunks(chunks);
            log.debug("PtGFeeder: finished pre-processing " + this.rsd.requestToken());
        }
    }

    private void manageChunks(Collection<PtGPersistentChunkData> chunks) {
        log.debug("PtGFeeder - number of chunks in request: " + chunks.size());
        for (PtGPersistentChunkData chunkData : chunks) {
            this.gsm.addChunk(chunkData);
            if (TSURL.isValid(chunkData.getSURL())) {
                if (chunkData.getDirOption().isDirectory()) {
                    this.manageIsDirectory(chunkData);
                    continue;
                }
                this.manageNotDirectory(chunkData);
                continue;
            }
            log.warn("PtGFeeder: srmPtG contract violation! fromSURL does not correspond to this machine!");
            log.warn("Request: " + this.rsd.requestToken());
            log.warn("Chunk: " + chunkData);
            chunkData.changeStatusSRM_FAILURE("SRM protocol violation! Cannot do an srmPtG of a SURL that is not local!");
            PtGChunkCatalog.getInstance().update(chunkData);
            this.gsm.failedChunk(chunkData);
        }
        this.gsm.finishedAdding();
    }

    private void manageNotDirectory(PtGPersistentChunkData auxChunkData) {
        log.debug("PtGFeeder - scheduling... ");
        auxChunkData.changeStatusSRM_REQUEST_INPROGRESS("srmPrepareToGet chunk is being processed!");
        PtGChunkCatalog.getInstance().update(auxChunkData);
        try {
            SchedulerFacade.getInstance().chunkScheduler().schedule(new PtGPersistentChunk(this.rsd, auxChunkData, this.gsm));
            log.debug("PtGFeeder - chunk scheduled.");
        }
        catch (InvalidPersistentRequestAttributesException e) {
            log.error("UNEXPECTED ERROR in PtGFeeder! Chunk could not be created!\n" + e);
            log.error("Request: " + this.rsd.requestToken());
            log.error("Chunk: " + auxChunkData);
            auxChunkData.changeStatusSRM_FAILURE("StoRM internal error does not allow this chunk to be processed!");
            PtGChunkCatalog.getInstance().update(auxChunkData);
            this.gsm.failedChunk(auxChunkData);
        }
        catch (InvalidRequestAttributesException e) {
            log.error("UNEXPECTED ERROR in PtGFeeder! Chunk could not be created!\n" + e);
            log.error("Request: " + this.rsd.requestToken());
            log.error("Chunk: " + auxChunkData);
            auxChunkData.changeStatusSRM_FAILURE("StoRM internal error does not allow this chunk to be processed!");
            PtGChunkCatalog.getInstance().update(auxChunkData);
            this.gsm.failedChunk(auxChunkData);
        }
        catch (SchedulerException e) {
            log.error("UNEXPECTED ERROR in ChunkScheduler! Chunk could not be scheduled!\n" + e);
            log.error("Request: " + this.rsd.requestToken());
            log.error("Chunk: " + auxChunkData);
            auxChunkData.changeStatusSRM_FAILURE("StoRM internal scheduler error prevented this chunk from being processed!");
            PtGChunkCatalog.getInstance().update(auxChunkData);
            this.gsm.failedChunk(auxChunkData);
        }
    }

    private void manageIsDirectory(PtGPersistentChunkData chunkData) {
        log.debug("PtGFeeder - pre-processing Directory chunk...");
        chunkData.changeStatusSRM_REQUEST_INPROGRESS("srmPrepareToGet chunk is being processed!");
        PtGChunkCatalog.getInstance().update(chunkData);
        try {
            StoRI stori = null;
            try {
                stori = NamespaceDirector.getNamespace().resolveStoRIbySURL(chunkData.getSURL(), chunkData.getUser());
            }
            catch (IllegalArgumentException e) {
                log.error("Unable to build StoRI by SURL and user", (Throwable)e);
                chunkData.changeStatusSRM_INTERNAL_ERROR("Unable to build StoRI by SURL and user");
                PtGChunkCatalog.getInstance().update(chunkData);
                log.error("ATTENTION in PtGFeeder! PtGFeeder received request for a SURL and user not recognised by StoRI!");
                this.gsm.failedChunk(chunkData);
            }
            catch (UnapprochableSurlException e) {
                chunkData.changeStatusSRM_INVALID_PATH("Invalid SURL path specified");
                PtGChunkCatalog.getInstance().update(chunkData);
                log.info("Unable to build a stori for surl " + chunkData.getSURL() + " for user " + DataHelper.getRequestor(chunkData) + " UnapprochableSurlException: " + e.getMessage());
                this.gsm.failedChunk(chunkData);
            }
            if (stori != null) {
                ArrayList<StoRI> storiChildren = stori.getChildren(chunkData.getDirOption());
                log.debug("PtGFeeder - Number of children in parent: " + storiChildren.size());
                TDirOption notDir = new TDirOption(false, false, 0);
                for (StoRI storiChild : storiChildren) {
                    try {
                        PtGPersistentChunkData childData = new PtGPersistentChunkData(chunkData.getUser(), chunkData.getRequestToken(), storiChild.getSURL(), chunkData.getPinLifeTime(), notDir, chunkData.getTransferProtocols(), chunkData.getFileSize(), chunkData.getStatus(), chunkData.getTransferURL());
                        PtGChunkCatalog.getInstance().addChild(childData);
                        log.debug("PtGFeeder - added child data: " + childData);
                        this.gsm.addChunk(childData);
                        this.manageNotDirectory(childData);
                    }
                    catch (InvalidSurlRequestDataAttributesException e) {
                        log.error("ERROR in PtGFeeder! While expanding recursive request, it was not possible to create a new PtGPersistentChunkData! " + e);
                    }
                }
                log.debug("PtGFeeder - expansion completed.");
                chunkData.changeStatusSRM_FILE_PINNED("srmPrepareToGet with dirOption set: request successfully expanded!");
                PtGChunkCatalog.getInstance().update(chunkData);
                this.gsm.successfulChunk(chunkData);
            }
        }
        catch (InvalidTDirOptionAttributesException e) {
            chunkData.changeStatusSRM_FAILURE("srmPrepareToGet with dirOption set: expansion failure due to internal error!");
            PtGChunkCatalog.getInstance().update(chunkData);
            log.error("UNEXPECTED ERROR in PtGFeeder! Could not create TDirOption specifying non-expansion!\n" + e);
            log.error("Request: " + this.rsd.requestToken());
            log.error("Chunk: " + chunkData);
            this.gsm.failedChunk(chunkData);
        }
        catch (InvalidDescendantsEmptyRequestException e) {
            chunkData.changeStatusSRM_FILE_PINNED("BEWARE! srmPrepareToGet with dirOption set: it referred to a directory that was empty!");
            PtGChunkCatalog.getInstance().update(chunkData);
            log.debug("ATTENTION in PtGFeeder! PtGFeeder received request to expand empty directory.");
            this.gsm.successfulChunk(chunkData);
        }
        catch (InvalidDescendantsPathRequestException e) {
            chunkData.changeStatusSRM_INVALID_PATH("srmPrepareToGet with dirOption set: it referred to a non-existent directory!");
            PtGChunkCatalog.getInstance().update(chunkData);
            log.debug("ATTENTION in PtGFeeder! PtGFeeder received request to expand non-existing directory.");
            this.gsm.failedChunk(chunkData);
        }
        catch (InvalidDescendantsFileRequestException e) {
            chunkData.changeStatusSRM_INVALID_PATH("srmPrepareToGet with dirOption set: a file was asked to be expanded!");
            PtGChunkCatalog.getInstance().update(chunkData);
            log.debug("ATTENTION in PtGFeeder! PtGFeeder received request to expand a file.");
            this.gsm.failedChunk(chunkData);
        }
        catch (InvalidDescendantsAuthRequestException e) {
            chunkData.changeStatusSRM_AUTHORIZATION_FAILURE("srmPrepareToGet with dirOption set: user has no right to access directory!");
            PtGChunkCatalog.getInstance().update(chunkData);
            log.debug("ATTENTION in PtGFeeder! PtGFeeder received request to expand a directory for which the user has no rights.");
            this.gsm.failedChunk(chunkData);
        }
    }

    @Override
    public String getName() {
        return "PtGFeeder of request: " + this.rsd.requestToken();
    }
}

