/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.asynch;

import it.grid.storm.asynch.InvalidPutReplyAttributeException;
import it.grid.storm.asynch.InvalidPutStatusAttributesException;
import it.grid.storm.asynch.SRMClient;
import it.grid.storm.asynch.SRMClientException;
import it.grid.storm.asynch.SRMPrepareToPutReply;
import it.grid.storm.asynch.SRMPutDoneReply;
import it.grid.storm.asynch.SRMStatusOfPutRequestReply;
import it.grid.storm.asynch.WSConversionException;
import it.grid.storm.asynch.WSFileStorageTypeConverter;
import it.grid.storm.asynch.WSOverwriteModeConverter;
import it.grid.storm.asynch.WSRequestTokenConverter;
import it.grid.storm.asynch.WSReturnStatusConverter;
import it.grid.storm.asynch.WSTurlConverter;
import it.grid.storm.common.types.TransferProtocol;
import it.grid.storm.griduser.AbstractGridUser;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.srm.types.InvalidTUserIDAttributeException;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TOverwriteMode;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TTURL;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.Stub;
import javax.xml.rpc.soap.SOAPFaultException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.transport.http.HTTPSender;
import org.apache.axis.types.URI;
import org.apache.axis.types.UnsignedLong;
import org.globus.axis.transport.GSIHTTPSender;
import org.globus.axis.util.Util;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.auth.NoAuthorization;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import srmClientStubs.ArrayOfAnyURI;
import srmClientStubs.ArrayOfString;
import srmClientStubs.ArrayOfTPutFileRequest;
import srmClientStubs.ArrayOfTPutRequestFileStatus;
import srmClientStubs.ISRM;
import srmClientStubs.SRMServiceLocator;
import srmClientStubs.SrmPrepareToPutRequest;
import srmClientStubs.SrmPrepareToPutResponse;
import srmClientStubs.SrmStatusOfPutRequestRequest;
import srmClientStubs.SrmStatusOfPutRequestResponse;
import srmClientStubs.TFileStorageType;
import srmClientStubs.TPutFileRequest;
import srmClientStubs.TPutRequestFileStatus;
import srmClientStubs.TReturnStatus;
import srmClientStubs.TTransferParameters;

public class NaiveSRMClient
implements SRMClient {
    private static Logger log = LoggerFactory.getLogger(NaiveSRMClient.class);

    @Override
    public SRMPrepareToPutReply prepareToPut(GridUserInterface gu, TSURL toSURL, TLifeTimeInSeconds lifetime, it.grid.storm.srm.types.TFileStorageType fileStorageType, TSpaceToken spaceToken, TSizeInBytes filesize, TransferProtocol protocol, String description, TOverwriteMode overwriteOption, TLifeTimeInSeconds retryTime) throws SRMClientException {
        try {
            ISRM _srm = this.setUpGSI(gu, toSURL);
            SrmPrepareToPutRequest req = new SrmPrepareToPutRequest();
            String stubuid = gu.getDn();
            req.setAuthorizationID(stubuid);
            req.setUserRequestDescription(description);
            String[] protocolArray = new String[]{protocol.toString()};
            ArrayOfString protocolArrayString = new ArrayOfString();
            protocolArrayString.setStringArray(protocolArray);
            TTransferParameters stubtp = new TTransferParameters();
            stubtp.setArrayOfTransferProtocols(protocolArrayString);
            req.setTransferParameters(stubtp);
            req.setOverwriteOption(new WSOverwriteModeConverter().fromStoRM(overwriteOption));
            req.setDesiredTotalRequestTime(new Integer(new Long(retryTime.value()).intValue()));
            TFileStorageType stubfst = new WSFileStorageTypeConverter().fromStoRM(fileStorageType);
            req.setDesiredFileStorageType(stubfst);
            req.setTargetSpaceToken(spaceToken.toString());
            req.setDesiredFileLifeTime(new Integer(new Long(lifetime.value()).intValue()));
            TPutFileRequest stubpfr = new TPutFileRequest();
            UnsignedLong ulFileSize = new UnsignedLong(filesize.value());
            stubpfr.setExpectedFileSize(ulFileSize);
            stubpfr.setTargetSURL(new URI(toSURL.toString()));
            TPutFileRequest[] stubpfrArray = new TPutFileRequest[]{stubpfr};
            ArrayOfTPutFileRequest arrayOfPut = new ArrayOfTPutFileRequest(stubpfrArray);
            req.setArrayOfFileRequests(arrayOfPut);
            log.debug("NAIVE SRM CLIENT: sending request " + arrayOfPut);
            SrmPrepareToPutResponse response = _srm.srmPrepareToPut(req);
            log.debug("NAIVE SRM CLIENT: received reply " + response);
            TRequestToken requestToken = new WSRequestTokenConverter().fromWS(response.getRequestToken());
            ArrayOfTPutRequestFileStatus arrayOfPutFileStatuses = response.getArrayOfFileStatuses();
            TPutRequestFileStatus[] stubFileStatusArray = arrayOfPutFileStatuses.getStatusArray();
            TPutRequestFileStatus stubFileStatus = stubFileStatusArray[0];
            TReturnStatus stubStatus = stubFileStatus.getStatus();
            it.grid.storm.srm.types.TReturnStatus retStat = WSReturnStatusConverter.getInstance().fromWS(stubStatus);
            return new SRMPrepareToPutReply(requestToken);
        }
        catch (InvalidTUserIDAttributeException e) {
            throw new SRMClientException("Unexpected error in NaiveSRMClient! Cannot get gredentials from GridUser! " + e);
        }
        catch (GlobusCredentialException e) {
            throw new SRMClientException("Unexpected error in NaiveSRMClient! Cannot create GlobusCredentials from GridUser! " + (Object)((Object)e));
        }
        catch (GSSException e) {
            throw new SRMClientException("Unexpected error in NaiveSRMClient! Cannot create GSSCredentials from GlobusCredential! " + e);
        }
        catch (URI.MalformedURIException ex) {
            throw new SRMClientException("Unexpected error in NaiveSRMClient! Cannot create URI! " + (Object)((Object)ex));
        }
        catch (ServiceException ex) {
            throw new SRMClientException("Web Service problem! " + (Object)((Object)ex));
        }
        catch (RemoteException ex) {
            throw new SRMClientException("Web Service Communication problem! " + ex);
        }
        catch (SOAPFaultException e) {
            throw new SRMClientException("The remote web service launched an exception! " + (Object)((Object)e));
        }
        catch (WSConversionException e) {
            throw new SRMClientException("There were problems translating between WebService and StoRM object model! " + e);
        }
        catch (InvalidPutReplyAttributeException e) {
            throw new SRMClientException("Unexpected error in NaiveSRMClient! Cannot create a reply to return! " + e);
        }
        catch (Exception e) {
            throw new SRMClientException("Unexpected runtime error in NaiveSRMClient! " + e);
        }
    }

    @Override
    public SRMStatusOfPutRequestReply statusOfPutRequest(TRequestToken rt, GridUserInterface gu, TSURL toSURL) throws SRMClientException {
        try {
            ISRM _srm = this.setUpGSI(gu, toSURL);
            SrmStatusOfPutRequestRequest req = new SrmStatusOfPutRequestRequest();
            req.setRequestToken(rt.toString());
            req.setAuthorizationID(gu.getDn());
            URI stubSurl = new URI(toSURL.toString());
            URI[] stubSurlArray = new URI[]{stubSurl};
            ArrayOfAnyURI arrayOfTSURL = new ArrayOfAnyURI(stubSurlArray);
            req.setArrayOfTargetSURLs(arrayOfTSURL);
            log.debug("NAIVE SRM CLIENT: invoking status of put with " + req);
            SrmStatusOfPutRequestResponse response = _srm.srmStatusOfPutRequest(req);
            log.debug("NAIVE SRM CLIENT: received response " + response);
            ArrayOfTPutRequestFileStatus arrayOfPutStatuses = response.getArrayOfFileStatuses();
            TPutRequestFileStatus[] stubFileStatusArray = arrayOfPutStatuses.getStatusArray();
            TPutRequestFileStatus stubFileStatus = stubFileStatusArray[0];
            URI stubTurl = stubFileStatus.getTransferURL();
            TReturnStatus stubStatus = stubFileStatus.getStatus();
            TTURL turl = new WSTurlConverter().fromWS(stubTurl);
            it.grid.storm.srm.types.TReturnStatus retStat = WSReturnStatusConverter.getInstance().fromWS(stubStatus);
            return new SRMStatusOfPutRequestReply(turl, retStat);
        }
        catch (InvalidTUserIDAttributeException e) {
            throw new SRMClientException("Unexpected error in NaiveSRMClient! Cannot get gredentials from GridUser! " + e);
        }
        catch (GlobusCredentialException e) {
            throw new SRMClientException("Unexpected error in NaiveSRMClient! Cannot create GlobusCredentials from GridUser! " + (Object)((Object)e));
        }
        catch (GSSException e) {
            throw new SRMClientException("Unexpected error in NaiveSRMClient! Cannot create GSSCredentials from GlobusCredential! " + e);
        }
        catch (URI.MalformedURIException ex) {
            throw new SRMClientException("Unexpected error in NaiveSRMClient! Cannot create URI! " + (Object)((Object)ex));
        }
        catch (ServiceException ex) {
            throw new SRMClientException("Web Service problem! " + (Object)((Object)ex));
        }
        catch (RemoteException ex) {
            throw new SRMClientException("Communication problem! " + ex);
        }
        catch (SOAPFaultException e) {
            throw new SRMClientException("The remote web service launched an exception! " + (Object)((Object)e));
        }
        catch (WSConversionException e) {
            throw new SRMClientException("The answer received from the WebService cannot be converted to StoRM object model! " + e);
        }
        catch (InvalidPutStatusAttributesException e) {
            throw new SRMClientException("Unexpected error in NaiveSRMClient! Cannot create a reply to return! " + e);
        }
        catch (Exception e) {
            throw new SRMClientException("Unexpected runtime error in NaiveSRMClient! " + e);
        }
    }

    @Override
    public SRMPutDoneReply srmPutDone(TRequestToken rt, GridUserInterface gu, TSURL toSURL) throws SRMClientException {
        return null;
    }

    private ISRM setUpGSI(GridUserInterface gu, TSURL toSURL) throws ServiceException, GlobusCredentialException, GSSException, InvalidTUserIDAttributeException {
        Util.registerTransport();
        SimpleProvider provider = new SimpleProvider();
        SimpleTargetedChain c = null;
        c = new SimpleTargetedChain((Handler)new GSIHTTPSender());
        provider.deployTransport("httpg", (Handler)c);
        c = new SimpleTargetedChain((Handler)new HTTPSender());
        provider.deployTransport("http", (Handler)c);
        SRMServiceLocator sRMService = new SRMServiceLocator((EngineConfiguration)provider);
        ISRM _srm = sRMService.getsrm();
        if (((AbstractGridUser)gu).getUserCredentials() == null) {
            log.error("ERROR in NaiveSRMClient! No proxy present for " + gu.getDn());
        }
        ByteArrayInputStream proxy = new ByteArrayInputStream(((AbstractGridUser)gu).getUserCredentials().getBytes());
        GlobusGSSCredentialImpl globusProxy = new GlobusGSSCredentialImpl(new GlobusCredential((InputStream)proxy), 0);
        ((Stub)_srm)._setProperty("org.globus.gsi.credentials", (Object)globusProxy);
        ((Stub)_srm)._setProperty("org.globus.gsi.authorization", (Object)NoAuthorization.getInstance());
        ((Stub)_srm)._setProperty("org.globus.gsi.mode", (Object)"gsi");
        String sea = "httpg://" + toSURL.sfn().machine() + ":" + toSURL.sfn().port() + "/";
        ((Stub)_srm)._setProperty("javax.xml.rpc.service.endpoint.address", (Object)sea);
        return _srm;
    }
}

