/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.asynch;

import it.grid.storm.asynch.GridFTPTransferClient;
import it.grid.storm.asynch.GridFTPTransferClientException;
import it.grid.storm.common.types.TransferProtocol;
import it.grid.storm.config.Configuration;
import it.grid.storm.griduser.AbstractGridUser;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.srm.types.TTURL;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.globus.ftp.FeatureList;
import org.globus.ftp.GridFTPClient;
import org.globus.ftp.exception.ClientException;
import org.globus.ftp.exception.ServerException;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NaiveGridFTPTransferClient
implements GridFTPTransferClient {
    private static final Logger log = LoggerFactory.getLogger(NaiveGridFTPTransferClient.class);

    @Override
    public void putFile(GridUserInterface gu, TTURL local, TTURL remote) throws GridFTPTransferClientException {
        boolean remoteIsGSIFTP;
        boolean localIsFile = local.protocol() == TransferProtocol.FILE;
        boolean bl = remoteIsGSIFTP = remote.protocol() == TransferProtocol.GSIFTP;
        if (!localIsFile || !remoteIsGSIFTP) {
            throw new GridFTPTransferClientException("Unsupported local/remote protocol: local-is-file=" + localIsFile + ", remote-is-GSIFTP=" + remoteIsGSIFTP);
        }
        String fullLocalFile = "/" + local.tfn().pfn().getValue();
        String fullRemoteFile = "/" + remote.tfn().pfn().getValue();
        try {
            ByteArrayInputStream proxy = new ByteArrayInputStream(((AbstractGridUser)gu).getUserCredentials().getBytes());
            int remotePort = 2811;
            if (!remote.tfn().port().isEmpty()) {
                remotePort = remote.tfn().port().toInt();
            }
            GridFTPClient client = new GridFTPClient(remote.tfn().machine().getValue(), remotePort);
            client.authenticate((GSSCredential)new GlobusGSSCredentialImpl(new GlobusCredential((InputStream)proxy), 0));
            client.setType(1);
            FeatureList fl = client.getFeatureList();
            log.debug("NAIVE GSIFTP CLIENT: Remote server supports " + fl.toString());
            if (!fl.contains("DCAU")) {
                log.debug("NAIVE GSIFTP CLIENT: disabling DCAU");
                client.setLocalNoDataChannelAuthentication();
            }
            client.setClientWaitParams(Configuration.getInstance().getGridFTPTimeOut(), 200);
            client.put(new File(fullLocalFile), fullRemoteFile, false);
            client.close();
        }
        catch (IOException e) {
            throw new GridFTPTransferClientException(e.toString());
        }
        catch (ServerException e) {
            throw new GridFTPTransferClientException(e.toString());
        }
        catch (ClientException e) {
            throw new GridFTPTransferClientException(e.toString());
        }
        catch (GlobusCredentialException e) {
            throw new GridFTPTransferClientException(e.toString());
        }
        catch (GSSException e) {
            throw new GridFTPTransferClientException(e.toString());
        }
        catch (Exception e) {
            throw new GridFTPTransferClientException("Unexpected runtime error in NaiveGridFTPTransferClient! " + e);
        }
    }
}

