/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.asynch;

import it.grid.storm.asynch.InvalidCopyAttributesException;
import it.grid.storm.asynch.Request;
import it.grid.storm.catalogs.CopyData;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.scheduler.Chooser;
import it.grid.storm.scheduler.Delegable;
import it.grid.storm.scheduler.Streets;
import it.grid.storm.srm.types.InvalidTRequestTokenAttributesException;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.srm.types.TTURL;
import java.util.Calendar;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Copy
implements Delegable,
Chooser,
Request {
    private final String COPY_PREFIX = "COPY-";
    protected final TRequestToken localrt;
    protected final int n;
    protected final CopyData requestData;
    protected final GridUserInterface gu;
    protected boolean failure = false;
    private static Logger log = LoggerFactory.getLogger(Copy.class);

    public Copy(GridUserInterface gu, CopyData requestData, int n) throws InvalidCopyAttributesException {
        if (gu == null || n < 0 || requestData == null) {
            throw new InvalidCopyAttributesException(gu, requestData, n);
        }
        this.gu = gu;
        this.requestData = requestData;
        this.n = n;
        try {
            this.localrt = new TRequestToken("COPY-".concat(UUID.randomUUID().toString().substring("COPY-".length())), Calendar.getInstance().getTime());
        }
        catch (InvalidTRequestTokenAttributesException e) {
            log.error("Unexpected InvalidTRequestTokenAttributesException: " + e.getMessage());
            throw new IllegalStateException("Unexpected InvalidTRequestTokenAttributesException");
        }
    }

    @Override
    public void choose(Streets s) {
        s.copyStreet(this);
    }

    @Override
    public void doIt() {
        log.debug("Handling Copy chunk for user DN: " + this.gu.getDn() + "; fromSURL: " + this.requestData.getSURL() + "; toSURL: " + this.requestData.getDestinationSURL());
        log.debug("RequestToken used for local operation: " + this.localrt);
        GetOperationResult getResult = this.executeGetOperation();
        log.debug("Result from get: " + getResult);
        if (getResult.successful() && getResult.status().getStatusCode() == TStatusCode.SRM_FILE_PINNED) {
            PutOperationResult putResult = this.executePutOperation(getResult.filesize());
            log.debug("Result from put: " + putResult);
            if (putResult.successful() && (putResult.status().getStatusCode().equals((Object)TStatusCode.SRM_SPACE_AVAILABLE) || putResult.status().getStatusCode().equals((Object)TStatusCode.SRM_SUCCESS))) {
                TransferResult transferResult = this.executeTransfer(getResult, putResult);
                log.debug("Result from transfer: " + transferResult);
                if (transferResult.successful()) {
                    this.requestData.changeStatusSRM_SUCCESS("srmCopy successfully handled!");
                    log.debug("SRM Copy successful!");
                    this.failure = false;
                } else {
                    String message = "GSIFTP transfer failed! " + transferResult.failureExplanation();
                    log.error(message);
                    this.requestData.changeStatusSRM_FAILURE(message);
                    this.failure = true;
                }
            } else {
                String message = "PUT part of srmCopy failed! ";
                if (putResult.successful()) {
                    message = message + putResult.status().toString();
                }
                log.error(message);
                this.requestData.changeStatusSRM_FAILURE("PUT part of srmCopy failed! " + message);
                this.failure = true;
            }
        } else {
            String message = "GET part of srmCopy failed! ";
            if (getResult.successful()) {
                message = message + getResult.status().toString();
            }
            log.error(message);
            this.requestData.changeStatusSRM_FAILURE(message);
            this.failure = true;
        }
        log.info("Finished handling Copy chunk for user DN: " + this.gu.getDn() + "; fromSURL: " + this.requestData.getSURL() + "; toSURL: " + this.requestData.getDestinationSURL() + " result is: " + this.requestData.getStatus());
    }

    @Override
    public String getName() {
        return "Copy for SURL " + this.requestData.getSURL() + " to SURL " + this.requestData.getDestinationSURL();
    }

    @Override
    public String getUserDN() {
        return this.gu.getDn();
    }

    @Override
    public String getSURL() {
        return this.requestData.getSURL().toString();
    }

    @Override
    public boolean isResultSuccess() {
        return this.requestData.getStatus().isSRM_SUCCESS();
    }

    protected abstract GetOperationResult executeGetOperation();

    protected abstract PutOperationResult executePutOperation(TSizeInBytes var1);

    protected abstract TransferResult executeTransfer(GetOperationResult var1, PutOperationResult var2);

    protected class PutOperationResult
    implements Result {
        private final ResultType type = ResultType.PUT;
        private boolean successful = false;
        private TReturnStatus status;
        private TTURL putTURL = TTURL.makeEmpty();
        private String failureExplanation = "";
        private TRequestToken rt = null;

        public PutOperationResult(TReturnStatus status, TTURL putTURL, TRequestToken rt) {
            if (status != null && putTURL != null && rt != null) {
                this.successful = true;
                this.status = status;
                this.putTURL = putTURL;
                this.rt = rt;
            } else {
                this.successful = false;
                try {
                    this.status = new TReturnStatus();
                }
                catch (InvalidTReturnStatusAttributeException e) {
                    log.warn("Unexpected InvalidTReturnStatusAttributeException: " + e);
                }
            }
        }

        public PutOperationResult(String failureExplanation) {
            if (failureExplanation == null) {
                failureExplanation = "";
            }
            this.successful = false;
            this.failureExplanation = failureExplanation;
            try {
                this.status = new TReturnStatus();
            }
            catch (InvalidTReturnStatusAttributeException e) {
                log.warn("Unexpected InvalidTReturnStatusAttributeException: " + e);
            }
        }

        @Override
        public boolean successful() {
            return this.successful;
        }

        public TReturnStatus status() {
            return this.status;
        }

        @Override
        public String failureExplanation() {
            return this.failureExplanation;
        }

        public TTURL putTURL() {
            return this.putTURL;
        }

        public TRequestToken requestToken() {
            return this.rt;
        }

        public String toString() {
            return "PutOperationResult: successful=" + this.successful + "; status=" + this.status + "; putTURL=" + this.putTURL + "; failureExplanation=" + this.failureExplanation;
        }
    }

    protected class GetOperationResult
    implements Result {
        private final ResultType type = ResultType.GET;
        private boolean successful = false;
        private TReturnStatus status;
        private TTURL getTURL = TTURL.makeEmpty();
        private TSizeInBytes filesize = TSizeInBytes.makeEmpty();
        private String failureExplanation = "";
        private TRequestToken rt = null;

        public GetOperationResult(TReturnStatus status, TTURL getTURL, TSizeInBytes filesize, TRequestToken rt) {
            if (status != null && getTURL != null && filesize != null && rt != null) {
                this.successful = true;
                this.status = status;
                this.getTURL = getTURL;
                this.filesize = filesize;
                this.rt = rt;
            } else {
                this.successful = false;
                try {
                    this.status = new TReturnStatus();
                }
                catch (InvalidTReturnStatusAttributeException e) {
                    log.warn("Unexpected InvalidTReturnStatusAttributeException: " + e);
                }
            }
        }

        public GetOperationResult(String failureExplanation) {
            if (failureExplanation == null) {
                failureExplanation = "";
            }
            this.successful = false;
            this.failureExplanation = failureExplanation;
            try {
                this.status = new TReturnStatus();
            }
            catch (InvalidTReturnStatusAttributeException e) {
                log.warn("Unexpected InvalidTReturnStatusAttributeException: " + e);
            }
        }

        @Override
        public boolean successful() {
            return this.successful;
        }

        public TReturnStatus status() {
            return this.status;
        }

        @Override
        public String failureExplanation() {
            return this.failureExplanation;
        }

        public TTURL getTURL() {
            return this.getTURL;
        }

        public TSizeInBytes filesize() {
            return this.filesize;
        }

        public TRequestToken requetToken() {
            return this.rt;
        }

        public String toString() {
            return "GetOperationResult: successful=" + this.successful + "; status=" + this.status + "; getTURL=" + this.getTURL + "; filesize=" + this.filesize + "; requestToken=" + this.rt;
        }
    }

    protected class TransferResult
    implements Result {
        private boolean successful = false;
        private String failureExplanation = "";
        private final ResultType type = ResultType.TRANSFER;

        public TransferResult(String failureExplanation) {
            if (failureExplanation == null) {
                failureExplanation = "";
            }
            this.successful = false;
            this.failureExplanation = failureExplanation;
        }

        public TransferResult() {
            this.successful = true;
            this.failureExplanation = "";
        }

        @Override
        public boolean successful() {
            return this.successful;
        }

        @Override
        public String failureExplanation() {
            return this.failureExplanation;
        }
    }

    public static enum ResultType {
        PUT,
        GET,
        TRANSFER;

    }

    public static interface Result {
        public boolean successful();

        public String failureExplanation();
    }
}

