/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gatekeeper.jobmanager.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.globus.gatekeeper.jobmanager.internal.JobManagerProtocol;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.SelfAuthorization;
import org.globus.gsi.gssapi.net.GssSocket;
import org.globus.gsi.gssapi.net.GssSocketFactory;
import org.globus.util.GlobusURL;
import org.globus.util.http.HTTPResponseParser;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;

public class StatusUpdater
implements Runnable {
    private static final int SO_TIMEOUT = 60000;
    private static final int PAUSE = 5000;
    private static final int MAX_TRIES = 3;
    private boolean stop = false;
    private LinkedList list = new LinkedList();
    private JobManagerProtocol _myProtocol = JobManagerProtocol.getInstance("");
    private Logger _logger;

    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    public void start() {
        Thread t = new Thread(this);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.stop = true;
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            this.list.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatus(GSSCredential cred, GlobusURL url, int status, int failureCode, String jmurl) {
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            this.list.add(new Status(cred, url, status, failureCode, jmurl));
            this.list.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDone() {
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            return this.stop && this.list.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        this.stop = false;
        this._logger.info((Object)"[statusUpdater] running...");
        GSSManager manager = ExtendedGSSManager.getInstance();
        GssSocketFactory factory = GssSocketFactory.getDefault();
        block30: while (!this.isDone()) {
            Status req = null;
            LinkedList linkedList = this.list;
            synchronized (linkedList) {
                try {
                    while (this.list.isEmpty()) {
                        this.list.wait();
                        if (!this.stop) continue;
                        break;
                    }
                }
                catch (InterruptedException e) {
                    break;
                }
                if (this.isDone()) {
                    break;
                }
                req = (Status)this.list.removeFirst();
            }
            for (int tries = 0; tries < 3; ++tries) {
                Exception e2222;
                Object var12_17;
                InputStream is;
                OutputStream os;
                GssSocket s;
                block49: {
                    block50: {
                        if (this._logger.isDebugEnabled()) {
                            this._logger.debug((Object)("[statusUpdater]: status update: " + req._url.getURL() + " " + req._status + " " + req._failureCode));
                        }
                        s = null;
                        os = null;
                        is = null;
                        ExtendedGSSContext context = (ExtendedGSSContext)manager.createContext(null, GSSConstants.MECH_OID, req._cred, 0);
                        context.setOption(GSSConstants.GSS_MODE, (Object)GSIConstants.MODE_SSL);
                        context.requestCredDeleg(false);
                        s = (GssSocket)factory.createSocket(req._url.getHost(), req._url.getPort(), (GSSContext)context);
                        s.setSoTimeout(60000);
                        s.setAuthorization((Authorization)SelfAuthorization.getInstance());
                        os = s.getOutputStream();
                        is = s.getInputStream();
                        String report = this._myProtocol.getStatusUpdateMessage(req._url.getURL(), req._jmurl, req._url.getHost(), req._status, req._failureCode);
                        os.write(report.getBytes());
                        os.flush();
                        HTTPResponseParser cr = new HTTPResponseParser(is);
                        if (!cr.isOK()) break block49;
                        if (this._logger.isDebugEnabled()) {
                            this._logger.debug((Object)("[statusUpdater]: client received status update: " + req._status));
                        }
                        if (req._status == 8 || req._status == 4) {
                            this.stop = true;
                        }
                        var12_17 = null;
                        if (os == null) break block50;
                        try {
                            os.close();
                        }
                        catch (Exception e2222) {
                            // empty catch block
                        }
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception e2222) {
                            // empty catch block
                        }
                    }
                    if (s == null) continue block30;
                    try {
                        s.close();
                    }
                    catch (Exception e2222) {}
                    continue block30;
                }
                var12_17 = null;
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception e2222) {
                        // empty catch block
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e2222) {
                        // empty catch block
                    }
                }
                if (s == null) continue;
                try {
                    s.close();
                }
                catch (Exception e2222) {}
                continue;
                {
                    catch (IOException e3) {
                        this._logger.debug((Object)"[statusUpdater]: failed. trying again...", (Throwable)e3);
                        if (tries + 1 < 3) {
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (Exception ee) {
                            }
                        }
                        var12_17 = null;
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (Exception e2222) {
                                // empty catch block
                            }
                        }
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception e2222) {
                                // empty catch block
                            }
                        }
                        if (s == null) continue;
                        try {
                            s.close();
                        }
                        catch (Exception e2222) {}
                        continue;
                    }
                    catch (Exception e4) {
                        this._logger.debug((Object)"Unexpected error.", (Throwable)e4);
                        var12_17 = null;
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (Exception e2222) {
                                // empty catch block
                            }
                        }
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception e2222) {
                                // empty catch block
                            }
                        }
                        if (s == null) continue;
                        try {
                            s.close();
                        }
                        catch (Exception e2222) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var12_17 = null;
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Exception e2222) {
                            // empty catch block
                        }
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception e2222) {
                            // empty catch block
                        }
                    }
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Exception e2222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
        this._logger.info((Object)"[statusUpdater] done.");
    }

    class Status {
        public GSSCredential _cred;
        public GlobusURL _url;
        public int _status;
        public int _failureCode;
        public String _jmurl;

        public Status(GSSCredential cred, GlobusURL url, int status, int failureCode, String jmurl) {
            this._cred = cred;
            this._url = url;
            this._status = status;
            this._failureCode = failureCode;
            this._jmurl = jmurl;
        }
    }
}

