/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gatekeeper.jobmanager.internal;

import java.io.IOException;
import java.io.InputStream;
import org.globus.gatekeeper.BadRequestException;
import org.globus.gatekeeper.ServiceRequest;
import org.globus.gatekeeper.jobmanager.JobManagerException;
import org.globus.gatekeeper.jobmanager.JobManagerService;
import org.globus.gatekeeper.jobmanager.internal.JobManagerRequest;
import org.globus.gatekeeper.jobmanager.internal.JobRequestParser;
import org.globus.util.http.HTTPProtocol;
import org.globus.util.http.HTTPRequestParser;

public class JobManagerProtocol
extends HTTPProtocol {
    private static JobManagerProtocol protocol = null;
    private static final String STATUS = "status: ";
    private static final String JOB_MANAGER_URL = "job-manager-url: ";
    private static final String FAILURE_CODE = "failure-code: ";

    public static JobManagerProtocol getInstance(String prot) {
        if (protocol == null) {
            protocol = new JobManagerProtocol();
        }
        return protocol;
    }

    public JobRequestParser handleJobRequest(ServiceRequest request) {
        if (request instanceof HTTPRequestParser) {
            return new JobRequestParser(((HTTPRequestParser)request).getReader());
        }
        return new JobRequestParser(request.getInputStream());
    }

    public void handleRequest(JobManagerService jobManager, InputStream in) throws IOException, JobManagerException {
        new JobManagerRequest(jobManager, in);
    }

    public String getErrorMessage(Exception e) {
        if (e instanceof JobManagerException) {
            return this.getRequestReply(((JobManagerException)((Object)e)).getErrorCode(), null);
        }
        if (e instanceof BadRequestException) {
            return JobManagerProtocol.getBadRequestErrorReply();
        }
        return this.getRequestReply(47, null);
    }

    public String getRequestReply(int status, String jobManagerUrl) {
        StringBuffer msg = new StringBuffer();
        msg.append("protocol-version: 2\r\n").append(STATUS).append(String.valueOf(status)).append("\r\n");
        if (jobManagerUrl != null) {
            msg.append(JOB_MANAGER_URL).append(jobManagerUrl).append("\r\n");
        }
        return JobManagerProtocol.getOKReply((String)"application/x-globus-gram", (String)msg.toString());
    }

    public String getRequestReply(int status, int failureCode) {
        StringBuffer msg = new StringBuffer();
        msg.append("protocol-version: 2\r\n").append(STATUS).append(String.valueOf(status)).append("\r\n").append(FAILURE_CODE).append(failureCode).append("\r\n");
        return JobManagerProtocol.getOKReply((String)"application/x-globus-gram", (String)msg.toString());
    }

    public String getStatusUpdateMessage(String callbackUrl, String jobManagerUrl, String host, int status, int failureCode) {
        StringBuffer msg = new StringBuffer();
        msg.append("protocol-version: 2\r\n").append(JOB_MANAGER_URL).append(jobManagerUrl).append("\r\n").append(STATUS).append(String.valueOf(status)).append("\r\n").append(FAILURE_CODE).append(failureCode).append("\r\n");
        return JobManagerProtocol.createHTTPHeader((String)callbackUrl, (String)host, (String)"application/x-globus-gram", (StringBuffer)msg);
    }
}

