/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gatekeeper.jobmanager.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.globus.gatekeeper.jobmanager.JobManagerException;
import org.globus.gatekeeper.jobmanager.JobManagerService;
import org.globus.gatekeeper.jobmanager.internal.JobManagerProtocol;

public class JobManagerClient
extends Thread {
    private Socket _socket = null;
    private JobManagerService _jobManager = null;
    private InputStream _input = null;
    private OutputStream _output = null;
    private JobManagerProtocol _jobManagerProtocol = null;

    public JobManagerClient(Socket socket, JobManagerService jm) {
        this._socket = socket;
        this._jobManager = jm;
        this._jobManagerProtocol = JobManagerProtocol.getInstance("GRAM1.0");
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this._input = this._socket.getInputStream();
            this._output = this._socket.getOutputStream();
            this._jobManagerProtocol.handleRequest(this._jobManager, this._input);
            this.sendOKMessage();
        }
        catch (JobManagerException e) {
            this.sendFailureMessage((Exception)((Object)e));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            this.sendFailureMessage(e);
        }
        finally {
            this.close();
        }
    }

    private void close() {
        if (this._output != null) {
            try {
                this._output.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this._input != null) {
            try {
                this._input.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void write(String msg) {
        if (msg == null) {
            return;
        }
        try {
            this._output.write(msg.getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendOKMessage() {
        this.write(this._jobManagerProtocol.getRequestReply(this._jobManager.getStatus(), this._jobManager.getFailureCode()));
    }

    private void sendFailureMessage(Exception e) {
        e.printStackTrace();
        this.write(this._jobManagerProtocol.getErrorMessage(e));
    }
}

