/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gatekeeper.jobmanager;

import java.net.MalformedURLException;
import org.apache.log4j.Logger;
import org.globus.gatekeeper.Service;
import org.globus.gatekeeper.ServiceException;
import org.globus.gatekeeper.ServiceRequest;
import org.globus.gatekeeper.jobmanager.AbstractJobManager;
import org.globus.gatekeeper.jobmanager.JobDoneListener;
import org.globus.gatekeeper.jobmanager.JobManager;
import org.globus.gatekeeper.jobmanager.JobManagerException;
import org.globus.gatekeeper.jobmanager.JobStatusListener;
import org.globus.gatekeeper.jobmanager.internal.JobManagerProtocol;
import org.globus.gatekeeper.jobmanager.internal.JobManagerServer;
import org.globus.gatekeeper.jobmanager.internal.JobRequestParser;
import org.globus.gatekeeper.jobmanager.internal.StatusUpdater;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;

public class JobManagerService
implements Service {
    protected JobManagerServer _jmServer;
    protected JobManagerProtocol _protocol;
    protected AbstractJobManager _jobManager;
    protected String _handle;
    protected GSSCredential _credentials;
    protected Logger _logger;

    public JobManagerService(AbstractJobManager jobManager) {
        if (jobManager == null) {
            throw new IllegalArgumentException("Job Manager reference cannot be null");
        }
        this._protocol = JobManagerProtocol.getInstance("");
        this._jobManager = jobManager;
        this._logger = Logger.getLogger((String)(this.getClass().getName() + "." + this.hashCode()));
        this._jobManager.setLogger(this._logger);
    }

    public String getRequestSuccessMessage() {
        return this._protocol.getRequestReply(0, this.getHandle());
    }

    public String getRequestFailMessage(Exception e) {
        return this._protocol.getErrorMessage(e);
    }

    public void setCredentials(GSSCredential credentials) {
        this._credentials = credentials;
        this._jobManager.setCredentials(credentials);
    }

    public String getHandle() {
        return this._handle;
    }

    public void setArguments(String[] args) throws ServiceException {
    }

    public void request(ServiceRequest request) throws ServiceException {
        JobRequestParser req = null;
        this._jobManager.addJobStatusListener(new ShutdownListener());
        try {
            req = this._protocol.handleJobRequest(request);
            req.parse();
            String callbackUrl = req.getCallbackURL();
            if (callbackUrl != null && !callbackUrl.equals("") && !callbackUrl.equals("\"\"")) {
                this.register(callbackUrl, req.getJobStateMask());
            }
            this.initJobManagerServer();
        }
        catch (ServiceException e) {
            this.shutdown();
            throw e;
        }
        catch (Exception e) {
            this._logger.error((Object)"Unexpected error.", (Throwable)e);
            this.shutdown();
            throw new JobManagerException();
        }
        this._jobManager.request(req.getRSL());
    }

    public void cancel() throws JobManagerException {
        this._jobManager.cancel();
    }

    public void signal(int signal, String args) throws JobManagerException {
        this._jobManager.signal(signal, args);
    }

    public int getStatus() {
        return this._jobManager.getStatus();
    }

    public int getFailureCode() {
        return this._jobManager.getFailureCode();
    }

    public void register(String url, int statusMask) throws JobManagerException {
        JobStatusRecipient rec = null;
        try {
            rec = new JobStatusRecipient(url, statusMask);
        }
        catch (Exception e) {
            throw new JobManagerException(77, (Throwable)e);
        }
        this._jobManager.addJobStatusListener(rec);
    }

    public void unregister(String url) throws JobManagerException {
        this._jobManager.removeJobStatusListenerByID(url);
    }

    private void initJobManagerServer() throws JobManagerException {
        try {
            this._jmServer = new JobManagerServer(this._credentials, 0);
            this._jmServer.setJobManager(this);
            this._handle = this._jmServer.getURL() + "/" + this._jobManager.getID();
            this._jobManager.getSymbolTable().put("GLOBUS_GRAM_JOB_CONTACT", this._handle);
        }
        catch (Exception e) {
            throw new JobManagerException(16, (Throwable)e);
        }
    }

    public void shutdown() {
        this._logger.info((Object)"[jm service] shutting down...");
        if (this._jmServer != null) {
            this._jmServer.shutdown();
        }
    }

    class ShutdownListener
    extends JobDoneListener {
        ShutdownListener() {
        }

        public void dispose() {
            JobManagerService.this.shutdown();
        }
    }

    class JobStatusRecipient
    implements JobStatusListener {
        private GlobusURL _url;
        private int _statusMask;
        private StatusUpdater _updater;

        public JobStatusRecipient(String url, int statusMask) throws MalformedURLException {
            this._url = new GlobusURL(url);
            this._statusMask = statusMask;
        }

        public GlobusURL getURL() {
            return this._url;
        }

        public String getID() {
            return this._url.getURL();
        }

        public int getStatusMask() {
            return this._statusMask;
        }

        public void dispose() {
            if (this._updater != null) {
                this._updater.stop();
            }
        }

        public void statusChanged(JobManager jobManager) {
            if (this._updater == null) {
                this._updater = new StatusUpdater();
                this._updater.setLogger(JobManagerService.this._logger);
                this._updater.start();
            }
            this._updater.updateStatus(JobManagerService.this._credentials, this.getURL(), jobManager.getStatus(), jobManager.getFailureCode(), JobManagerService.this.getHandle());
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("URL: ").append(this.getID());
            buf.append(" mask: ").append(String.valueOf(this._statusMask));
            return buf.toString();
        }
    }
}

