/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gatekeeper.jobmanager;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.globus.gatekeeper.jobmanager.AbstractJobManager;
import org.globus.gatekeeper.jobmanager.JobManagerException;
import org.globus.gatekeeper.jobmanager.JobRequest;
import org.globus.gatekeeper.jobmanager.internal.Pipe;
import org.globus.rsl.RslAttributes;

public class ForkJobManager
extends AbstractJobManager {
    private static final String[] FORK_ENV_VARIABLES = new String[]{"HOME", "LOGNAME", "TZ", "LANG"};
    private Process _process;
    private PListener _processListener;
    private InputStream stdIn;
    private OutputStream stdOut;
    private OutputStream stdErr;
    private boolean canceled;

    public ForkJobManager() {
        this.allowStdioUrls = true;
        this.canceled = false;
    }

    public void cancel() throws JobManagerException {
        if (this._jobLogger.isInfoEnabled()) {
            this._jobLogger.info((Object)("cancel called: " + (this._process != null)));
        }
        if (this._process != null) {
            this.canceled = true;
            this._process.destroy();
        }
    }

    public Map getEnvironment() {
        Map map = super.getEnvironment();
        for (int i = 0; i < FORK_ENV_VARIABLES.length; ++i) {
            String value = this._symbolTable.getProperty(FORK_ENV_VARIABLES[i]);
            if (value == null) continue;
            map.put(FORK_ENV_VARIABLES[i], value);
        }
        return map;
    }

    public void request(JobRequest request) throws JobManagerException {
        boolean stream;
        String file;
        int i;
        RslAttributes rsl = request.getRsl();
        String[] cmd = null;
        List list = rsl.getMulti("arguments");
        if (list != null) {
            cmd = new String[list.size() + 1];
            cmd[0] = request.getExecutable();
            Iterator iter = list.iterator();
            i = 1;
            while (iter.hasNext()) {
                cmd[i++] = (String)iter.next();
            }
        } else {
            cmd = new String[]{request.getExecutable()};
        }
        if ((file = request.getStdin()) != null) {
            try {
                this.stdIn = new FileInputStream(file);
            }
            catch (IOException e) {
                throw new JobManagerException(11);
            }
        }
        boolean bl = stream = (file = rsl.getSingle("output")) != null && file.equalsIgnoreCase("stream");
        if (this._jobLogger.isInfoEnabled()) {
            this._jobLogger.info((Object)("Stdio/err streaming: " + stream));
        }
        this.stdOut = this.openOut(request.getStdout(), stream, 73);
        this.stdErr = this.openOut(request.getStderr(), stream, 74);
        String[] env = this.getEnvArray(rsl.getMap("environment"));
        if (this._jobLogger.isDebugEnabled()) {
            for (i = 0; i < cmd.length; ++i) {
                this._jobLogger.debug((Object)("CMD LINE: " + cmd[i]));
            }
            for (i = 0; i < env.length; ++i) {
                this._jobLogger.debug((Object)("ENV LINE: " + env[i]));
            }
        }
        if (request.isDryRun()) {
            throw new JobManagerException(41);
        }
        try {
            this._process = Runtime.getRuntime().exec(cmd, env, request.getDirectory());
        }
        catch (Exception e) {
            throw new JobManagerException(71, (Throwable)e);
        }
        if (this.stdIn != null) {
            this.redirect(this._process.getOutputStream(), this.stdIn);
        }
        if (this.stdOut != null) {
            this.redirect(this.stdOut, this._process.getInputStream());
        }
        if (this.stdErr != null) {
            this.redirect(this.stdErr, this._process.getErrorStream());
        }
        this.setStatus(2);
        this._processListener = new PListener();
        this._processListener.start();
    }

    private OutputStream openOut(String file, boolean stream, int err) throws JobManagerException {
        if (file == null) {
            return null;
        }
        if (this._jobLogger.isInfoEnabled()) {
            this._jobLogger.info((Object)("Opening stdout/err file: " + file));
        }
        OutputStream out = null;
        if (file.indexOf("://") != -1) {
            if (stream) {
                out = this.openUrl(file, err);
            } else {
                try {
                    out = new FileOutputStream(this.redirectThruFile(file, err));
                }
                catch (IOException e) {
                    throw new JobManagerException(err, "Failed to redirect: " + file, e);
                }
            }
        } else {
            try {
                out = new FileOutputStream(file, this.appendStdout);
            }
            catch (IOException e) {
                throw new JobManagerException(err, "Failed to open (local): " + file, e);
            }
        }
        return out;
    }

    private void redirect(OutputStream out, InputStream in) throws JobManagerException {
        Pipe p = new Pipe();
        p.setLogger(this._jobLogger);
        p.setInputStream(in);
        p.setOutputStream(out);
        p.start();
    }

    protected void dispose() {
        this._jobLogger.info((Object)"[fork] Cleaning up...");
        if (this.stdIn != null) {
            try {
                this.stdIn.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.stdOut != null) {
            try {
                this.stdOut.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.stdErr != null) {
            try {
                this.stdErr.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose();
    }

    private void processDone(int exitcode) {
        this._failureCode = exitcode;
        if (this._jobLogger.isInfoEnabled()) {
            this._jobLogger.info((Object)("Process done, exit code: " + exitcode));
        }
        if (this.canceled) {
            this.setStatus(4);
        } else {
            this.setStatus(8);
        }
    }

    class PListener
    extends Thread {
        PListener() {
        }

        public void run() {
            try {
                int exitcode = ForkJobManager.this._process.waitFor();
                ForkJobManager.this.processDone(exitcode);
            }
            catch (Exception e) {
                ForkJobManager.this._jobLogger.error((Object)"Unexpected process error", (Throwable)e);
            }
        }
    }
}

