/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gatekeeper;

import java.io.FileInputStream;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.globus.gatekeeper.GateKeeperServer;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.security.gridmap.GridMap;
import org.ietf.jgss.GSSCredential;

public class Gatekeeper {
    private static final String message = "\nSyntax: java Gatekeeper [options]\n        java Gatekeeper -version\n        java Gatekeeper -help\n\n\tOptions\n\t-help | -usage\n\t\tDisplays usage\n\t-p | -port\n\t\tPort of the Gatekeeper\n\t-d | -debug\n\t\tEnable debug mode\n\t-s | -services\n\t\tSpecifies services configuration file.\n \t-l | -log\n\t\tSpecifies log file.\n\t-gridmap\n\t\tSpecifies gridmap file.\n\t-proxy\n\t\tProxy credentials to use.\n\t-serverKey\n\t\tSpecifies private key (to be used with -serverCert.\n\t-serverCert\n\t\tSpecifies certificate (to be used with -serverKey.\n\t-caCertDir\n\t\tSpecifies locations (directory or files) of trusted \n\t\tCA certificates.\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        block48: {
            block47: {
                port = 2119;
                debug = false;
                configFile = null;
                logFile = null;
                gridMapFile = null;
                proxyFile = null;
                serverKey = null;
                serverCert = null;
                caCertDir = null;
                error = false;
                for (i = 0; i < args.length; ++i) {
                    if (args[i].equalsIgnoreCase("-p") || args[i].equalsIgnoreCase("-port")) {
                        port = Integer.parseInt(args[++i]);
                        continue;
                    }
                    if (args[i].equalsIgnoreCase("-d") || args[i].equalsIgnoreCase("-debug")) {
                        debug = true;
                        continue;
                    }
                    if (args[i].equalsIgnoreCase("-s") || args[i].equalsIgnoreCase("-services")) {
                        configFile = args[++i];
                        continue;
                    }
                    if (args[i].equalsIgnoreCase("-l") || args[i].equalsIgnoreCase("-log")) {
                        logFile = args[++i];
                        continue;
                    }
                    if (args[i].equalsIgnoreCase("-gridmap")) {
                        gridMapFile = args[++i];
                        continue;
                    }
                    if (args[i].equalsIgnoreCase("-proxy")) {
                        proxyFile = args[++i];
                        continue;
                    }
                    if (args[i].equalsIgnoreCase("-serverKey")) {
                        serverKey = args[++i];
                        continue;
                    }
                    if (args[i].equalsIgnoreCase("-serverCert")) {
                        serverCert = args[++i];
                        continue;
                    }
                    if (args[i].equalsIgnoreCase("-cacertdir")) {
                        caCertDir = args[++i];
                        continue;
                    }
                    if (args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("-usage")) {
                        System.out.println("\nSyntax: java Gatekeeper [options]\n        java Gatekeeper -version\n        java Gatekeeper -help\n\n\tOptions\n\t-help | -usage\n\t\tDisplays usage\n\t-p | -port\n\t\tPort of the Gatekeeper\n\t-d | -debug\n\t\tEnable debug mode\n\t-s | -services\n\t\tSpecifies services configuration file.\n \t-l | -log\n\t\tSpecifies log file.\n\t-gridmap\n\t\tSpecifies gridmap file.\n\t-proxy\n\t\tProxy credentials to use.\n\t-serverKey\n\t\tSpecifies private key (to be used with -serverCert.\n\t-serverCert\n\t\tSpecifies certificate (to be used with -serverKey.\n\t-caCertDir\n\t\tSpecifies locations (directory or files) of trusted \n\t\tCA certificates.\n");
                        System.exit(0);
                        continue;
                    }
                    System.err.println();
                    System.err.println("Error: unreconginzed argument " + i + " : " + args[i]);
                    error = true;
                    break;
                }
                if (error) {
                    System.err.println("\nSyntax: java GateKeeperServer [-help][-p port][-c configFile]");
                    System.err.println("\nUse -help to display full usage.");
                    System.exit(1);
                }
                if (proxyFile != null && (serverKey != null || serverCert != null)) {
                    System.err.println();
                    System.err.println("Error: You cannot specify -proxy with -serverKey or -serverCert.");
                    System.exit(1);
                }
                if (serverKey != null && serverCert == null || serverKey == null && serverCert != null) {
                    System.err.println();
                    System.err.println("Error: -serverKey and -serverCert must be specified togeter");
                }
                gssCred = null;
                credentials = null;
                try {
                    if (proxyFile == null && serverKey == null && serverCert == null) {
                        credentials = GlobusCredential.getDefaultCredential();
                    } else if (proxyFile != null) {
                        credentials = new GlobusCredential(proxyFile);
                    } else if (serverKey != null && serverCert != null) {
                        credentials = new GlobusCredential(serverCert, serverKey);
                    } else {
                        System.err.println();
                        System.err.println("Error: No credentials loaded.");
                        System.exit(1);
                    }
                    gssCred = new GlobusGSSCredentialImpl(credentials, 2);
                }
                catch (Exception e) {
                    System.err.println("Failed to load credentials: " + e.getMessage());
                    System.exit(1);
                }
                gridMap = new GridMap();
                if (gridMapFile != null) {
                    try {
                        gridMap.load(gridMapFile);
                    }
                    catch (Exception e) {
                        System.err.println("Failed to load grid map file: " + e.getMessage());
                        System.exit(1);
                    }
                } else {
                    try {
                        gridMap.map(gssCred.getName().toString(), System.getProperty("user.name"));
                    }
                    catch (Exception e) {
                        System.err.println("Failed to initialize gridmap file: " + e.getMessage());
                        System.exit(1);
                    }
                }
                props = null;
                if (configFile != null) {
                    props = new Properties();
                    in = null;
                    try {
                        in = new FileInputStream(configFile);
                        props.load(in);
                        var18_20 = null;
                        ** if (in == null) goto lbl-1000
                    }
                    catch (Throwable var17_28) {
                        var18_22 = null;
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        throw var17_28;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            in.close();
                        }
                        catch (Exception e) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block47;
                        catch (Exception e) {
                            System.err.println("Failed to load services configuration file: " + e.getMessage());
                            System.exit(1);
                            var18_21 = null;
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Exception e) {}
                            }
                        }
                    }
                }
            }
            if (debug) {
                BasicConfigurator.configure();
            } else {
                root = Logger.getRootLogger();
                root.addAppender((Appender)new AppenderSkeleton(){

                    public void close() {
                    }

                    public boolean requiresLayout() {
                        return false;
                    }

                    public void append(LoggingEvent event) {
                    }
                });
            }
            gk = null;
            try {
                gk = new GateKeeperServer((GSSCredential)gssCred, port);
                gk.setGridMap(gridMap);
                if (logFile != null) {
                    gk.setLogFile(logFile);
                }
                if (props != null) {
                    gk.registerServices(props);
                } else {
                    gk.registerService("jobmanager", "org.globus.gatekeeper.jobmanager.ForkJobManagerService", null);
                }
                System.out.println("GRAM contact: " + gk.getContact());
            }
            catch (Exception e) {
                System.err.println("Gatekeeper failed to start: " + e.getMessage());
                if (!debug) break block48;
                e.printStackTrace();
            }
        }
    }
}

