/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gatekeeper;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.globus.gatekeeper.GateKeeperClient;
import org.globus.gatekeeper.GateKeeperException;
import org.globus.gatekeeper.GateKeeperListener;
import org.globus.gatekeeper.Service;
import org.globus.gatekeeper.ServiceException;
import org.globus.gatekeeper.ServiceNotFoundException;
import org.globus.gsi.GSIConstants;
import org.globus.net.BaseServer;
import org.globus.security.gridmap.GridMap;
import org.globus.util.QuotedStringTokenizer;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public class GateKeeperServer
extends BaseServer {
    protected static final int PORT = 2119;
    private static final String LOG_PATTERN = "%-5p: %m%n";
    private Vector listeners;
    private Map _services;
    private GridMap _gridMap;
    private Logger _logger;
    static /* synthetic */ Class class$org$globus$gatekeeper$Service;

    public GateKeeperServer() throws IOException {
        this.init();
    }

    public GateKeeperServer(int port) throws IOException {
        super(port);
        this.init();
    }

    public GateKeeperServer(GSSCredential cred, int port) throws IOException {
        super(cred, port);
        this.init();
    }

    private void init() {
        this._services = new HashMap();
        this._logger = Logger.getLogger((String)(((Object)((Object)this)).getClass().getName() + "." + ((Object)((Object)this)).hashCode()));
        this.setAuthorization(null);
        this.setGssMode(GSIConstants.MODE_GSI);
    }

    public void setLogFile(String file) {
        FileAppender ap = new FileAppender();
        ap.setFile(file);
        ap.setName("Gatekeeper Log");
        ap.setLayout((Layout)new PatternLayout(LOG_PATTERN));
        ap.activateOptions();
        this._logger.addAppender((Appender)ap);
    }

    public void setGridMap(GridMap gridMap) {
        this._gridMap = gridMap;
    }

    public GridMap getGridMap() {
        return this._gridMap;
    }

    protected void handleConnection(Socket socket) {
        if (this._logger.isInfoEnabled()) {
            this._logger.info((Object)("Client connected: " + socket.getInetAddress() + ":" + socket.getPort()));
        }
        this.informListener(socket);
        GateKeeperClient c = new GateKeeperClient(this, socket);
        c.setLogger(this._logger);
        c.start();
    }

    public void addListener(GateKeeperListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(listener);
    }

    public void removeListener(GateKeeperListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(listener);
    }

    private void informListener(Socket aSocket) {
        if (this.listeners == null) {
            return;
        }
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            GateKeeperListener listener = (GateKeeperListener)this.listeners.elementAt(i);
            listener.connected(aSocket);
        }
    }

    public String getContact() throws UnknownHostException {
        String gid = null;
        try {
            gid = ((Object)this.getCredentials().getName()).toString();
        }
        catch (GSSException e) {
            return null;
        }
        StringBuffer url = new StringBuffer();
        url.append(this.getHost()).append(":").append(String.valueOf(this.getPort())).append(":").append(gid);
        return url.toString();
    }

    public void registerServices(Properties servicesInfo) throws Exception {
        Enumeration<Object> e = servicesInfo.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = servicesInfo.getProperty(key);
            this._services.put(key, this.parseServiceDesc(value));
        }
    }

    private ServiceInfo parseServiceDesc(String description) throws Exception {
        Class<?> clazz = null;
        String[] args = null;
        QuotedStringTokenizer tokens = new QuotedStringTokenizer(description);
        if (tokens.hasMoreTokens()) {
            String className = null;
            className = tokens.nextToken().trim();
            try {
                clazz = Class.forName(className);
            }
            catch (Exception e) {
                throw new Exception("Failed to load service class: " + className + ", " + e.getMessage());
            }
            if (!(class$org$globus$gatekeeper$Service == null ? (class$org$globus$gatekeeper$Service = GateKeeperServer.class$("org.globus.gatekeeper.Service")) : class$org$globus$gatekeeper$Service).isAssignableFrom(clazz)) {
                throw new Exception("Service class must be of Service type");
            }
        } else {
            throw new Exception("No service classname specified");
        }
        if (tokens.hasMoreTokens()) {
            int i = 0;
            args = new String[tokens.countTokens()];
            while (tokens.hasMoreTokens()) {
                args[i++] = tokens.nextToken().trim();
            }
        }
        return new ServiceInfo(clazz, args);
    }

    public Service getService(String serviceName) throws GateKeeperException {
        ServiceInfo info = (ServiceInfo)this._services.get(serviceName);
        if (info == null) {
            throw new ServiceNotFoundException(serviceName);
        }
        Service ser = null;
        try {
            ser = (Service)info.getServiceClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new ServiceNotFoundException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ServiceNotFoundException(e.getMessage());
        }
        try {
            ser.setArguments(info.getArguments());
        }
        catch (ServiceException e) {
            throw new GateKeeperException(e.getMessage());
        }
        return ser;
    }

    public void registerService(String serviceName, String className, String[] args) throws ClassNotFoundException {
        this.registerService(serviceName, Class.forName(className), args);
    }

    public void registerService(String serviceName, Class clazz, String[] args) {
        if (!(class$org$globus$gatekeeper$Service == null ? (class$org$globus$gatekeeper$Service = GateKeeperServer.class$("org.globus.gatekeeper.Service")) : class$org$globus$gatekeeper$Service).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Service class must be of Service type : " + clazz);
        }
        this._services.put(serviceName, new ServiceInfo(clazz, args));
    }

    public boolean unregisterService(String serviceName) {
        return this._services.remove(serviceName) != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ServiceInfo {
        Class _clazz;
        String[] _args;

        public ServiceInfo(Class clazz, String[] args) {
            this._clazz = clazz;
            this._args = args;
        }

        public Class getServiceClass() {
            return this._clazz;
        }

        public String[] getArguments() {
            return this._args;
        }
    }
}

