/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.spdy;

import org.jboss.netty.handler.codec.spdy.SpdyGoAwayFrame;
import org.jboss.netty.handler.codec.spdy.SpdySessionStatus;
import org.jboss.netty.util.internal.StringUtil;

public class DefaultSpdyGoAwayFrame
implements SpdyGoAwayFrame {
    private int lastGoodStreamID;
    private SpdySessionStatus status;

    public DefaultSpdyGoAwayFrame(int lastGoodStreamID) {
        this(lastGoodStreamID, 0);
    }

    public DefaultSpdyGoAwayFrame(int lastGoodStreamID, int statusCode) {
        this(lastGoodStreamID, SpdySessionStatus.valueOf(statusCode));
    }

    public DefaultSpdyGoAwayFrame(int lastGoodStreamID, SpdySessionStatus status) {
        this.setLastGoodStreamID(lastGoodStreamID);
        this.setStatus(status);
    }

    public int getLastGoodStreamID() {
        return this.lastGoodStreamID;
    }

    public void setLastGoodStreamID(int lastGoodStreamID) {
        if (lastGoodStreamID < 0) {
            throw new IllegalArgumentException("Last-good-stream-ID cannot be negative: " + lastGoodStreamID);
        }
        this.lastGoodStreamID = lastGoodStreamID;
    }

    public SpdySessionStatus getStatus() {
        return this.status;
    }

    public void setStatus(SpdySessionStatus status) {
        this.status = status;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Last-good-stream-ID = ");
        buf.append(this.lastGoodStreamID);
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Status: ");
        buf.append(this.status.toString());
        return buf.toString();
    }
}

