/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.frame;

import java.net.SocketAddress;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.LifeCycleAwareChannelHandler;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public abstract class FrameDecoder
extends SimpleChannelUpstreamHandler
implements LifeCycleAwareChannelHandler {
    private final boolean unfold;
    protected ChannelBuffer cumulation;
    private volatile ChannelHandlerContext ctx;

    protected FrameDecoder() {
        this(false);
    }

    protected FrameDecoder(boolean unfold) {
        this.unfold = unfold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ChannelBuffer buf;
        Object m = e.getMessage();
        if (!(m instanceof ChannelBuffer)) {
            ctx.sendUpstream(e);
            return;
        }
        ChannelBuffer input = (ChannelBuffer)m;
        if (!input.readable()) {
            return;
        }
        if (this.cumulation == null) {
            try {
                this.callDecode(ctx, e.getChannel(), input, e.getRemoteAddress());
            }
            finally {
                if (input.readable()) {
                    this.cumulation = this.newCumulationBuffer(ctx, input.readableBytes());
                    this.cumulation.writeBytes(input);
                }
            }
        }
        assert (this.cumulation.readable());
        boolean fit = false;
        int readable = input.readableBytes();
        int writable = this.cumulation.writableBytes();
        int w = writable - readable;
        if (w < 0) {
            int readerIndex = this.cumulation.readerIndex();
            if (w + readerIndex >= 0) {
                this.cumulation.discardReadBytes();
                fit = true;
            }
        } else {
            fit = true;
        }
        if (fit) {
            buf = this.cumulation;
            buf.writeBytes(input);
        } else {
            this.cumulation = buf = ChannelBuffers.wrappedBuffer(this.cumulation, input);
        }
        try {
            this.callDecode(ctx, e.getChannel(), buf, e.getRemoteAddress());
        }
        finally {
            if (!buf.readable()) {
                this.cumulation = null;
            } else {
                this.cumulation = this.newCumulationBuffer(ctx, buf.readableBytes());
                this.cumulation.writeBytes(buf);
            }
        }
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.cleanup(ctx, e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.cleanup(ctx, e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    protected abstract Object decode(ChannelHandlerContext var1, Channel var2, ChannelBuffer var3) throws Exception;

    protected Object decodeLast(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        return this.decode(ctx, channel, buffer);
    }

    private void callDecode(ChannelHandlerContext context, Channel channel, ChannelBuffer cumulation, SocketAddress remoteAddress) throws Exception {
        while (cumulation.readable()) {
            int oldReaderIndex = cumulation.readerIndex();
            Object frame = this.decode(context, channel, cumulation);
            if (frame == null) {
                if (oldReaderIndex != cumulation.readerIndex()) continue;
                break;
            }
            if (oldReaderIndex == cumulation.readerIndex()) {
                throw new IllegalStateException("decode() method must read at least one byte if it returned a frame (caused by: " + this.getClass() + ")");
            }
            this.unfoldAndFireMessageReceived(context, remoteAddress, frame);
        }
    }

    protected final void unfoldAndFireMessageReceived(ChannelHandlerContext context, SocketAddress remoteAddress, Object result) {
        if (this.unfold) {
            if (result instanceof Object[]) {
                for (Object r : (Object[])result) {
                    Channels.fireMessageReceived(context, r, remoteAddress);
                }
            } else if (result instanceof Iterable) {
                for (Object r : (Iterable)result) {
                    Channels.fireMessageReceived(context, r, remoteAddress);
                }
            } else {
                Channels.fireMessageReceived(context, result, remoteAddress);
            }
        } else {
            Channels.fireMessageReceived(context, result, remoteAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        try {
            Object partialFrame;
            ChannelBuffer cumulation = this.cumulation;
            if (cumulation == null) {
                return;
            }
            this.cumulation = null;
            if (cumulation.readable()) {
                this.callDecode(ctx, ctx.getChannel(), cumulation, null);
            }
            if ((partialFrame = this.decodeLast(ctx, ctx.getChannel(), cumulation)) != null) {
                this.unfoldAndFireMessageReceived(ctx, null, partialFrame);
            }
        }
        finally {
            ctx.sendUpstream(e);
        }
    }

    protected ChannelBuffer newCumulationBuffer(ChannelHandlerContext ctx, int minimumCapacity) {
        ChannelBufferFactory factory = ctx.getChannel().getConfig().getBufferFactory();
        return factory.getBuffer(Math.max(minimumCapacity, 256));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(String handlerName, ChannelHandler handler) {
        if (this.ctx == null) {
            throw new IllegalStateException("Replace cann only be called once the FrameDecoder is added to the ChannelPipeline");
        }
        ChannelPipeline pipeline = this.ctx.getPipeline();
        pipeline.addAfter(this.ctx.getName(), handlerName, handler);
        try {
            if (this.cumulation != null) {
                Channels.fireMessageReceived(this.ctx, (Object)this.cumulation.readBytes(this.actualReadableBytes()));
            }
        }
        finally {
            pipeline.remove(this);
        }
    }

    protected int actualReadableBytes() {
        return this.internalBuffer().readableBytes();
    }

    protected ChannelBuffer internalBuffer() {
        ChannelBuffer buf = this.cumulation;
        if (buf == null) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        return buf;
    }

    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
    }

    public void afterAdd(ChannelHandlerContext ctx) throws Exception {
    }

    public void beforeRemove(ChannelHandlerContext ctx) throws Exception {
    }

    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
    }
}

