import datetime
import logging

from storm.monitoring.sensor.api import sensor
from storm.monitoring.sensor.api import metrics
from storm.monitoring.sensor.api import services
from storm.monitoring.sensor.api import measure
from storm.monitoring.sensor.host.mem import mem_check
from storm.monitoring.sensor.api import measures

class MemSensor(sensor.Sensor):

    def __init__(self, hostname, service_types):
        self.logger = logging.getLogger("storm_sensor.mem_sensor")
        self.logger.info("creating an instance of MemSensor")

        self.hostname = hostname
        self.metric_type = metrics.Metrics().mem
        for val in service_types:
            if val not in services.Services().get_services():
                msg = 'The specified servive type %s does not exist' % str(val)
                raise services.ServicesError(msg)
        self.service_types = service_types
        self.timestamp = ''
        self.measures = measures.Measures()

    def get_hostname(self):
        """Return hostname information"""
        self.logger.info("getting hostname")
        return self.hostname

    def run(self):
        """Run sensor and save data"""
        self.logger.info("doing run")
        self.timestamp = datetime.datetime.now()
        output = mem_check.Free()
        self.measures.add_measure(output.get_used())
        self.measures.add_measure(output.get_free())
        self.get_measures()

    def get_measures(self):
        """Return measures"""
        self.logger.info("getting measures")
        return self.measures

    def get_timestamp(self):
        """Return timestamp"""
        self.logger.info("getting timestamp")
        return self.timestamp

    def get_metric_type(self):
        """Return metric type"""
        self.logger.info("getting measures")
        return self.metric_type

    def get_storm_service_types(self):
        """Return storm service types"""
        self.logger.info("getting storm service types")
        return self.service_types
