import os
import exceptions
import logging

from storm.monitoring.sensor.api import units
from storm.monitoring.sensor.api import measure

class FreeError(exceptions.Exception):
    pass

class Free(object):
    """Checks memory of a given system"""
         
    def __init__(self):
        self.logger = logging.getLogger("storm_sensor.mem_check")
        self.logger.info("creating an instance of Free")

        if os.name == "posix":
            used,free,unit = self.linux_ram()
            self.used = measure.Measure(used, unit, 'used memory')
            self.free = measure.Measure(free, unit, 'free memory')
        else:   
            raise FreeError('I only work with Linux :P')
         
    def linux_ram(self):
        """Returns the RAM of a linux system"""
        self.logger.info("getting linux ram information")
        used_memory,free_memory = os.popen("free -m").readlines()[1].split()[2:4]
        return int(used_memory), int(free_memory), units.Units().m_byte

    def get_used(self):
        self.logger.info("getting used ram information")
        return self.used

    def get_free(self):
        self.logger.info("getting free ram information")
        return self.free

     
