import os
import logging

from storm.monitoring.sensor.api import publisher
from storm.monitoring.sensor.api import metrics
from storm.monitoring.sensor.api import services

class FilePublisher(publisher.Publisher):

    file_name_prefix = 'monitoring_sensor'

    def __init__(self, directory):
        self.logger = logging.getLogger('storm_sensor.file_publisher')
        self.logger.info('creating an instance of FilePublisher')

        #check that directory ends with a slash, in case not, add it
        self.file_path_prefix = directory + FilePublisher.file_name_prefix
        self.ids = {}

    def do_publish(self, services_list, metric, data):
        self.logger.info('doing publish')
        string_metric = metrics.Metrics().get_string_metric(metric)

        new_services_value = ' '
        for val in services_list:
            new_services_value += services.Services().get_string_service(val) + ' '

        filename = self.file_path_prefix   + '_' + string_metric
        if filename not in self.ids.keys() or os.path.isfile(filename):
            id_file = open(filename, "a")
            self.ids[filename]=id_file
            id_file.write("\n")
        else:
            id_file = self.ids[filename]
            id_file.write("\n") 

        id_file.write("%s %s %s" % (data, string_metric, new_services_value))
