__author__ = 'Elisabetta Ronchieri'

import ConfigParser
import os
import exceptions
import logging

class NodeServicesError(exceptions.Exception):
    pass

class NodeServices:
    def __init__(self, conf='services.ini'):
        self.logger = logging.getLogger('storm_sensor.configuration_parser')
        self.logger.info('creating an instance of NodeServices')

        self.conf_fn = conf
        self.node_services = {}

    def get_node_services(self):
        self.logger.info('getting node services')
        parser = ConfigParser.ConfigParser()
        try:
            parser.read(self.conf_fn)
        except ConfigParser.ParsingError,err:
            print 'Could not be parsed:', err

        for section in parser.sections():
            self.node_services[section] = {}
            for option in parser.options(section):
                if parser.get(section,option).lower() not in ('true','false'):
                    msg = 'The configuration file is not well formed. '
                    msg += 'Please check options values that can be just true or false.'
                    raise NodeServicesError(msg)
                else:
                   self.node_services[section][option]= parser.get(section,option)

        return self.node_services
