import exceptions

class UnitsError(exceptions.Exception):
    pass

class Units(object):

    byte=0
    g_byte=1
    m_byte=2
    k_byte=3
    t_byte=4
    second=5
    percentage=6
    kB = 7

    def __init__(self):
        self.units_types = {
            'byte':[Units.byte,
                Units.g_byte,
                Units.m_byte,
                Units.k_byte,
                Units.t_byte,
                Units.kB],
            'time':[Units.second],
            'other':[Units.percentage]
            }

        self.string_units = {
            Units.byte: 'byte',
            Units.g_byte: 'GB',
            Units.m_byte: 'MB',
            Units.k_byte: 'KB',
            Units.t_byte: 'TB',
            Units.second: 'second',
            Units.percentage: '%',
            Units.kB: 'kB'
            }

    def is_unit(self, unit_type):
        if int(unit_type) in self.string_units.keys():
            return True
        return False

    def get_units(self):
        units = []
        for x in self.units_types.values():
            units.extend(x)
        return units

    def get_string_units(self):
        return self.string_units

    def get_string_unit(self, unit_type):
        if self.is_unit(unit_type):
            return self.string_units[unit_type]
        else:
            msg = 'The specified unit %s is wrong' % str(unit_type)
            raise UnitsError(msg)
