#ifndef RUNNABLE_PRODUCER
/* RunnableConsumer
 * A simple runnable that waits for messages
 *
 *
 * by Fabrizio Furano, CERN, Oct 2010
 */

#include "SimpleConsumer.hh"
#include "SimpleDebug.hh"
#include <decaf/lang/Runnable.h>
#include <decaf/lang/Thread.h>
#include <decaf/util/concurrent/CountDownLatch.h>

class RunnableConsumer : public decaf::lang::Runnable, public SimpleConsumer {
private:
   bool isConnected, isTerminated;

public:
   RunnableConsumer( const std::string& brokerURI,
                        const std::string& destname,
                        bool useTopic = false,
                        bool sessionTransacted = false ):
     decaf::lang::Runnable(), SimpleConsumer(brokerURI, destname, useTopic, sessionTransacted),
     isConnected(false), isTerminated(false) {  };

   virtual ~RunnableConsumer() throw() {
      
   }

   // Called from the consumer since this class is a registered MessageListener.
   // This implementation only adds the counting functionality to the default one
   virtual void onMessage( const cms::Message* message ) throw() {

      SimpleConsumer::onMessage(message);

   }


   virtual void onException (const cms::CMSException &ex) throw (){

     Info(SimpleDebug::kMEDIUM, "RunnableConsumer::onException", "Caught Exception " << ex.getStackTraceString());

     // Something went wrong with the connection with the broker
     // we have to trigger a reconnection attempt
     isConnected = false;
     
   }

   virtual void run() {

      while (!isTerminated) {
      
         if (!isConnected) {
            // Here we try to connect. If it fails retry for some time.
            Info(SimpleDebug::kMEDIUM, "RunnableMsgConsumer::run", "Trying to connect to the messaging infrastructure...");
            
            if (Connect()) 
               Error("RunnableMsgConsumer::run", "Connection failed.")
               else {
                  Info(SimpleDebug::kMEDIUM, "RunnableMsgConsumer::run", "Connected to the messaging infrastructure.");
                  isConnected = true;
               }
            
         }


         // Sloppy but good enough implementation of an interruptible sleep
         for (int i = 1; !isTerminated && (i < 5); i++)
	   decaf::lang::Thread::sleep(1000);
         
      }

   }



};




#endif
