/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.ui.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;

public class PasswordReader
implements Runnable {
    private volatile boolean masking;
    private char echochar = (char)42;

    public static final char[] getPassword(InputStream in, String prompt) throws IOException {
        char[] lineBuffer;
        PasswordReader maskingThread = new PasswordReader(prompt);
        maskingThread.setEchoChar(' ');
        Thread thread = new Thread(maskingThread);
        thread.start();
        char[] buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            int c = in.read();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int c2 = in.read();
                    if (c2 == 10 || c2 == -1) break block4;
                    if (!(in instanceof PushbackInputStream)) {
                        in = new PushbackInputStream(in);
                    }
                    ((PushbackInputStream)in).unread(c2);
                }
                default: {
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(lineBuffer, 0, buf, 0, offset);
                        Arrays.fill(lineBuffer, ' ');
                        lineBuffer = buf;
                    }
                    buf[offset++] = (char)c;
                    continue block4;
                }
            }
            break;
        }
        maskingThread.stopMasking();
        if (offset == 0) {
            return null;
        }
        char[] ret = new char[offset];
        System.arraycopy(buf, 0, ret, 0, offset);
        Arrays.fill(buf, ' ');
        return ret;
    }

    private PasswordReader(String prompt) {
        System.out.print(prompt);
        System.out.flush();
        this.masking = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        int priority = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(10);
        try {
            while (this.masking) {
                System.out.print("\b" + this.echochar);
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException iex) {
                    Thread.currentThread().interrupt();
                    Thread.currentThread().setPriority(priority);
                    return;
                }
            }
        }
        finally {
            Thread.currentThread().setPriority(priority);
        }
    }

    private void stopMasking() {
        this.masking = false;
    }

    private void setEchoChar(char c) {
        this.echochar = c;
    }
}

